/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest.auth;

import org.apache.paimon.options.Options;
import org.apache.paimon.rest.RESTCatalogOptions;
import org.apache.paimon.rest.auth.BearTokenCredentialsProvider;
import org.apache.paimon.rest.auth.CredentialsProvider;
import org.apache.paimon.rest.auth.CredentialsProviderFactory;
import org.apache.paimon.rest.auth.CredentialsProviderType;
import org.apache.paimon.utils.StringUtils;

public class BearTokenCredentialsProviderFactory
implements CredentialsProviderFactory {
    @Override
    public String identifier() {
        return CredentialsProviderType.BEAR_TOKEN.name();
    }

    @Override
    public CredentialsProvider create(Options options) {
        if (options.getOptional(RESTCatalogOptions.TOKEN).map(StringUtils::isNullOrWhitespaceOnly).orElse(true).booleanValue()) {
            throw new IllegalArgumentException(RESTCatalogOptions.TOKEN.key() + " is required and not empty");
        }
        return new BearTokenCredentialsProvider(options.get(RESTCatalogOptions.TOKEN));
    }
}

