/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.SingletonSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SerializationUtils;

public class OptionsTable
implements ReadonlyTable {
    private static final long serialVersionUID = 2L;
    public static final String OPTIONS = "options";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "key", SerializationUtils.newStringType(false)), new DataField(1, "value", SerializationUtils.newStringType(false))));
    private final FileIO fileIO;
    private final Path location;
    private final FileStoreTable dataTable;

    public OptionsTable(FileStoreTable dataTable) {
        this.fileIO = dataTable.fileIO();
        this.location = dataTable.location();
        this.dataTable = dataTable;
    }

    @Override
    public String name() {
        return this.location.getName() + "$" + OPTIONS;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("key");
    }

    @Override
    public InnerTableScan newScan() {
        return new OptionsScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new OptionsRead(this.fileIO);
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new OptionsTable((FileStoreTable)this.dataTable.copy((Map)dynamicOptions));
    }

    private class OptionsRead
    implements InnerTableRead {
        private final FileIO fileIO;
        private RowType readType;

        public OptionsRead(FileIO fileIO) {
            this.fileIO = fileIO;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withReadType(RowType readType) {
            this.readType = readType;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) {
            if (!(split instanceof OptionsSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            Iterator rows = Iterators.transform(OptionsTable.this.dataTable.schemaManager().latest().orElseThrow(() -> new RuntimeException("Table not exists.")).options().entrySet().iterator(), this::toRow);
            if (this.readType != null) {
                rows = Iterators.transform(rows, row -> ProjectedRow.from(this.readType, TABLE_TYPE).replaceRow((InternalRow)row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }

        private InternalRow toRow(Map.Entry<String, String> option) {
            return GenericRow.of(BinaryString.fromString(option.getKey()), BinaryString.fromString(option.getValue()));
        }
    }

    private static class OptionsSplit
    extends SingletonSplit {
        private static final long serialVersionUID = 1L;
        private final Path location;

        private OptionsSplit(Path location) {
            this.location = location;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OptionsSplit that = (OptionsSplit)o;
            return Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.location);
        }
    }

    private class OptionsScan
    extends ReadOnceTableScan {
        private OptionsScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new OptionsSplit(OptionsTable.this.location));
        }
    }
}

