/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.types.Row;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.util.AbstractTestBase;
import org.apache.paimon.flink.util.ReadWriteTableTestUtil;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CompositePkAndMultiPartitionedTableITCase
extends AbstractTestBase {
    private final Map<String, String> staticPartitionOverwrite = Collections.singletonMap(CoreOptions.DYNAMIC_PARTITION_OVERWRITE.key(), "false");

    @BeforeEach
    public void setUp() {
        ReadWriteTableTestUtil.init(this.getTempDirPath());
    }

    @Test
    public void testBatchWriteWithMultiPartitionedRecordsWithMultiPk() throws Exception {
        List<Row> initialRecords = Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", "US Dollar", 1.11, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"HK Dollar", "US Dollar", 0.13, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.0082, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "US Dollar", 0.74, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.0081, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", "US Dollar", 1.12, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"HK Dollar", "US Dollar", 0.129, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.0081, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "US Dollar", 0.741, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.00812, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "Euro", 0.918, "2022-01-02", "23"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "Euro", 0.67, "2022-01-02", "23"}));
        String temporaryTable = ReadWriteTableTestUtil.createTemporaryTable(Arrays.asList("from_currency STRING", "to_currency STRING", "rate_by_to_currency DOUBLE", "dt STRING", "hh STRING"), Arrays.asList("from_currency", "to_currency", "dt", "hh"), Arrays.asList("dt", "hh"), initialRecords, "dt:2022-01-01,hh:11;dt:2022-01-01,hh:12;dt:2022-01-02,hh:23", true, "I");
        String table = ReadWriteTableTestUtil.createTable(Arrays.asList("from_currency STRING", "to_currency STRING", "rate_by_to_currency DOUBLE", "dt STRING", "hh STRING"), Arrays.asList("from_currency", "to_currency", "dt", "hh"), Collections.emptyList(), Arrays.asList("dt", "hh"));
        ReadWriteTableTestUtil.insertIntoFromTable(temporaryTable, table);
        ReadWriteTableTestUtil.checkFileStorePath(table, Arrays.asList("dt=2022-01-01,hh=11", "dt=2022-01-01,hh=12", "dt=2022-01-02,hh=23"));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildSimpleQuery(table), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", "US Dollar", 1.11, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"HK Dollar", "US Dollar", 0.13, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "US Dollar", 0.74, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.0081, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", "US Dollar", 1.12, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"HK Dollar", "US Dollar", 0.129, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "US Dollar", 0.741, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.00812, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "Euro", 0.918, "2022-01-02", "23"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "Euro", 0.67, "2022-01-02", "23"})));
        ReadWriteTableTestUtil.insertOverwritePartition(table, "PARTITION (dt = '2022-01-02', hh = '23')", "('US Dollar', 'Thai Baht', 33.51)");
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "*", "WHERE dt = '2022-01-02' AND hh = '23'"), Collections.singletonList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "Thai Baht", 33.51, "2022-01-02", "23"})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "*", "WHERE dt = '2022-01-01'"), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", "US Dollar", 1.11, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"HK Dollar", "US Dollar", 0.13, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "US Dollar", 0.74, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.0081, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", "US Dollar", 1.12, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"HK Dollar", "US Dollar", 0.129, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "US Dollar", 0.741, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.00812, "2022-01-01", "12"})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "*", "WHERE dt = '2022-01-01' AND hh = '12'"), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", "US Dollar", 1.12, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"HK Dollar", "US Dollar", 0.129, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "US Dollar", 0.741, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.00812, "2022-01-01", "12"})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "*", "WHERE to_currency = 'Euro'"), Collections.emptyList());
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "*", "WHERE from_currency = 'HK Dollar'"), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"HK Dollar", "US Dollar", 0.13, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"HK Dollar", "US Dollar", 0.129, "2022-01-01", "12"})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "*", "WHERE rate_by_to_currency > 0.5"), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", "US Dollar", 1.11, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "US Dollar", 0.74, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0, "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", "US Dollar", 1.12, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "US Dollar", 0.741, "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "Thai Baht", 33.51, "2022-01-02", "23"})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "*", "WHERE rate_by_to_currency > 1 AND hh = '12'"), Collections.singletonList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", "US Dollar", 1.12, "2022-01-01", "12"})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "from_currency, dt, hh", ""), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"HK Dollar", "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "2022-01-01", "11"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"HK Dollar", "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "2022-01-01", "12"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "2022-01-02", "23"})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "from_currency, to_currency", "WHERE dt = '2022-01-01' AND hh >= '12' OR rate_by_to_currency > 2"), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", "US Dollar"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"HK Dollar", "US Dollar"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "US Dollar"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "Thai Baht"})));
    }

    @Test
    public void testBatchWriteWithSinglePartitionedRecordsWithMultiPk() throws Exception {
        List<Row> initialRecords = Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", "US Dollar", 1.11, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"HK Dollar", "US Dollar", 0.13, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.0082, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "US Dollar", 0.74, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.0081, "2022-01-02"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0, "2022-01-02"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "Euro", 0.9, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "Euro", 0.67, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "Yen", 1.0, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Chinese Yuan", "Yen", 19.25, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "Yen", 90.32, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "Yen", 122.46, "2022-01-01"}));
        String temporaryTable = ReadWriteTableTestUtil.createTemporaryTable(Arrays.asList("from_currency STRING", "to_currency STRING", "rate_by_to_currency DOUBLE", "dt STRING"), Arrays.asList("from_currency", "to_currency", "dt"), Collections.singletonList("dt"), initialRecords, "dt:2022-01-01;dt:2022-01-02", true, "I");
        String table = ReadWriteTableTestUtil.createTable(Arrays.asList("from_currency STRING", "to_currency STRING", "rate_by_to_currency DOUBLE", "dt STRING"), Arrays.asList("from_currency", "to_currency", "dt"), Collections.emptyList(), Collections.singletonList("dt"), this.staticPartitionOverwrite);
        ReadWriteTableTestUtil.insertIntoFromTable(temporaryTable, table);
        ReadWriteTableTestUtil.checkFileStorePath(table, Arrays.asList("dt=2022-01-01", "dt=2022-01-02"));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildSimpleQuery(table), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", "US Dollar", 1.11, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"HK Dollar", "US Dollar", 0.13, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.0082, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "US Dollar", 0.74, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.0081, "2022-01-02"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0, "2022-01-02"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "Euro", 0.9, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "Euro", 0.67, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "Yen", 1.0, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Chinese Yuan", "Yen", 19.25, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "Yen", 122.46, "2022-01-01"})));
        ReadWriteTableTestUtil.insertOverwrite(table, "('US Dollar', 'Thai Baht', 33.51, '2022-01-01')");
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildSimpleQuery(table), Collections.singletonList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "Thai Baht", 33.51, "2022-01-01"})));
        table = ReadWriteTableTestUtil.createTable(Arrays.asList("from_currency STRING", "to_currency STRING", "rate_by_to_currency DOUBLE", "dt STRING"), Arrays.asList("from_currency", "to_currency", "dt"), Collections.emptyList(), Collections.singletonList("dt"));
        ReadWriteTableTestUtil.insertIntoFromTable(temporaryTable, table);
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "*", "WHERE dt = '2022-01-02'"), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.0081, "2022-01-02"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0, "2022-01-02"})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "*", "WHERE rate_by_to_currency < 0.1"), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.0082, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.0081, "2022-01-02"})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "*", "WHERE rate_by_to_currency > 0.9 OR dt = '2022-01-02'"), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", "US Dollar", 1.11, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "Yen", 1.0, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Chinese Yuan", "Yen", 19.25, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "Yen", 122.46, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.0081, "2022-01-02"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0, "2022-01-02"})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "rate_by_to_currency, dt", ""), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{1.0, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{1.11, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{0.13, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{0.0082, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{0.74, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{0.9, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{0.67, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{1.0, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{19.25, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{122.46, "2022-01-01"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{0.0081, "2022-01-02"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{1.0, "2022-01-02"})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "from_currency, to_currency", "WHERE dt = '2022-01-02' OR rate_by_to_currency > 100"), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "Yen"})));
    }

    @Test
    public void testBatchWriteWithNonPartitionedRecordsWithMultiPk() throws Exception {
        List<Row> initialRecords = Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", "US Dollar", 1.11}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"HK Dollar", "US Dollar", 0.13}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.0082}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "US Dollar", 0.74}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.0081}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "Euro", 0.9}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "Euro", 0.67}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "Yen", 1.0}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Chinese Yuan", "Yen", 19.25}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "Yen", 90.32}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "Yen", 122.46}));
        String temporaryTable = ReadWriteTableTestUtil.createTemporaryTable(Arrays.asList("from_currency STRING", "to_currency STRING", "rate_by_to_currency DOUBLE"), Arrays.asList("from_currency", "to_currency"), Collections.emptyList(), initialRecords, null, true, "I");
        String table = ReadWriteTableTestUtil.createTable(Arrays.asList("from_currency STRING", "to_currency STRING", "rate_by_to_currency DOUBLE"), Arrays.asList("from_currency", "to_currency"), Collections.emptyList(), Collections.emptyList());
        ReadWriteTableTestUtil.insertIntoFromTable(temporaryTable, table);
        ReadWriteTableTestUtil.checkFileStorePath(table, Collections.emptyList());
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildSimpleQuery(table), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", "US Dollar", 1.11}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"HK Dollar", "US Dollar", 0.13}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "US Dollar", 0.74}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.0081}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "US Dollar", 1.0}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", "Euro", 0.9}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "Euro", 0.67}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "Yen", 1.0}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Chinese Yuan", "Yen", 19.25}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "Yen", 122.46})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "*", "WHERE rate_by_to_currency < 0.1"), Collections.singletonList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", "US Dollar", 0.0081})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "rate_by_to_currency", ""), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{1.11}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{0.13}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{0.74}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{0.0081}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{1.0}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{0.9}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{0.67}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{1.0}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{19.25}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{122.46})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "from_currency, to_currency", "WHERE rate_by_to_currency > 100"), Collections.singletonList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Singapore Dollar", "Yen"})));
    }

    @Test
    public void testBatchWriteMultiPartitionedRecordsWithOnePk() throws Exception {
        List<Row> initialRecords = Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", 102L, "2022-01-01", "00"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 114L, "2022-01-01", "00"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", 1L, "2022-01-01", "00"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 114L, "2022-01-01", "00"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", 114L, "2022-01-01", "00"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", 102L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 114L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", 1L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 114L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", 114L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 119L, "2022-01-02", "12"}));
        String temporaryTable = ReadWriteTableTestUtil.createTemporaryTable(Arrays.asList("currency STRING", "rate BIGINT", "dt STRING", "hh STRING"), Arrays.asList("currency", "dt", "hh"), Arrays.asList("dt", "hh"), initialRecords, "dt:2022-01-01,hh:00;dt:2022-01-01,hh:20;dt:2022-01-02,hh:12", true, "I");
        String table = ReadWriteTableTestUtil.createTable(Arrays.asList("currency STRING", "rate BIGINT", "dt STRING", "hh STRING"), Arrays.asList("currency", "dt", "hh"), Collections.emptyList(), Arrays.asList("dt", "hh"));
        ReadWriteTableTestUtil.insertIntoFromTable(temporaryTable, table);
        ReadWriteTableTestUtil.checkFileStorePath(table, Arrays.asList("dt=2022-01-01,hh=00", "dt=2022-01-01,hh=20", "dt=2022-01-02,hh=12"));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildSimpleQuery(table), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", 1L, "2022-01-01", "00"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 114L, "2022-01-01", "00"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", 114L, "2022-01-01", "00"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", 1L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 114L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", 114L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 119L, "2022-01-02", "12"})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "*", "WHERE hh >= '10'"), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", 1L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 114L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", 114L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 119L, "2022-01-02", "12"})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "*", "WHERE rate >= 119"), Collections.singletonList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 119L, "2022-01-02", "12"})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "hh", ""), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"00"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"00"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"00"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"12"})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "rate", "WHERE rate > 100 AND hh >= '20'"), Collections.nCopies(2, TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{114L})));
    }

    @Test
    public void testBatchWriteMultiPartitionedRecordsWithoutPk() throws Exception {
        List<Row> initialRecords = Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", 102L, "2022-01-01", "00"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 114L, "2022-01-01", "00"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", 1L, "2022-01-01", "00"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 114L, "2022-01-01", "00"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", 114L, "2022-01-01", "00"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", 102L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 114L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", 1L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 114L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", 114L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 119L, "2022-01-02", "12"}));
        String temporaryTable = ReadWriteTableTestUtil.createTemporaryTable(Arrays.asList("currency STRING", "rate BIGINT", "dt STRING", "hh STRING"), Collections.emptyList(), Arrays.asList("dt", "hh"), initialRecords, "dt:2022-01-01,hh:00;dt:2022-01-01,hh:20;dt:2022-01-02,hh:12", true, "I");
        String table = ReadWriteTableTestUtil.createTable(Arrays.asList("currency STRING", "rate BIGINT", "dt STRING", "hh STRING"), Collections.emptyList(), Collections.singletonList("currency"), Arrays.asList("dt", "hh"), this.staticPartitionOverwrite);
        ReadWriteTableTestUtil.insertIntoFromTable(temporaryTable, table);
        ReadWriteTableTestUtil.checkFileStorePath(table, Arrays.asList("dt=2022-01-01,hh=00", "dt=2022-01-01,hh=20", "dt=2022-01-02,hh=12"));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildSimpleQuery(table), initialRecords);
        ReadWriteTableTestUtil.bEnv.executeSql(String.format("INSERT OVERWRITE `%s` SELECT 'Yen', 1, CAST(NULL AS STRING), CAST(NULL AS STRING) FROM `%s`", table, table)).await();
        ReadWriteTableTestUtil.checkFileStorePath(table, Collections.singletonList("dt=null,hh=null"));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildSimpleQuery(table), Collections.nCopies(11, TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", 1L, null, null})));
        table = ReadWriteTableTestUtil.createTable(Arrays.asList("currency STRING", "rate BIGINT", "dt STRING", "hh STRING"), Collections.emptyList(), Collections.singletonList("currency"), Arrays.asList("dt", "hh"));
        ReadWriteTableTestUtil.insertIntoFromTable(temporaryTable, table);
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "*", "WHERE hh >= '10'"), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", 102L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 114L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen", 1L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 114L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar", 114L, "2022-01-01", "20"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 119L, "2022-01-02", "12"})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "*", "WHERE rate >= 119"), Collections.singletonList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro", 119L, "2022-01-02", "12"})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "currency", ""), Arrays.asList(TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Yen"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"US Dollar"}), TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{"Euro"})));
        ReadWriteTableTestUtil.testBatchRead(ReadWriteTableTestUtil.buildQuery(table, "rate", "WHERE rate > 110 AND hh >= '20'"), Collections.nCopies(3, TestValuesTableFactory.changelogRow((String)"+I", (Object[])new Object[]{114L})));
    }
}

