/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogDatabaseImpl;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.IntervalFreshness;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedCatalogMaterializedTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.SchemaResolver;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.catalog.TestSchemaResolver;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.utils.ResolvedExpressionMock;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.refresh.RefreshHandler;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.TableType;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.FlinkCatalog;
import org.apache.paimon.flink.FlinkCatalogFactory;
import org.apache.paimon.flink.FlinkCatalogOptions;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.FlinkTableFactory;
import org.apache.paimon.flink.FlinkTestBase;
import org.apache.paimon.flink.log.LogSinkProvider;
import org.apache.paimon.flink.log.LogSourceProvider;
import org.apache.paimon.flink.log.LogStoreRegister;
import org.apache.paimon.flink.log.LogStoreTableFactory;
import org.apache.paimon.fs.Path;
import org.apache.paimon.options.Options;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FlinkCatalogTest {
    private static final String TESTING_LOG_STORE = "testing";
    private final ObjectPath path1 = new ObjectPath("db1", "t1");
    private final ObjectPath path3 = new ObjectPath("db1", "t2");
    private final ObjectPath tableInDefaultDb = new ObjectPath("default", "t1");
    private final ObjectPath tableInDefaultDb1 = new ObjectPath("default-db", "t1");
    private final ObjectPath nonExistDbPath = ObjectPath.fromString((String)"non.exist");
    private final ObjectPath nonExistObjectPath = ObjectPath.fromString((String)"db1.nonexist");
    private static final String DEFINITION_QUERY = "SELECT id, region, county FROM T";
    private static final IntervalFreshness FRESHNESS = IntervalFreshness.ofMinute((String)"3");
    private String warehouse;
    private Catalog catalog;
    @TempDir
    public static java.nio.file.Path temporaryFolder;

    @BeforeEach
    public void beforeEach() throws IOException {
        this.warehouse = new File(temporaryFolder.toFile(), UUID.randomUUID().toString()).toString();
        Options conf = new Options();
        conf.setString("warehouse", this.warehouse);
        conf.set(FlinkCatalogOptions.LOG_SYSTEM_AUTO_REGISTER, (Object)true);
        this.catalog = FlinkCatalogFactory.createCatalog((String)"test-catalog", (CatalogContext)CatalogContext.create((Options)conf), (ClassLoader)FlinkCatalogTest.class.getClassLoader());
    }

    private ResolvedSchema createSchema() {
        return new ResolvedSchema(Arrays.asList(Column.physical((String)"first", (DataType)DataTypes.STRING()), Column.physical((String)"second", (DataType)DataTypes.INT()), Column.physical((String)"third", (DataType)DataTypes.STRING()), Column.physical((String)"four", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f2", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f3", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT()))}))), Collections.emptyList(), null);
    }

    private List<String> createPartitionKeys() {
        return Arrays.asList("second", "third");
    }

    private CatalogTable createAnotherTable(Map<String, String> options) {
        ResolvedSchema resolvedSchema = this.createSchema();
        CatalogTable origin = CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema).build()).comment("test comment").partitionKeys(Collections.emptyList()).options(options).build();
        return new ResolvedCatalogTable(origin, resolvedSchema);
    }

    private CatalogTable createAnotherPartitionedTable(Map<String, String> options) {
        ResolvedSchema resolvedSchema = this.createSchema();
        CatalogTable origin = CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema).build()).comment("test comment").partitionKeys(this.createPartitionKeys()).options(options).build();
        return new ResolvedCatalogTable(origin, resolvedSchema);
    }

    private CatalogTable createTable(Map<String, String> options) {
        ResolvedSchema resolvedSchema = this.createSchema();
        CatalogTable origin = CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema).build()).comment("test comment").partitionKeys(Collections.emptyList()).options(options).build();
        return new ResolvedCatalogTable(origin, resolvedSchema);
    }

    private CatalogTable createPartitionedTable(Map<String, String> options) {
        ResolvedSchema resolvedSchema = this.createSchema();
        CatalogTable origin = CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema).build()).comment("test comment").partitionKeys(this.createPartitionKeys()).options(options).build();
        return new ResolvedCatalogTable(origin, resolvedSchema);
    }

    private CatalogMaterializedTable createMaterializedTable(Map<String, String> options) {
        ResolvedSchema resolvedSchema = this.createSchema();
        return new ResolvedCatalogMaterializedTable(CatalogMaterializedTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema).build()).comment("test materialized table comment").partitionKeys(Collections.emptyList()).options(options).definitionQuery(DEFINITION_QUERY).freshness(FRESHNESS).logicalRefreshMode(CatalogMaterializedTable.LogicalRefreshMode.AUTOMATIC).refreshMode(CatalogMaterializedTable.RefreshMode.CONTINUOUS).refreshStatus(CatalogMaterializedTable.RefreshStatus.INITIALIZING).build(), resolvedSchema);
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testCreateAndGetCatalogMaterializedTable(Map<String, String> options) throws Exception {
        ObjectPath tablePath = this.path1;
        CatalogMaterializedTable materializedTable = this.createMaterializedTable(options);
        this.catalog.createDatabase(tablePath.getDatabaseName(), null, false);
        this.catalog.createTable(tablePath, (CatalogBaseTable)materializedTable, true);
        Assertions.assertThat((boolean)this.catalog.tableExists(tablePath)).isTrue();
        CatalogBaseTable actualTable = this.catalog.getTable(tablePath);
        Assertions.assertThat((Comparable)actualTable.getTableKind()).isEqualTo((Object)CatalogBaseTable.TableKind.MATERIALIZED_TABLE);
        CatalogMaterializedTable actualMaterializedTable = (CatalogMaterializedTable)actualTable;
        this.checkCreateTable(tablePath, (CatalogBaseTable)materializedTable, (CatalogBaseTable)actualMaterializedTable);
        org.junit.jupiter.api.Assertions.assertThrows(TableAlreadyExistException.class, () -> this.catalog.createTable(tablePath, (CatalogBaseTable)materializedTable, false));
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testDropMaterializedTable(Map<String, String> options) throws Exception {
        ObjectPath tablePath = this.path1;
        this.catalog.createDatabase(tablePath.getDatabaseName(), null, false);
        this.catalog.createTable(tablePath, (CatalogBaseTable)this.createTable(options), false);
        Assertions.assertThat((boolean)this.catalog.tableExists(tablePath)).isTrue();
        this.catalog.dropTable(tablePath, false);
        Assertions.assertThat((boolean)this.catalog.tableExists(tablePath)).isFalse();
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testAlterMaterializedTable(Map<String, String> options) throws Exception {
        ObjectPath tablePath = this.path1;
        CatalogMaterializedTable materializedTable = this.createMaterializedTable(options);
        this.catalog.createDatabase(tablePath.getDatabaseName(), null, false);
        this.catalog.createTable(tablePath, (CatalogBaseTable)materializedTable, true);
        TestRefreshHandler refreshHandler = new TestRefreshHandler("jobID: xxx, clusterId: yyy");
        CatalogMaterializedTable expectedMaterializedTable = materializedTable.copy(CatalogMaterializedTable.RefreshStatus.ACTIVATED, refreshHandler.asSummaryString(), refreshHandler.toBytes());
        ArrayList<Object> tableChanges = new ArrayList<Object>();
        tableChanges.add(new TableChange.ModifyRefreshStatus(CatalogMaterializedTable.RefreshStatus.ACTIVATED));
        tableChanges.add(new TableChange.ModifyRefreshHandler(refreshHandler.asSummaryString(), refreshHandler.toBytes()));
        this.catalog.alterTable(tablePath, (CatalogBaseTable)expectedMaterializedTable, tableChanges, false);
        CatalogBaseTable updatedTable = this.catalog.getTable(tablePath);
        this.checkEquals(tablePath, (CatalogBaseTable)expectedMaterializedTable, updatedTable, Collections.singletonMap(FlinkCatalogOptions.REGISTER_TIMEOUT.key(), ((Duration)FlinkCatalogOptions.REGISTER_TIMEOUT.defaultValue()).toString()), Collections.emptySet());
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testAlterTable(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        CatalogTable table = this.createTable(options);
        this.catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        this.checkCreateTable(this.path1, (CatalogBaseTable)table, (CatalogBaseTable)((CatalogTable)this.catalog.getTable(this.path1)));
        CatalogTable newTable = this.createAnotherTable(options);
        this.catalog.alterTable(this.path1, (CatalogBaseTable)newTable, false);
        Assertions.assertThat((Object)this.catalog.getTable(this.path1)).isNotEqualTo((Object)table);
        this.checkAlterTable(this.path1, newTable, (CatalogTable)this.catalog.getTable(this.path1));
        this.catalog.dropTable(this.path1, false);
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testListTables(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        this.catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(options), false);
        this.catalog.createTable(this.path3, (CatalogBaseTable)this.createTable(options), false);
        Assertions.assertThat((int)this.catalog.listTables("db1").size()).isEqualTo(2L);
    }

    @Test
    public void testAlterTable_differentTypedTable() {
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testCreateFlinkTable(Map<String, String> options) {
        CatalogTable table = this.createTable(options);
        HashMap<String, String> newOptions = new HashMap<String, String>(table.getOptions());
        newOptions.put("connector", "filesystem");
        CatalogTable newTable = table.copy(newOptions);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.createTable(this.path1, (CatalogBaseTable)newTable, false)).isInstanceOf(CatalogException.class)).hasMessageContaining("Paimon Catalog only supports paimon tables");
    }

    @Test
    public void testCreateFlinkTableWithPath() throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(CoreOptions.PATH.key(), "/unknown/path");
        CatalogTable table1 = this.createTable(options);
        Assertions.assertThatThrownBy(() -> this.catalog.createTable(this.path1, (CatalogBaseTable)table1, false)).hasMessageContaining("The current catalog FileSystemCatalog does not support specifying the table path when creating a table.");
    }

    @ParameterizedTest
    @MethodSource(value={"streamingOptionProvider"})
    public void testCreateTable_Streaming(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        CatalogTable table = this.createTable(options);
        this.catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        this.checkCreateTable(this.path1, (CatalogBaseTable)table, (CatalogBaseTable)((CatalogTable)this.catalog.getTable(this.path1)));
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testAlterPartitionedTable(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        CatalogTable table = this.createPartitionedTable(options);
        this.catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        this.checkCreateTable(this.path1, (CatalogBaseTable)table, (CatalogBaseTable)((CatalogTable)this.catalog.getTable(this.path1)));
        CatalogTable newTable = this.createAnotherPartitionedTable(options);
        this.catalog.alterTable(this.path1, (CatalogBaseTable)newTable, false);
        this.checkAlterTable(this.path1, newTable, (CatalogTable)this.catalog.getTable(this.path1));
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testCreateTable_Batch(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        CatalogTable table = this.createTable(options);
        this.catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        CatalogBaseTable tableCreated = this.catalog.getTable(this.path1);
        this.checkCreateTable(this.path1, (CatalogBaseTable)table, (CatalogBaseTable)((CatalogTable)tableCreated));
        Assertions.assertThat((String)((String)tableCreated.getDescription().get())).isEqualTo("test comment");
        List tables = this.catalog.listTables("db1");
        Assertions.assertThat((int)tables.size()).isEqualTo(1L);
        Assertions.assertThat((String)((String)tables.get(0))).isEqualTo(this.path1.getObjectName());
        this.catalog.dropTable(this.path1, false);
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testCreateTable_TableAlreadyExist_ignored(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        CatalogTable table = this.createTable(options);
        this.catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        this.checkCreateTable(this.path1, (CatalogBaseTable)table, (CatalogBaseTable)((CatalogTable)this.catalog.getTable(this.path1)));
        this.catalog.createTable(this.path1, (CatalogBaseTable)this.createAnotherTable(options), true);
        this.checkCreateTable(this.path1, (CatalogBaseTable)table, (CatalogBaseTable)((CatalogTable)this.catalog.getTable(this.path1)));
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testCreatePartitionedTable_Batch(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        CatalogTable table = this.createPartitionedTable(options);
        this.catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        this.checkCreateTable(this.path1, (CatalogBaseTable)table, (CatalogBaseTable)((CatalogTable)this.catalog.getTable(this.path1)));
        List tables = this.catalog.listTables("db1");
        Assertions.assertThat((int)tables.size()).isEqualTo(1L);
        Assertions.assertThat((String)((String)tables.get(0))).isEqualTo(this.path1.getObjectName());
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testDropDb_DatabaseNotEmptyException(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        this.catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(options), false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.dropDatabase("db1", true, false)).isInstanceOf(DatabaseNotEmptyException.class)).hasMessage("Database db1 in catalog test-catalog is not empty.");
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testTableExists(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        Assertions.assertThat((boolean)this.catalog.tableExists(this.path1)).isFalse();
        this.catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(options), false);
        Assertions.assertThat((boolean)this.catalog.tableExists(this.path1)).isTrue();
        Assertions.assertThat((boolean)this.catalog.tableExists(new ObjectPath(this.path1.getDatabaseName(), this.path1.getObjectName() + "$snapshots"))).isTrue();
        Assertions.assertThat((boolean)this.catalog.tableExists(new ObjectPath(this.path1.getDatabaseName(), this.path1.getObjectName() + "$unknown"))).isFalse();
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testAlterTable_TableNotExist_ignored(Map<String, String> options) throws Exception {
        this.catalog.alterTable(this.nonExistObjectPath, (CatalogBaseTable)this.createTable(options), true);
        Assertions.assertThat((boolean)this.catalog.tableExists(this.nonExistObjectPath)).isFalse();
    }

    @Test
    public void testDropTable_TableNotExist_ignored() throws Exception {
        this.catalog.dropTable(this.nonExistObjectPath, true);
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testCreateTable_TableAlreadyExistException(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        this.catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(options), false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(options), false)).isInstanceOf(TableAlreadyExistException.class)).hasMessage("Table (or view) db1.t1 already exists in Catalog test-catalog.");
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testDropTable_nonPartitionedTable(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        this.catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(options), false);
        Assertions.assertThat((boolean)this.catalog.tableExists(this.path1)).isTrue();
        this.catalog.dropTable(this.path1, false);
        Assertions.assertThat((boolean)this.catalog.tableExists(this.path1)).isFalse();
    }

    @Test
    public void testGetTable_TableNotExistException() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.getTable(this.nonExistObjectPath)).isInstanceOf(TableNotExistException.class)).hasMessage("Table (or view) db1.nonexist does not exist in Catalog test-catalog.");
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testDbExists(Map<String, String> options) throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        this.catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(options), false);
        Assertions.assertThat((boolean)this.catalog.databaseExists("db1")).isTrue();
    }

    @Test
    public void testGetDatabase() throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        CatalogDatabase database = this.catalog.getDatabase(this.path1.getDatabaseName());
        Assertions.assertThat((Map)database.getProperties()).isEmpty();
        Assertions.assertThat((Optional)database.getDescription()).isEmpty();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.getDatabase(this.nonExistDbPath.getDatabaseName())).isInstanceOf(DatabaseNotExistException.class)).hasMessageContaining("Database non does not exist in Catalog test-catalog.");
    }

    @Test
    public void testDropDb_DatabaseNotExist_Ignore() throws Exception {
        this.catalog.dropDatabase("db1", true, false);
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testAlterTable_TableNotExistException(Map<String, String> options) throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.alterTable(this.nonExistDbPath, (CatalogBaseTable)this.createTable(options), false)).isInstanceOf(TableNotExistException.class)).hasMessage("Table (or view) non.exist does not exist in Catalog test-catalog.");
    }

    @Test
    public void testDropTable_TableNotExistException() throws Exception {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.dropTable(this.nonExistDbPath, false)).isInstanceOf(TableNotExistException.class)).hasMessage("Table (or view) non.exist does not exist in Catalog test-catalog.");
    }

    @Test
    public void testCreateDb_Database() throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        List dbs = this.catalog.listDatabases();
        Assertions.assertThat((List)dbs).hasSize(2);
        Assertions.assertThat(new HashSet(dbs)).isEqualTo(new HashSet<String>(Arrays.asList(this.path1.getDatabaseName(), this.catalog.getDefaultDatabase())));
    }

    @Test
    public void testCreateDb_DatabaseAlreadyExistException() throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.createDatabase(this.path1.getDatabaseName(), null, false)).isInstanceOf(DatabaseAlreadyExistException.class)).hasMessage("Database db1 already exists in Catalog test-catalog.");
    }

    @Test
    public void testCreateDb_DatabaseWithProperties() throws Exception {
        CatalogDatabaseImpl database = new CatalogDatabaseImpl(Collections.singletonMap("haa", "ccc"), null);
        this.catalog.createDatabase(this.path1.getDatabaseName(), (CatalogDatabase)database, false);
        Assertions.assertThat((boolean)this.catalog.databaseExists(this.path1.getDatabaseName())).isTrue();
        Assertions.assertThat((boolean)this.catalog.getDatabase(this.path1.getDatabaseName()).getProperties().isEmpty()).isTrue();
        CatalogDatabaseImpl databaseWithPath = new CatalogDatabaseImpl(Collections.singletonMap("location", "/tmp"), null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.createDatabase("test-database-with-location", (CatalogDatabase)databaseWithPath, false)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot specify location for a database when using fileSystem catalog.");
    }

    @Test
    public void testCreateDb_DatabaseWithCommentSuccessful() throws DatabaseAlreadyExistException {
        CatalogDatabaseImpl database = new CatalogDatabaseImpl(Collections.emptyMap(), "haha");
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.catalog.createDatabase(this.path1.getDatabaseName(), (CatalogDatabase)database, false));
    }

    @ParameterizedTest
    @MethodSource(value={"batchOptionProvider"})
    public void testCreateTable_DatabaseNotExistException(Map<String, String> options) {
        Assertions.assertThat((boolean)this.catalog.databaseExists(this.path1.getDatabaseName())).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.createTable(this.nonExistObjectPath, (CatalogBaseTable)this.createTable(options), false)).isInstanceOf(DatabaseNotExistException.class)).hasMessage("Database db1 does not exist in Catalog test-catalog.");
    }

    @Test
    public void testDropDb_DatabaseNotExistException() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.dropDatabase(this.path1.getDatabaseName(), false, false)).isInstanceOf(DatabaseNotExistException.class)).hasMessage("Database db1 does not exist in Catalog test-catalog.");
    }

    @Test
    public void testAlterDb() throws DatabaseAlreadyExistException, DatabaseNotExistException {
        CatalogDatabaseImpl database = new CatalogDatabaseImpl(Collections.emptyMap(), null);
        this.catalog.createDatabase(this.path1.getDatabaseName(), (CatalogDatabase)database, false);
        Map<String, String> properties = Collections.singletonMap("haa", "ccc");
        CatalogDatabaseImpl newDatabase = new CatalogDatabaseImpl(properties, "haha");
        Catalog mockCatalog = (Catalog)Mockito.spy((Object)this.catalog);
        ((Catalog)Mockito.doNothing().when((Object)mockCatalog)).alterDatabase(this.path1.getDatabaseName(), (CatalogDatabase)newDatabase, false);
        Mockito.when((Object)mockCatalog.getDatabase(this.path1.getDatabaseName())).thenReturn((Object)database);
        mockCatalog.alterDatabase(this.path1.getDatabaseName(), (CatalogDatabase)newDatabase, false);
        ((Catalog)Mockito.verify((Object)mockCatalog, (VerificationMode)Mockito.times((int)1))).alterDatabase(this.path1.getDatabaseName(), (CatalogDatabase)newDatabase, false);
        ((Catalog)Mockito.verify((Object)mockCatalog, (VerificationMode)Mockito.times((int)1))).getDatabase(this.path1.getDatabaseName());
    }

    @Test
    public void testAlterDbComment() throws DatabaseAlreadyExistException, DatabaseNotExistException {
        CatalogDatabaseImpl database = new CatalogDatabaseImpl(Collections.emptyMap(), null);
        this.catalog.createDatabase(this.path1.getDatabaseName(), (CatalogDatabase)database, false);
        Catalog mockCatalog = (Catalog)Mockito.spy((Object)this.catalog);
        Mockito.when((Object)mockCatalog.getDatabase(this.path1.getDatabaseName())).thenReturn((Object)database);
        CatalogDatabaseImpl newDatabase = new CatalogDatabaseImpl(Collections.emptyMap(), "aa");
        ((Catalog)Mockito.doNothing().when((Object)mockCatalog)).alterDatabase(this.path1.getDatabaseName(), (CatalogDatabase)newDatabase, false);
        mockCatalog.alterDatabase(this.path1.getDatabaseName(), (CatalogDatabase)newDatabase, false);
        ((Catalog)Mockito.verify((Object)mockCatalog, (VerificationMode)Mockito.times((int)1))).alterDatabase(this.path1.getDatabaseName(), (CatalogDatabase)newDatabase, false);
        ((Catalog)Mockito.verify((Object)mockCatalog, (VerificationMode)Mockito.times((int)1))).getDatabase(this.path1.getDatabaseName());
    }

    @Test
    public void testAlterDb_DatabaseNotExistException() {
        CatalogDatabaseImpl database = new CatalogDatabaseImpl(Collections.emptyMap(), null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.alterDatabase(this.path1.getDatabaseName(), (CatalogDatabase)database, false)).isInstanceOf(DatabaseNotExistException.class)).hasMessage("Database db1 does not exist in Catalog test-catalog.");
    }

    @Test
    public void testGetProperties() throws Exception {
        Map<Object, Object> oldProperties = Collections.emptyMap();
        Map<String, String> newProperties = Collections.singletonMap("haa", "ccc");
        List propertyChanges = FlinkCatalog.getPropertyChanges(oldProperties, newProperties);
        Assertions.assertThat((int)propertyChanges.size()).isEqualTo(1);
        oldProperties = newProperties;
        propertyChanges = FlinkCatalog.getPropertyChanges(oldProperties, newProperties);
        Assertions.assertThat((int)propertyChanges.size()).isEqualTo(0);
        oldProperties = Collections.singletonMap("aa", "ccc");
        propertyChanges = FlinkCatalog.getPropertyChanges(oldProperties, newProperties);
        Assertions.assertThat((int)propertyChanges.size()).isEqualTo(2);
    }

    @Test
    public void testGetPropertyChangeFromComment() {
        Optional commentChange = FlinkCatalog.getPropertyChangeFromComment(Optional.empty(), Optional.empty());
        Assertions.assertThat((boolean)commentChange.isPresent()).isFalse();
        commentChange = FlinkCatalog.getPropertyChangeFromComment(Optional.of("aa"), Optional.of("bb"));
        Assertions.assertThat((boolean)commentChange.isPresent()).isTrue();
        commentChange = FlinkCatalog.getPropertyChangeFromComment(Optional.of("aa"), Optional.empty());
        Assertions.assertThat((boolean)commentChange.isPresent()).isFalse();
        commentChange = FlinkCatalog.getPropertyChangeFromComment(Optional.empty(), Optional.of("bb"));
        Assertions.assertThat((boolean)commentChange.isPresent()).isTrue();
    }

    @Test
    public void testCreateTableWithColumnOptions() throws Exception {
        ResolvedExpressionMock expression = new ResolvedExpressionMock(DataTypes.INT(), () -> "test + 1");
        ResolvedSchema resolvedSchema = new ResolvedSchema(Arrays.asList(Column.physical((String)"pk", (DataType)((DataType)DataTypes.INT().notNull())), Column.physical((String)"test", (DataType)DataTypes.INT()), Column.computed((String)"comp", (ResolvedExpression)expression)), Collections.emptyList(), UniqueConstraint.primaryKey((String)"pk", (List)ImmutableList.of((Object)"pk")));
        Schema schema = Schema.newBuilder().column("pk", DataTypes.INT().notNull()).column("test", (AbstractDataType)DataTypes.INT()).columnByExpression("comp", "test + 1").primaryKey(new String[]{"pk"}).build();
        ResolvedCatalogTable catalogTable = new ResolvedCatalogTable(CatalogTable.newBuilder().schema(schema).comment("").partitionKeys(Collections.emptyList()).options(new HashMap()).build(), resolvedSchema);
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        this.catalog.createTable(this.path1, (CatalogBaseTable)catalogTable, false);
        CatalogTable got = (CatalogTable)this.catalog.getTable(this.path1);
        Schema newSchema = got.getUnresolvedSchema();
        Assertions.assertThat((List)schema.getColumns()).isEqualTo((Object)newSchema.getColumns());
        Assertions.assertThat((List)((Schema.UnresolvedPrimaryKey)schema.getPrimaryKey().get()).getColumnNames()).isEqualTo((Object)((Schema.UnresolvedPrimaryKey)newSchema.getPrimaryKey().get()).getColumnNames());
        Map expected = got.getOptions();
        expected.remove("path");
        expected.remove("table.data.path");
        expected.remove(FlinkCatalogOptions.REGISTER_TIMEOUT.key());
        Assertions.assertThat((Map)catalogTable.getOptions()).isEqualTo((Object)expected);
    }

    @Test
    public void testCreateTableWithLogSystemRegister() throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        ResolvedExpressionMock expression = new ResolvedExpressionMock(DataTypes.INT(), () -> "test + 1");
        ResolvedSchema resolvedSchema = new ResolvedSchema(Arrays.asList(Column.physical((String)"pk", (DataType)((DataType)DataTypes.INT().notNull())), Column.physical((String)"test", (DataType)DataTypes.INT()), Column.computed((String)"comp", (ResolvedExpression)expression)), Collections.emptyList(), UniqueConstraint.primaryKey((String)"pk", (List)ImmutableList.of((Object)"pk")));
        Schema schema = Schema.newBuilder().column("pk", DataTypes.INT().notNull()).column("test", (AbstractDataType)DataTypes.INT()).columnByExpression("comp", "test + 1").primaryKey(new String[]{"pk"}).build();
        HashMap<String, String> options = new HashMap<String, String>();
        ResolvedCatalogTable catalogTable1 = new ResolvedCatalogTable(CatalogTable.newBuilder().schema(schema).comment("").partitionKeys(Collections.emptyList()).options(options).build(), resolvedSchema);
        this.catalog.createTable(this.path1, (CatalogBaseTable)catalogTable1, false);
        CatalogBaseTable storedTable1 = this.catalog.getTable(this.path1);
        Assertions.assertThat((boolean)storedTable1.getOptions().containsKey("testing.log.store.topic")).isFalse();
        options.put(FlinkConnectorOptions.LOG_SYSTEM.key(), TESTING_LOG_STORE);
        ResolvedCatalogTable catalogTable2 = new ResolvedCatalogTable(CatalogTable.newBuilder().schema(schema).comment("").partitionKeys(Collections.emptyList()).options(options).build(), resolvedSchema);
        this.catalog.createTable(this.path3, (CatalogBaseTable)catalogTable2, false);
        CatalogBaseTable storedTable2 = this.catalog.getTable(this.path3);
        Assertions.assertThat((String)((String)storedTable2.getOptions().get("testing.log.store.topic"))).isEqualTo(String.format("%s-topic", this.path3.getObjectName()));
        Assertions.assertThatThrownBy(() -> this.catalog.dropTable(this.path3, true)).hasMessage("Check unregister log store topic here.");
    }

    @Test
    public void testDisableCreateTableInDefaultDB() throws TableAlreadyExistException, DatabaseNotExistException, DatabaseAlreadyExistException {
        String path = new File(temporaryFolder.toFile(), UUID.randomUUID().toString()).toString();
        Options conf = new Options();
        conf.setString("warehouse", path);
        conf.set(FlinkCatalogOptions.LOG_SYSTEM_AUTO_REGISTER, (Object)true);
        conf.set(FlinkCatalogOptions.DISABLE_CREATE_TABLE_IN_DEFAULT_DB, (Object)true);
        FlinkCatalog catalog = FlinkCatalogFactory.createCatalog((String)"test-ddl-catalog", (CatalogContext)CatalogContext.create((Options)conf), (ClassLoader)FlinkCatalogTest.class.getClassLoader());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testDisableCreateTableInDefaultDB$18((Catalog)catalog)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Creating table in default database is disabled, please specify a database name.");
        Assertions.assertThatCollection((Collection)catalog.listDatabases()).isEmpty();
        catalog.createDatabase("db1", null, false);
        Assertions.assertThatCode(() -> this.lambda$testDisableCreateTableInDefaultDB$19((Catalog)catalog)).doesNotThrowAnyException();
        Assertions.assertThat((List)catalog.listDatabases()).containsExactlyInAnyOrder((Object[])new String[]{"db1"});
        conf.set(FlinkCatalogOptions.DEFAULT_DATABASE, (Object)"default-db");
        FlinkCatalog catalog1 = FlinkCatalogFactory.createCatalog((String)"test-ddl-catalog1", (CatalogContext)CatalogContext.create((Options)conf), (ClassLoader)FlinkCatalogTest.class.getClassLoader());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testDisableCreateTableInDefaultDB$20((Catalog)catalog1)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Creating table in default database is disabled, please specify a database name.");
    }

    @Test
    void testCreateTableFromTableDescriptor() throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        ResolvedSchema resolvedSchema = this.createSchema();
        TableDescriptor tableDescriptor = TableDescriptor.forConnector((String)"paimon").schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema).build()).build();
        ResolvedCatalogTable catalogTable = new ResolvedCatalogTable(tableDescriptor.toCatalogTable(), resolvedSchema);
        this.catalog.createTable(this.path1, (CatalogBaseTable)catalogTable, false);
        this.checkCreateTable(this.path1, (CatalogBaseTable)catalogTable, (CatalogBaseTable)((CatalogTable)this.catalog.getTable(this.path1)));
    }

    @Test
    void testBuildPaimonTableWithCustomScheme() throws Exception {
        this.catalog.createDatabase(this.path1.getDatabaseName(), null, false);
        CatalogTable table = this.createTable((Map)FlinkCatalogTest.optionProvider(false).iterator().next());
        this.catalog.createTable(this.path1, (CatalogBaseTable)table, false);
        this.checkCreateTable(this.path1, (CatalogBaseTable)table, this.catalog.getTable(this.path1));
        List<Column> columns = Arrays.asList(Column.physical((String)"first", (DataType)DataTypes.STRING()), Column.physical((String)"second", (DataType)DataTypes.INT()), Column.physical((String)"third", (DataType)DataTypes.STRING()), Column.physical((String)"four", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f2", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f3", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT()))})));
        FactoryUtil.DefaultDynamicTableContext context = new FactoryUtil.DefaultDynamicTableContext(ObjectIdentifier.of((String)"default", (String)this.path1.getDatabaseName(), (String)this.path1.getObjectName()), FlinkTestBase.createResolvedTable((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("path", "unsupported-scheme://foobar");
            }
        }, columns, Collections.emptyList(), Collections.emptyList()), Collections.emptyMap(), (ReadableConfig)new Configuration(), Thread.currentThread().getContextClassLoader(), false);
        FlinkTableFactory factory = (FlinkTableFactory)this.catalog.getFactory().get();
        Table builtTable = factory.buildPaimonTable((DynamicTableFactory.Context)context);
        Assertions.assertThat((Object)builtTable).isInstanceOf(FileStoreTable.class);
        Assertions.assertThat((List)((FileStoreTable)builtTable).schema().fieldNames()).containsExactly((Object[])new String[]{"first", "second", "third", "four"});
    }

    private void checkCreateTable(ObjectPath path, CatalogBaseTable expected, CatalogBaseTable actual) {
        this.checkEquals(path, expected, actual, Collections.singletonMap(FlinkCatalogOptions.REGISTER_TIMEOUT.key(), ((Duration)FlinkCatalogOptions.REGISTER_TIMEOUT.defaultValue()).toString()), Collections.singleton(FactoryUtil.CONNECTOR.key()));
    }

    private void checkAlterTable(ObjectPath path, CatalogTable expected, CatalogTable actual) {
        this.checkEquals(path, (CatalogBaseTable)expected, (CatalogBaseTable)actual, Collections.emptyMap(), Collections.emptySet());
    }

    private void checkEquals(ObjectPath path, CatalogBaseTable t1, CatalogBaseTable t2, Map<String, String> optionsToAdd, Set<String> optionsToRemove) {
        Path tablePath;
        HashMap<String, String> options;
        try {
            options = ((FlinkCatalog)this.catalog).catalog().getTable(FlinkCatalog.toIdentifier((ObjectPath)path)).options();
            tablePath = new Path((String)options.get(CoreOptions.PATH.key()));
        }
        catch (Catalog.TableNotExistException e) {
            throw new RuntimeException(e);
        }
        options = new HashMap<String, String>(t1.getOptions());
        options.put("path", tablePath.toString());
        options.putAll(optionsToAdd);
        optionsToRemove.forEach(options::remove);
        if (t1.getTableKind() == CatalogBaseTable.TableKind.TABLE) {
            t1 = ((ResolvedCatalogTable)t1).copy(options);
        } else {
            options.put(CoreOptions.TYPE.key(), TableType.MATERIALIZED_TABLE.toString());
            t1 = ((ResolvedCatalogMaterializedTable)t1).copy(options);
        }
        FlinkCatalogTest.checkEquals(t1, t2);
    }

    private static void checkEquals(CatalogBaseTable t1, CatalogBaseTable t2) {
        Assertions.assertThat((Comparable)t2.getTableKind()).isEqualTo((Object)t1.getTableKind());
        Assertions.assertThat((String)t2.getComment()).isEqualTo(t1.getComment());
        Assertions.assertThat((Map)t2.getOptions()).isEqualTo((Object)t1.getOptions());
        if (t1.getTableKind() == CatalogBaseTable.TableKind.TABLE) {
            Assertions.assertThat((Object)t2.getUnresolvedSchema()).isEqualTo((Object)t1.getUnresolvedSchema());
            Assertions.assertThat((List)((CatalogTable)t2).getPartitionKeys()).isEqualTo((Object)((CatalogTable)t1).getPartitionKeys());
            Assertions.assertThat((boolean)((CatalogTable)t2).isPartitioned()).isEqualTo(((CatalogTable)t1).isPartitioned());
        } else {
            CatalogMaterializedTable mt1 = (CatalogMaterializedTable)t1;
            CatalogMaterializedTable mt2 = (CatalogMaterializedTable)t2;
            Assertions.assertThat((Object)Schema.newBuilder().fromResolvedSchema(t2.getUnresolvedSchema().resolve((SchemaResolver)new TestSchemaResolver())).build()).isEqualTo((Object)Schema.newBuilder().fromResolvedSchema(t1.getUnresolvedSchema().resolve((SchemaResolver)new TestSchemaResolver())).build());
            Assertions.assertThat((List)mt2.getPartitionKeys()).isEqualTo((Object)mt1.getPartitionKeys());
            Assertions.assertThat((boolean)mt2.isPartitioned()).isEqualTo(mt1.isPartitioned());
            Assertions.assertThat((String)mt2.getDefinitionQuery()).isEqualTo(mt1.getDefinitionQuery());
            Assertions.assertThat((Object)mt2.getDefinitionFreshness()).isEqualTo((Object)mt1.getDefinitionFreshness());
            Assertions.assertThat((Comparable)mt2.getLogicalRefreshMode()).isEqualTo((Object)mt1.getLogicalRefreshMode());
            Assertions.assertThat((Comparable)mt2.getRefreshMode()).isEqualTo((Object)mt1.getRefreshMode());
            Assertions.assertThat((Comparable)mt2.getRefreshStatus()).isEqualTo((Object)mt1.getRefreshStatus());
            Assertions.assertThat((Optional)mt2.getRefreshHandlerDescription()).isEqualTo((Object)mt1.getRefreshHandlerDescription());
            Assertions.assertThat((byte[])mt2.getSerializedRefreshHandler()).isEqualTo((Object)mt1.getSerializedRefreshHandler());
        }
    }

    static Stream<Map<String, String>> streamingOptionProvider() {
        return FlinkCatalogTest.optionProvider(true);
    }

    static Stream<Map<String, String>> batchOptionProvider() {
        return FlinkCatalogTest.optionProvider(false);
    }

    private static Stream<Map<String, String>> optionProvider(boolean isStreaming) {
        ArrayList allOptions = new ArrayList();
        for (CoreOptions.StartupMode mode : CoreOptions.StartupMode.values()) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("is_streaming", String.valueOf(isStreaming));
            options.put("scan.mode", mode.toString());
            if (mode == CoreOptions.StartupMode.FROM_SNAPSHOT || mode == CoreOptions.StartupMode.FROM_SNAPSHOT_FULL) {
                options.put("scan.snapshot-id", "1");
            } else if (mode == CoreOptions.StartupMode.FROM_TIMESTAMP) {
                options.put("scan.timestamp-millis", System.currentTimeMillis() + "");
            } else if (mode == CoreOptions.StartupMode.FROM_FILE_CREATION_TIME) {
                options.put(CoreOptions.SCAN_FILE_CREATION_TIME_MILLIS.key(), System.currentTimeMillis() + "");
            } else if (mode == CoreOptions.StartupMode.INCREMENTAL) {
                options.put("incremental-between", "2,5");
            }
            if (isStreaming && mode == CoreOptions.StartupMode.INCREMENTAL) continue;
            allOptions.add(options);
        }
        return allOptions.stream();
    }

    private /* synthetic */ void lambda$testDisableCreateTableInDefaultDB$20(Catalog catalog1) throws Throwable {
        catalog1.createTable(this.tableInDefaultDb1, (CatalogBaseTable)this.createTable(new HashMap<String, String>(0)), false);
    }

    private /* synthetic */ void lambda$testDisableCreateTableInDefaultDB$19(Catalog catalog) throws Throwable {
        catalog.createTable(this.path1, (CatalogBaseTable)this.createTable(new HashMap<String, String>(0)), false);
    }

    private /* synthetic */ void lambda$testDisableCreateTableInDefaultDB$18(Catalog catalog) throws Throwable {
        catalog.createTable(this.tableInDefaultDb, (CatalogBaseTable)this.createTable(new HashMap<String, String>(0)), false);
    }

    private static class TestRefreshHandler
    implements RefreshHandler {
        private final String handlerString;

        public TestRefreshHandler(String handlerString) {
            this.handlerString = handlerString;
        }

        public String asSummaryString() {
            return "test refresh handler";
        }

        public byte[] toBytes() {
            return this.handlerString.getBytes();
        }
    }

    private static class TestingLogStoreRegister
    implements LogStoreRegister {
        private final Identifier table;

        private TestingLogStoreRegister(Identifier table) {
            this.table = table;
        }

        public Map<String, String> registerTopic() {
            return Collections.singletonMap("testing.log.store.topic", String.format("%s-topic", this.table.getObjectName()));
        }

        public void unRegisterTopic() {
            throw new UnsupportedOperationException("Check unregister log store topic here.");
        }
    }

    public static class TestingLogSoreRegisterFactory
    implements LogStoreTableFactory {
        public String identifier() {
            return FlinkCatalogTest.TESTING_LOG_STORE;
        }

        public LogSourceProvider createSourceProvider(DynamicTableFactory.Context context, DynamicTableSource.Context sourceContext, @Nullable int[][] projectFields) {
            throw new UnsupportedOperationException();
        }

        public LogSinkProvider createSinkProvider(DynamicTableFactory.Context context, DynamicTableSink.Context sinkContext) {
            throw new UnsupportedOperationException();
        }

        public LogStoreRegister createRegister(LogStoreTableFactory.RegisterContext context) {
            return new TestingLogStoreRegister(context.getIdentifier());
        }
    }
}

