/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.ValueLiteralExpression;
import org.apache.flink.table.functions.BuiltInFunctionDefinition;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.Row;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.flink.PredicateConverter;
import org.apache.paimon.format.SimpleColStats;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.predicate.SimpleColStatsTestUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class PredicateConverterTest {
    private static final PredicateBuilder BUILDER = new PredicateBuilder(LogicalTypeConversion.toDataType((RowType)new RowType(Arrays.asList(new RowType.RowField("long1", (LogicalType)new BigIntType()), new RowType.RowField("double1", (LogicalType)new DoubleType()), new RowType.RowField("string1", DataTypes.STRING().getLogicalType())))));
    private static final PredicateConverter CONVERTER = new PredicateConverter(BUILDER);

    @MethodSource(value={"provideResolvedExpression"})
    @ParameterizedTest
    public void testVisitAndAutoTypeInference(ResolvedExpression expression, Predicate expected) {
        if (expression instanceof CallExpression) {
            Assertions.assertThat((String)CONVERTER.visit((CallExpression)expression).toString()).isEqualTo(expected.toString());
        } else {
            Assertions.assertThatThrownBy(() -> CONVERTER.visit((Expression)expression)).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        }
    }

    public static Stream<Arguments> provideResolvedExpression() {
        FieldReferenceExpression longRefExpr = new FieldReferenceExpression("long1", DataTypes.BIGINT(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        ValueLiteralExpression intLitExpr = new ValueLiteralExpression((Object)10);
        ValueLiteralExpression intLitExpr2 = new ValueLiteralExpression((Object)20);
        long longLit = 10L;
        ValueLiteralExpression nullLongLitExpr = new ValueLiteralExpression(null, DataTypes.BIGINT());
        FieldReferenceExpression doubleRefExpr = new FieldReferenceExpression("double1", DataTypes.DOUBLE(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        ValueLiteralExpression floatLitExpr = new ValueLiteralExpression((Object)Float.valueOf(3.14f));
        double doubleLit = 3.14;
        FieldReferenceExpression stringRefExpr = new FieldReferenceExpression("string1", DataTypes.STRING(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        String stringLit = "haha";
        ValueLiteralExpression stringLitExpr1 = new ValueLiteralExpression((Object)stringLit, (DataType)DataTypes.STRING().notNull());
        ValueLiteralExpression stringLitExpr2 = new ValueLiteralExpression((Object)stringLit);
        return Stream.of(Arguments.of((Object[])new Object[]{longRefExpr, null}), Arguments.of((Object[])new Object[]{intLitExpr, null}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.IS_NULL, Collections.singletonList(longRefExpr), (DataType)DataTypes.BOOLEAN()), BUILDER.isNull(0)}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.IS_NOT_NULL, Collections.singletonList(doubleRefExpr), (DataType)DataTypes.BOOLEAN()), BUILDER.isNotNull(1)}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.EQUALS, Arrays.asList(intLitExpr, longRefExpr), (DataType)DataTypes.BOOLEAN()), BUILDER.equal(0, (Object)longLit)}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.EQUALS, Arrays.asList(nullLongLitExpr, longRefExpr), (DataType)DataTypes.BOOLEAN()), BUILDER.equal(0, null)}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.NOT_EQUALS, Arrays.asList(longRefExpr, intLitExpr), (DataType)DataTypes.BOOLEAN()), BUILDER.notEqual(0, (Object)longLit)}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.NOT_EQUALS, Arrays.asList(longRefExpr, nullLongLitExpr), (DataType)DataTypes.BOOLEAN()), BUILDER.notEqual(0, null)}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, Arrays.asList(longRefExpr, intLitExpr), (DataType)DataTypes.BOOLEAN()), BUILDER.greaterThan(0, (Object)longLit)}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN, Arrays.asList(longRefExpr, nullLongLitExpr), (DataType)DataTypes.BOOLEAN()), BUILDER.greaterThan(0, null)}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL, Arrays.asList(longRefExpr, intLitExpr), (DataType)DataTypes.BOOLEAN()), BUILDER.greaterOrEqual(0, (Object)longLit)}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.GREATER_THAN_OR_EQUAL, Arrays.asList(longRefExpr, nullLongLitExpr), (DataType)DataTypes.BOOLEAN()), BUILDER.greaterOrEqual(0, null)}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN, Arrays.asList(longRefExpr, intLitExpr), (DataType)DataTypes.BOOLEAN()), BUILDER.lessThan(0, (Object)longLit)}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN, Arrays.asList(longRefExpr, nullLongLitExpr), (DataType)DataTypes.BOOLEAN()), BUILDER.lessThan(0, null)}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL, Arrays.asList(longRefExpr, intLitExpr), (DataType)DataTypes.BOOLEAN()), BUILDER.lessOrEqual(0, (Object)longLit)}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL, Arrays.asList(longRefExpr, nullLongLitExpr), (DataType)DataTypes.BOOLEAN()), BUILDER.lessOrEqual(0, null)}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.AND, Arrays.asList(CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.LESS_THAN_OR_EQUAL, Arrays.asList(longRefExpr, intLitExpr), (DataType)DataTypes.BOOLEAN()), CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.EQUALS, Arrays.asList(doubleRefExpr, floatLitExpr), (DataType)DataTypes.BOOLEAN())), (DataType)DataTypes.BOOLEAN()), PredicateBuilder.and((Predicate[])new Predicate[]{BUILDER.lessOrEqual(0, (Object)longLit), BUILDER.equal(1, (Object)doubleLit)})}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.OR, Arrays.asList(CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.NOT_EQUALS, Arrays.asList(longRefExpr, intLitExpr), (DataType)DataTypes.BOOLEAN()), CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.EQUALS, Arrays.asList(doubleRefExpr, floatLitExpr), (DataType)DataTypes.BOOLEAN())), (DataType)DataTypes.BOOLEAN()), PredicateBuilder.or((Predicate[])new Predicate[]{BUILDER.notEqual(0, (Object)longLit), BUILDER.equal(1, (Object)doubleLit)})}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.IN, Arrays.asList(longRefExpr, intLitExpr, nullLongLitExpr, intLitExpr2), (DataType)DataTypes.BOOLEAN()), BUILDER.in(0, Arrays.asList(10L, null, 20L))}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.EQUALS, Arrays.asList(stringLitExpr1, stringRefExpr), (DataType)DataTypes.STRING()), BUILDER.equal(2, (Object)BinaryString.fromString((String)"haha"))}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.EQUALS, Arrays.asList(stringLitExpr2, stringRefExpr), (DataType)DataTypes.STRING()), BUILDER.equal(2, (Object)BinaryString.fromString((String)"haha"))}), Arguments.of((Object[])new Object[]{CallExpression.permanent((BuiltInFunctionDefinition)BuiltInFunctionDefinitions.BETWEEN, Arrays.asList(longRefExpr, intLitExpr, intLitExpr2), (DataType)DataTypes.BOOLEAN()), BUILDER.between(0, (Object)10, (Object)20)}));
    }

    @MethodSource(value={"provideLikeExpressions"})
    @ParameterizedTest
    public void testStartsWith(CallExpression callExpression, List<Object[]> valuesList, List<Boolean> expectedForValues, List<Long> rowCountList, List<SimpleColStats[]> statsList, List<Boolean> expectedForStats) {
        Predicate predicate = (Predicate)callExpression.accept((ExpressionVisitor)new PredicateConverter(RowType.of((LogicalType[])new LogicalType[]{new VarCharType()})));
        IntStream.range(0, valuesList.size()).forEach(i -> {
            AbstractBooleanAssert cfr_ignored_0 = (AbstractBooleanAssert)Assertions.assertThat((boolean)predicate.test((InternalRow)GenericRow.of((Object[])((Object[])valuesList.get(i))))).isEqualTo(expectedForValues.get(i));
        });
        IntStream.range(0, rowCountList.size()).forEach(i -> {
            AbstractBooleanAssert cfr_ignored_0 = (AbstractBooleanAssert)Assertions.assertThat((boolean)SimpleColStatsTestUtils.test((Predicate)predicate, (long)((Long)rowCountList.get(i)), (SimpleColStats[])((SimpleColStats[])statsList.get(i)))).isEqualTo(expectedForStats.get(i));
        });
    }

    public static Stream<Arguments> provideLikeExpressions() {
        CallExpression expr1 = PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"abd%", (DataType)DataTypes.STRING())});
        List valuesList1 = Arrays.asList({null}, {BinaryString.fromString((String)"a")}, {BinaryString.fromString((String)"ab")}, {BinaryString.fromString((String)"abd")}, {BinaryString.fromString((String)"abd%")}, {BinaryString.fromString((String)"abd1")}, {BinaryString.fromString((String)"abde@")}, {BinaryString.fromString((String)"abd_")}, {BinaryString.fromString((String)"abd_%")});
        List<Boolean> expectedForValues1 = Arrays.asList(false, false, false, true, true, true, true, true, true);
        List<Long> rowCountList1 = Arrays.asList(0L, 3L, 3L, 3L);
        List statsList1 = Arrays.asList({new SimpleColStats(null, null, Long.valueOf(0L))}, {new SimpleColStats(null, null, Long.valueOf(3L))}, {new SimpleColStats((Object)BinaryString.fromString((String)"ab"), (Object)BinaryString.fromString((String)"abc123"), Long.valueOf(1L))}, {new SimpleColStats((Object)BinaryString.fromString((String)"abc"), (Object)BinaryString.fromString((String)"abe"), Long.valueOf(1L))});
        List<Boolean> expectedForStats1 = Arrays.asList(false, false, false, true);
        CallExpression expr2 = PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"test=_%", (DataType)DataTypes.STRING()), ExpressionBuilder.literal((Object)"=", (DataType)DataTypes.STRING())});
        List valuesList2 = Arrays.asList({BinaryString.fromString((String)"test%")}, {BinaryString.fromString((String)"test_123")}, {BinaryString.fromString((String)"test_%")}, {BinaryString.fromString((String)"test__")});
        List<Boolean> expectedForValues2 = Arrays.asList(false, true, true, true);
        List<Long> rowCountList2 = Collections.singletonList(3L);
        List<SimpleColStats[]> statsList2 = Collections.singletonList(new SimpleColStats[]{new SimpleColStats((Object)BinaryString.fromString((String)"test_123"), (Object)BinaryString.fromString((String)"test_789"), Long.valueOf(0L))});
        List<Boolean> expectedForStats2 = Collections.singletonList(true);
        CallExpression expr3 = PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"[a-c]xyz%", (DataType)DataTypes.STRING())});
        List valuesList3 = Arrays.asList({BinaryString.fromString((String)"axyz")}, {BinaryString.fromString((String)"bxyz")}, {BinaryString.fromString((String)"cxyz")}, {BinaryString.fromString((String)"[a-c]xyz")});
        List<Boolean> expectedForValues3 = Arrays.asList(false, false, false, true);
        List<Long> rowCountList3 = Collections.singletonList(3L);
        List<SimpleColStats[]> statsList3 = Collections.singletonList(new SimpleColStats[]{new SimpleColStats((Object)BinaryString.fromString((String)"[a-c]xyz"), (Object)BinaryString.fromString((String)"[a-c]xyzz"), Long.valueOf(0L))});
        List<Boolean> expectedForStats3 = Collections.singletonList(true);
        CallExpression expr4 = PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"[^a-d]xyz%", (DataType)DataTypes.STRING())});
        List valuesList4 = Arrays.asList({BinaryString.fromString((String)"exyz")}, {BinaryString.fromString((String)"fxyz")}, {BinaryString.fromString((String)"axyz")}, {BinaryString.fromString((String)"[^a-d]xyz")});
        List<Boolean> expectedForValues4 = Arrays.asList(false, false, false, true);
        List<Long> rowCountList4 = Collections.singletonList(3L);
        List<SimpleColStats[]> statsList4 = Collections.singletonList(new SimpleColStats[]{new SimpleColStats((Object)BinaryString.fromString((String)"[^a-d]xyz"), (Object)BinaryString.fromString((String)"[^a-d]xyzz"), Long.valueOf(1L))});
        List<Boolean> expectedForStats4 = Collections.singletonList(true);
        return Stream.of(Arguments.of((Object[])new Object[]{expr1, valuesList1, expectedForValues1, rowCountList1, statsList1, expectedForStats1}), Arguments.of((Object[])new Object[]{expr2, valuesList2, expectedForValues2, rowCountList2, statsList2, expectedForStats2}), Arguments.of((Object[])new Object[]{expr3, valuesList3, expectedForValues3, rowCountList3, statsList3, expectedForStats3}), Arguments.of((Object[])new Object[]{expr4, valuesList4, expectedForValues4, rowCountList4, statsList4, expectedForStats4}));
    }

    @Test
    public void testUnsupportedExpression() {
        CallExpression expression = PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.AND, new ResolvedExpression[]{PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.INT()), ExpressionBuilder.literal((Object)3)}), PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.SIMILAR, new ResolvedExpression[]{PredicateConverterTest.field(1, DataTypes.INT()), ExpressionBuilder.literal((Object)5)})});
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)expression.accept((ExpressionVisitor)new PredicateConverter(RowType.of((LogicalType[])new LogicalType[]{new IntType(), new IntType()})));
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
    }

    @Test
    public void testUnsupportedStartsPatternForLike() {
        PredicateConverter converter = new PredicateConverter(RowType.of((LogicalType[])new LogicalType[]{new VarCharType()}));
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"abc_", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"abc%xyz", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"abc_xyz", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"=%abc=%%xyz=_", (DataType)DataTypes.STRING()), ExpressionBuilder.literal((Object)"=", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"abc=%%xyz", (DataType)DataTypes.STRING()), ExpressionBuilder.literal((Object)"=", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"abc=%_xyz", (DataType)DataTypes.STRING()), ExpressionBuilder.literal((Object)"=", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"abc=_%xyz", (DataType)DataTypes.STRING()), ExpressionBuilder.literal((Object)"=", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"abc=__xyz", (DataType)DataTypes.STRING()), ExpressionBuilder.literal((Object)"=", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"=%%", (DataType)DataTypes.STRING()), ExpressionBuilder.literal((Object)"=", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
    }

    @Test
    public void testUnsupportedEndsPatternForLike() {
        PredicateConverter converter = new PredicateConverter(RowType.of((LogicalType[])new LogicalType[]{new VarCharType()}));
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"%456", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"_456", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"_[456]", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"%[h-m]", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"%[^h-m]", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"_[^xyz]", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"%=%456", (DataType)DataTypes.STRING()), ExpressionBuilder.literal((Object)"=", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"%=_456", (DataType)DataTypes.STRING()), ExpressionBuilder.literal((Object)"=", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"_=_456", (DataType)DataTypes.STRING()), ExpressionBuilder.literal((Object)"=", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
    }

    @Test
    public void testUnsupportedEqualsPatternForLike() {
        PredicateConverter converter = new PredicateConverter(RowType.of((LogicalType[])new LogicalType[]{new VarCharType()}));
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"123456", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"12=%45", (DataType)DataTypes.STRING()), ExpressionBuilder.literal((Object)"=", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"12=_45", (DataType)DataTypes.STRING()), ExpressionBuilder.literal((Object)"=", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
    }

    @Test
    public void testUnsupportedMiddlePatternForLike() {
        PredicateConverter converter = new PredicateConverter(RowType.of((LogicalType[])new LogicalType[]{new VarCharType()}));
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"%345%", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"_345_", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"_345%", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"%345_", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"%[a-c]_", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"%[^abc]_", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"%34=%5%", (DataType)DataTypes.STRING()), ExpressionBuilder.literal((Object)"=", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.LIKE, new ResolvedExpression[]{PredicateConverterTest.field(0, DataTypes.STRING()), ExpressionBuilder.literal((Object)"%34=_5%", (DataType)DataTypes.STRING()), ExpressionBuilder.literal((Object)"=", (DataType)DataTypes.STRING())}).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
    }

    @Test
    public void testUnsupportedType() {
        PredicateConverter converter = new PredicateConverter(RowType.of((LogicalType[])new LogicalType[]{new VarCharType()}));
        DataType structType = (DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT()}).bridgedTo(Row.class);
        CallExpression expression = PredicateConverterTest.call((FunctionDefinition)BuiltInFunctionDefinitions.EQUALS, new ResolvedExpression[]{PredicateConverterTest.field(0, structType), ExpressionBuilder.literal((Object)Row.of((Object[])new Object[]{1}), (DataType)structType)});
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)expression.accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
    }

    @Test
    public void testUnsupportedFieldReferenceExpression() {
        PredicateConverter converter = new PredicateConverter(RowType.of((LogicalType[])new LogicalType[]{new VarCharType()}));
        DataType structType = (DataType)DataTypes.ROW((DataType[])new DataType[]{DataTypes.INT()}).bridgedTo(Row.class);
        Assertions.assertThatThrownBy(() -> {
            Predicate cfr_ignored_0 = (Predicate)PredicateConverterTest.field(0, structType).accept((ExpressionVisitor)converter);
        }).isInstanceOf(PredicateConverter.UnsupportedExpression.class);
    }

    private static FieldReferenceExpression field(int i, DataType type) {
        return new FieldReferenceExpression("f" + i, type, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private static CallExpression call(FunctionDefinition function, ResolvedExpression ... args) {
        return new CallExpression(false, null, function, Arrays.asList(args), DataTypes.BOOLEAN());
    }
}

