/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.flink.NestedProjectedRowData;
import org.apache.paimon.flink.Projection;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ProjectionTest {
    @Test
    public void testNestedProjection() {
        RowType writeType = DataTypes.ROW((DataField[])new DataField[]{DataTypes.FIELD((int)0, (String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((int)1, (String)"f1", (DataType)DataTypes.ROW((DataField[])new DataField[]{DataTypes.FIELD((int)2, (String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((int)3, (String)"f1", (DataType)DataTypes.INT()), DataTypes.FIELD((int)4, (String)"f2", (DataType)DataTypes.INT())}))});
        RowType readType = DataTypes.ROW((DataField[])new DataField[]{DataTypes.FIELD((int)1, (String)"f1", (DataType)DataTypes.ROW((DataField[])new DataField[]{DataTypes.FIELD((int)2, (String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((int)4, (String)"f2", (DataType)DataTypes.INT())}))});
        Projection projection = Projection.of((int[][])new int[][]{{1, 0}, {1, 2}});
        Assertions.assertThat((Object)projection.project(writeType)).isEqualTo((Object)readType);
        RowType readTypeForFlink = DataTypes.ROW((DataField[])new DataField[]{DataTypes.FIELD((int)0, (String)"f1", (DataType)DataTypes.ROW((DataField[])new DataField[]{DataTypes.FIELD((int)0, (String)"f0", (DataType)DataTypes.INT()), DataTypes.FIELD((int)1, (String)"f2", (DataType)DataTypes.INT())}))});
        NestedProjectedRowData rowData = projection.getOuterProjectRow(writeType);
        Assertions.assertThat((Object)rowData.getRowType()).isEqualTo((Object)LogicalTypeConversion.toLogicalType((RowType)readTypeForFlink));
        Assertions.assertThat((int[][])rowData.getProjectedFields()).isEqualTo((Object)new int[][]{{0, 0}, {0, 1}});
    }
}

