/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.types.Row;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.apache.paimon.testutils.assertj.PaimonAssertions;
import org.apache.paimon.utils.DateTimeUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class SchemaChangeITCase
extends CatalogITCaseBase {
    @Test
    public void testAddColumn() {
        this.sql("CREATE TABLE T (a STRING, b DOUBLE, c FLOAT)", new Object[0]);
        this.sql("INSERT INTO T VALUES('aaa', 1.2, 3.4)", new Object[0]);
        this.sql("ALTER TABLE T ADD d INT", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647),\n  `b` DOUBLE,\n  `c` FLOAT,\n  `d` INT\n)"});
        this.sql("INSERT INTO T VALUES('bbb', 4.5, 5.6, 5)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[aaa, 1.2, 3.4, null], +I[bbb, 4.5, 5.6, 5]]");
        this.sql("ALTER TABLE T ADD e INT AFTER b", new Object[0]);
        result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647),\n  `b` DOUBLE,\n  `e` INT,\n  `c` FLOAT,\n  `d` INT"});
        this.sql("INSERT INTO T VALUES('ccc', 2.3, 6, 5.6, 5)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[aaa, 1.2, null, 3.4, null], +I[bbb, 4.5, null, 5.6, 5], +I[ccc, 2.3, 6, 5.6, 5]]");
        this.sql("ALTER TABLE T ADD f STRING FIRST", new Object[0]);
        result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `f` VARCHAR(2147483647),\n  `a` VARCHAR(2147483647),\n  `b` DOUBLE,\n  `e` INT,\n  `c` FLOAT,\n  `d` INT"});
        this.sql("INSERT INTO T VALUES('flink', 'fff', 45.34, 4, 2.45, 12)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[null, aaa, 1.2, null, 3.4, null], +I[null, bbb, 4.5, null, 5.6, 5], +I[null, ccc, 2.3, 6, 5.6, 5], +I[flink, fff, 45.34, 4, 2.45, 12]]");
        this.sql("ALTER TABLE T ADD ( g INT, h BOOLEAN ) ", new Object[0]);
        this.sql("INSERT INTO T VALUES('ggg', 'hhh', 23.43, 6, 2.34, 34, 23, true)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[null, aaa, 1.2, null, 3.4, null, null, null], +I[null, bbb, 4.5, null, 5.6, 5, null, null], +I[null, ccc, 2.3, 6, 5.6, 5, null, null], +I[flink, fff, 45.34, 4, 2.45, 12, null, null], +I[ggg, hhh, 23.43, 6, 2.34, 34, 23, true]]");
    }

    @Test
    public void testDropColumn() {
        this.sql("CREATE TABLE T (a STRING PRIMARY KEY NOT ENFORCED, b STRING, c STRING, d INT, e FLOAT)", new Object[0]);
        this.sql("INSERT INTO T VALUES('aaa', 'bbb', 'ccc', 10, 3.4)", new Object[0]);
        this.sql("ALTER TABLE T DROP e", new Object[0]);
        this.sql("INSERT INTO T VALUES('ddd', 'eee', 'fff', 20)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647) NOT NULL,\n  `b` VARCHAR(2147483647),\n  `c` VARCHAR(2147483647),\n  `d` INT,"});
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[aaa, bbb, ccc, 10], +I[ddd, eee, fff, 20]]");
        this.sql("ALTER TABLE T DROP (c, d)", new Object[0]);
        result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647) NOT NULL,\n  `b` VARCHAR(2147483647),"});
        this.sql("INSERT INTO T VALUES('ggg', 'hhh')", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[aaa, bbb], +I[ddd, eee], +I[ggg, hhh]]");
    }

    @Test
    public void testRenameColumn() {
        this.sql("CREATE TABLE T (a STRING PRIMARY KEY NOT ENFORCED, b STRING, c STRING)", new Object[0]);
        this.sql("INSERT INTO T VALUES('paimon', 'bbb', 'ccc')", new Object[0]);
        this.sql("ALTER TABLE T RENAME c TO c1", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647) NOT NULL,\n  `b` VARCHAR(2147483647),\n  `c1` VARCHAR(2147483647)"});
        result = this.sql("SELECT a, b, c1 FROM T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[paimon, bbb, ccc]]");
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T RENAME d TO d1", new Object[0])).hasMessageContaining("The column `d` does not exist in the base table.");
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T RENAME a TO b", new Object[0])).hasMessageContaining("The column `b` already existed in table schema.");
    }

    @Test
    public void testDropPrimaryKey() {
        this.sql("CREATE TABLE T (a STRING PRIMARY KEY NOT ENFORCED, b STRING, c STRING)", new Object[0]);
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T DROP a", new Object[0])).hasMessageContaining("Failed to execute ALTER TABLE statement.\nThe column `a` is used as the primary key.");
    }

    @Test
    public void testDropPartitionKey() {
        this.sql("CREATE TABLE MyTable (\n    user_id BIGINT,\n    item_id BIGINT,\n    behavior STRING,\n    dt STRING,\n    hh STRING,\n    PRIMARY KEY (dt, hh, user_id) NOT ENFORCED\n) PARTITIONED BY (dt, hh)", new Object[0]);
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE MyTable DROP dt", new Object[0])).hasMessageContaining("Failed to execute ALTER TABLE statement.\nThe column `dt` is used as the partition keys.");
    }

    @Test
    public void testModifyColumnTypeFromNumericToNumericPrimitive() {
        this.sql("CREATE TABLE T (a TINYINT COMMENT 'a field', b INT COMMENT 'b field', c FLOAT COMMENT 'c field', d DOUBLE, e DECIMAL(10, 4), f DECIMAL(10, 4), g DOUBLE)", new Object[0]);
        this.sql("INSERT INTO T VALUES(cast(1 as TINYINT), 123, 1.23, 3.141592, 3.14156, 3.14159, 1.23)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a INT, b SMALLINT, c DOUBLE, d FLOAT, e BIGINT, f DOUBLE, g TINYINT)", new Object[0]);
        List result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, INT, true, null, null, null, a field]", "+I[b, SMALLINT, true, null, null, null, b field]", "+I[c, DOUBLE, true, null, null, null, c field]", "+I[d, FLOAT, true, null, null, null, null]", "+I[e, BIGINT, true, null, null, null, null]", "+I[f, DOUBLE, true, null, null, null, null]", "+I[g, TINYINT, true, null, null, null, null]"});
        this.sql("INSERT INTO T VALUES(2, cast(456 as SMALLINT), 4.56, 3.14, 456, 4.56, cast(2 as TINYINT))", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[1, 123, 1.2300000190734863, 3.141592, 3, 3.1416, 1]", "+I[2, 456, 4.56, 3.14, 456, 4.56, 2]"});
    }

    @Test
    public void testModifyColumnTypeFromNumericToDecimal() {
        this.sql("CREATE TABLE T (a DECIMAL(10, 4), b DECIMAL(10, 2), c INT, d FLOAT)", new Object[0]);
        this.sql("INSERT INTO T VALUES(1.23456, 1.23, 123, 3.14156)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a DECIMAL(10, 2), b DECIMAL(10, 4), c DECIMAL(10, 4), d DECIMAL(10, 4))", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` DECIMAL(10, 2),\n  `b` DECIMAL(10, 4),\n  `c` DECIMAL(10, 4),\n  `d` DECIMAL(10, 4)"});
        this.sql("INSERT INTO T VALUES(1.2, 1.2345, 456, 4.13)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[1.20, 1.2345, 456.0000, 4.1300]", "+I[1.23, 1.2300, 123.0000, 3.1416]"});
    }

    @Test
    public void testModifyColumnTypeBooleanAndNumeric() {
        this.sql("CREATE TABLE T (a BOOLEAN, b BOOLEAN, c TINYINT, d INT, e BIGINT, f DOUBLE)", new Object[0]);
        this.sql("INSERT INTO T VALUES(true, false, cast(0 as TINYINT), 1 , -9223372036854775808, 3.14)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a TINYINT, b INT, c BOOLEAN, d BOOLEAN, e BOOLEAN)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` TINYINT,\n  `b` INT,\n  `c` BOOLEAN,\n  `d` BOOLEAN,\n  `e` BOOLEAN,"});
        this.sql("INSERT INTO T VALUES(cast(1 as TINYINT), 123, true, true, false, 4.13)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[1, 123, true, true, false, 4.13]", "+I[1, 0, false, true, true, 3.14]"});
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T MODIFY (f BOOLEAN)", new Object[0])).hasRootCauseInstanceOf(IllegalStateException.class).hasRootCauseMessage("Column type f[DOUBLE] cannot be converted to BOOLEAN without loosing information.");
    }

    @Test
    public void testModifyColumnTypeFromNumericToString() {
        this.sql("CREATE TABLE T (a STRING PRIMARY KEY NOT ENFORCED, b INT, c DECIMAL(10, 3), d FLOAT, e DOUBLE)", new Object[0]);
        this.sql("INSERT INTO T VALUES('paimon', 123, 300.123, 400.123, 400.1234)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (b STRING, c VARCHAR(6), d CHAR(3), e CHAR(10))", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647) NOT NULL,\n  `b` VARCHAR(2147483647),\n  `c` VARCHAR(6),\n  `d` CHAR(3),\n  `e` CHAR(10),"});
        this.sql("INSERT INTO T VALUES('apache', '345', '200', '0.12', '1000.12345')", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[apache, 345, 200, 0.1, 1000.12345]", "+I[paimon, 123, 300.12, 400, 400.1234  ]"});
    }

    @Test
    public void testModifyColumnTypeFromBooleanToString() {
        this.sql("CREATE TABLE T (a STRING PRIMARY KEY NOT ENFORCED, b BOOLEAN, c BOOLEAN)", new Object[0]);
        this.sql("INSERT INTO T VALUES('paimon', true, false)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (b STRING, c STRING)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647) NOT NULL,\n  `b` VARCHAR(2147483647),\n  `c` VARCHAR(2147483647),"});
        this.sql("INSERT INTO T VALUES('apache', '345', '200')", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[apache, 345, 200]", "+I[paimon, true, false]"});
    }

    @Test
    public void testModifyColumnTypeFromTimestampToString() {
        this.sql("CREATE TABLE T (a STRING PRIMARY KEY NOT ENFORCED, b TIMESTAMP(3), c TIMESTAMP(6), d DATE, f TIME, g TIMESTAMP(3) WITH LOCAL TIME ZONE)", new Object[0]);
        this.sql("INSERT INTO T VALUES('paimon', TIMESTAMP '2023-06-06 12:00:00', TIMESTAMP '2023-06-06 08:00:00.123456', DATE '2023-05-31', TIME '14:30:00', TO_TIMESTAMP_LTZ(4001, 3))", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (b STRING, c STRING, d STRING, f STRING, g STRING)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647) NOT NULL,\n  `b` VARCHAR(2147483647),\n  `c` VARCHAR(2147483647),\n  `d` VARCHAR(2147483647),\n  `f` VARCHAR(2147483647),\n  `g` VARCHAR(2147483647),"});
        this.sql("INSERT INTO T VALUES('apache', '2023-06-07 12:00:00', '2023-06-07 08:00:00.123456', '2023-06-07', '08:00:00', '2023-06-07 00:00:00.123456')", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[apache, 2023-06-07 12:00:00, 2023-06-07 08:00:00.123456, 2023-06-07, 08:00:00, 2023-06-07 00:00:00.123456]", "+I[paimon, 2023-06-06 12:00:00.000, 2023-06-06 08:00:00.123456, 2023-05-31, 14:30:00, " + BinaryString.fromString((String)DateTimeUtils.formatTimestamp((Timestamp)DateTimeUtils.parseTimestampData((String)"1970-01-01 00:00:04.001", (int)3), (TimeZone)TimeZone.getDefault(), (int)3)) + "]"});
    }

    @Test
    public void testModifyColumnTypeFromStringToString() {
        this.sql("CREATE TABLE T (b VARCHAR(10), c VARCHAR(10), d CHAR(5), e CHAR(5))", new Object[0]);
        this.sql("INSERT INTO T VALUES('paimon', '1234567890', '12345', '12345')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (b VARCHAR(5), c CHAR(5), d VARCHAR(5), e CHAR(6))", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `b` VARCHAR(5),\n  `c` CHAR(5),\n  `d` VARCHAR(5),\n  `e` CHAR(6)"});
        this.sql("INSERT INTO T VALUES('apache', '1234567890', '123456', '1234567')", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[apach, 12345, 12345, 123456]", "+I[paimo, 12345, 12345, 12345 ]"});
    }

    @Test
    public void testModifyColumnTypeFromStringToBoolean() {
        this.sql("CREATE TABLE T (b VARCHAR(10), c VARCHAR(10), d STRING, e CHAR(1))", new Object[0]);
        this.sql("INSERT INTO T VALUES('true', '1', 'yes', 'y')", new Object[0]);
        this.sql("INSERT INTO T VALUES('false', '0', 'no', 'n')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (b BOOLEAN, c BOOLEAN, d BOOLEAN, e BOOLEAN)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `b` BOOLEAN,\n  `c` BOOLEAN,\n  `d` BOOLEAN,\n  `e` BOOLEAN"});
        this.sql("INSERT INTO T VALUES(false, true, false, true)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[true, true, true, true]", "+I[false, false, false, false]", "+I[false, true, false, true]"});
    }

    @Test
    public void testModifyColumnTypeFromStringToNumeric() {
        this.sql("CREATE TABLE T (a VARCHAR(10), b CHAR(1), c VARCHAR(10), d STRING, e STRING)", new Object[0]);
        this.sql("INSERT INTO T VALUES('3.14', '1', '123', '3.14', '3.14')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a DECIMAL(5, 4), b TINYINT, c INT, d DOUBLE, e BIGINT)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` DECIMAL(5, 4),\n  `b` TINYINT,\n  `c` INT,\n  `d` DOUBLE,\n  `e` BIGINT"});
        this.sql("INSERT INTO T VALUES(4.13, cast(2 as TINYINT), 456, 3.14, 4)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[3.1400, 1, 123, 3.14, 3]", "+I[4.1300, 2, 456, 3.14, 4]"});
        this.sql("CREATE TABLE T1 (a STRING, b STRING)", new Object[0]);
        this.sql("ALTER TABLE T1 SET ('disable-explicit-type-casting' = 'false')", new Object[0]);
        this.sql("INSERT INTO T1 VALUES('test', '3.14')", new Object[0]);
        this.sql("ALTER TABLE T1 MODIFY (a INT, b TINYINT)", new Object[0]);
        Assertions.assertThatThrownBy(() -> this.sql("SELECT * FROM T1", new Object[0])).hasRootCauseInstanceOf(NumberFormatException.class).hasRootCauseMessage("For input string: 'test'. Invalid character found.");
    }

    @Test
    public void testModifyColumnTypeFromStringToTimestamp() {
        this.sql("CREATE TABLE T (a VARCHAR(30), b CHAR(20), c VARCHAR(20), d STRING, e STRING)", new Object[0]);
        this.sql("INSERT INTO T VALUES('2022-12-12 09:30:10', '2022-12-12', '09:30:00', '2022-12-12 09:30:00.123456', '2022-12-12 00:30:00.123456')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a TIMESTAMP, b DATE, c TIME, d TIMESTAMP(3), e TIMESTAMP(3) WITH LOCAL TIME ZONE)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` TIMESTAMP(6),\n  `b` DATE,\n  `c` TIME(0),\n  `d` TIMESTAMP(3),\n  `e` TIMESTAMP(3) WITH LOCAL TIME ZONE"});
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[2022-12-12T09:30:10, 2022-12-12, 09:30, 2022-12-12T09:30:00.123, " + DateTimeUtils.timestampToTimestampWithLocalZone((Timestamp)DateTimeUtils.parseTimestampData((String)"2022-12-12 00:30:00.123456", (int)3), (TimeZone)TimeZone.getDefault()).toLocalDateTime().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + "Z]"});
    }

    @Test
    public void testModifyColumnTypeStringToBinary() {
        this.sql("CREATE TABLE T (a VARCHAR(5), b VARCHAR(10), c VARCHAR(10), d VARCHAR(10))", new Object[0]);
        this.sql("INSERT INTO T VALUES('Apache Paimon', 'Apache Paimon','Apache Paimon','Apache Paimon')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a BINARY(10), b BINARY(5), c VARBINARY(5), d VARBINARY(20))", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` BINARY(10),\n  `b` BINARY(5),\n  `c` VARBINARY(5),\n  `d` VARBINARY(20)"});
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[[65, 112, 97, 99, 104, 0, 0, 0, 0, 0], [65, 112, 97, 99, 104], [65, 112, 97, 99, 104], [65, 112, 97, 99, 104, 101, 32, 80, 97, 105]]"});
    }

    @Test
    public void testModifyColumnTypeFromTimestampToTimestamp() {
        this.sql("CREATE TABLE T (a TIMESTAMP(6), b TIMESTAMP(6), c TIMESTAMP(6) WITH LOCAL TIME ZONE, d TIMESTAMP(6) WITH LOCAL TIME ZONE)", new Object[0]);
        this.sql("INSERT INTO T VALUES(TIMESTAMP '2022-12-01 09:00:00.123456', TIMESTAMP '2022-12-02 09:00:00.123456', TO_TIMESTAMP_LTZ(4001, 3), TO_TIMESTAMP_LTZ(4001, 3))", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a TIMESTAMP(3), b TIMESTAMP(6) WITH LOCAL TIME ZONE, c TIMESTAMP(3) WITH LOCAL TIME ZONE, d TIMESTAMP(3))", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` TIMESTAMP(3),\n  `b` TIMESTAMP(6) WITH LOCAL TIME ZONE,\n  `c` TIMESTAMP(3) WITH LOCAL TIME ZONE,\n  `d` TIMESTAMP(3)"});
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[2022-12-01T09:00:00.123, " + DateTimeUtils.timestampToTimestampWithLocalZone((Timestamp)DateTimeUtils.parseTimestampData((String)"2022-12-02 09:00:00.123456", (int)6), (TimeZone)TimeZone.getDefault()).toLocalDateTime().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + "Z, 1970-01-01T00:00:04.001Z, " + DateTimeUtils.timestampWithLocalZoneToTimestamp((Timestamp)DateTimeUtils.parseTimestampData((String)"1970-01-01 00:00:04.001", (int)3), (TimeZone)TimeZone.getDefault()).toLocalDateTime().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + "]"});
    }

    @Test
    public void testModifyColumnTypeFromDateToTimestamp() {
        this.sql("CREATE TABLE T (a DATE, b DATE)", new Object[0]);
        this.sql("INSERT INTO T VALUES(DATE '2022-12-12', DATE '2022-12-11')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a TIMESTAMP(6), b TIMESTAMP(6) WITH LOCAL TIME ZONE)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` TIMESTAMP(6),\n  `b` TIMESTAMP(6) WITH LOCAL TIME ZONE"});
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[2022-12-12T00:00, " + DateTimeUtils.timestampToTimestampWithLocalZone((Timestamp)DateTimeUtils.parseTimestampData((String)"2022-12-11", (int)6), (TimeZone)TimeZone.getDefault()).toLocalDateTime().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME) + "Z]"});
    }

    @Test
    public void testModifyColumnTypeFromTimeToTimestamp() {
        this.sql("CREATE TABLE T (a TIME, b TIME(2), c TIME(3))", new Object[0]);
        this.sql("INSERT INTO T VALUES(TIME '09:30:10', TIME '09:30:10.24', TIME '09:30:10.123')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a TIMESTAMP(3), b TIMESTAMP(6), c TIMESTAMP(6) WITH LOCAL TIME ZONE)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` TIMESTAMP(3),\n  `b` TIMESTAMP(6),\n  `c` TIMESTAMP(6) WITH LOCAL TIME ZONE"});
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[1970-01-01T09:30:10, 1970-01-01T09:30:10.240, 1970-01-01T09:30:10.123Z]"});
    }

    @Test
    public void testModifyColumnTypeBinaryToBinary() {
        this.sql("CREATE TABLE T (a BINARY(5), b BINARY(10), c BINARY(10), d BINARY(10), e VARBINARY(5), f VARBINARY(10), g VARBINARY(10), h VARBINARY(10))", new Object[0]);
        this.sql("INSERT INTO T VALUES(X'0123456789', X'0123456789',X'0123456789',X'0123456789',X'0123456789',X'0123456789',X'0123456789',X'0123456789')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (a BINARY(10), b BINARY(5), c VARBINARY(5), d VARBINARY(20), e VARBINARY(10), f VARBINARY(5), g BINARY(5), h BINARY(20))", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` BINARY(10),\n  `b` BINARY(5),\n  `c` VARBINARY(5),\n  `d` VARBINARY(20),\n  `e` VARBINARY(10),\n  `f` VARBINARY(5),\n  `g` BINARY(5),\n  `h` BINARY(20)"});
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result.stream().map(Objects::toString).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"+I[[1, 35, 69, 103, -119, 0, 0, 0, 0, 0], [1, 35, 69, 103, -119], [1, 35, 69, 103, -119], [1, 35, 69, 103, -119, 0, 0, 0, 0, 0], [1, 35, 69, 103, -119], [1, 35, 69, 103, -119], [1, 35, 69, 103, -119], [1, 35, 69, 103, -119, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]]"});
    }

    @Test
    public void testModifyColumnPosition() {
        this.sql("CREATE TABLE T (a STRING PRIMARY KEY NOT ENFORCED, b STRING, c STRING, d INT, e DOUBLE)", new Object[0]);
        this.sql("INSERT INTO T VALUES('paimon', 'bbb', 'ccc', 1, 3.4)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY b STRING FIRST", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `b` VARCHAR(2147483647),\n  `a` VARCHAR(2147483647) NOT NULL,\n  `c` VARCHAR(2147483647),\n  `d` INT,\n  `e` DOUBLE,"});
        this.sql("INSERT INTO T VALUES('aaa', 'flink', 'ddd', 2, 5.7)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[aaa, flink, ddd, 2, 5.7], +I[bbb, paimon, ccc, 1, 3.4]]");
        this.sql("ALTER TABLE T MODIFY e DOUBLE AFTER c", new Object[0]);
        result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `b` VARCHAR(2147483647),\n  `a` VARCHAR(2147483647) NOT NULL,\n  `c` VARCHAR(2147483647),\n  `e` DOUBLE,\n  `d` INT,"});
        this.sql("INSERT INTO T VALUES('sss', 'ggg', 'eee', 4.7, 10)", new Object[0]);
        result = this.sql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[aaa, flink, ddd, 5.7, 2], +I[sss, ggg, eee, 4.7, 10], +I[bbb, paimon, ccc, 3.4, 1]]");
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T MODIFY b STRING FIRST", new Object[0])).satisfies(new ThrowingConsumer[]{PaimonAssertions.anyCauseMatches(UnsupportedOperationException.class, (String)"Cannot move itself for column b")});
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T MODIFY b STRING AFTER b", new Object[0])).satisfies(new ThrowingConsumer[]{PaimonAssertions.anyCauseMatches(UnsupportedOperationException.class, (String)"Cannot move itself for column b")});
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T MODIFY h STRING FIRST", new Object[0])).hasMessageContaining("Try to modify a column `h` which does not exist in the table");
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T MODIFY h STRING AFTER d", new Object[0])).hasMessageContaining("Try to modify a column `h` which does not exist in the table");
    }

    @Test
    public void testModifyNullability() {
        this.sql("CREATE TABLE T (a STRING PRIMARY KEY NOT ENFORCED, b STRING, c STRING, d INT, e FLOAT NOT NULL)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647) NOT NULL,\n  `b` VARCHAR(2147483647),\n  `c` VARCHAR(2147483647),\n  `d` INT,\n  `e` FLOAT NOT NULL,"});
        Assertions.assertThatThrownBy(() -> this.sql("INSERT INTO T VALUES('aaa', 'bbb', 'ccc', 1, CAST(NULL AS FLOAT))", new Object[0])).satisfies(new ThrowingConsumer[]{PaimonAssertions.anyCauseMatches(TableException.class, (String)"Column 'e' is NOT NULL, however, a null value is being written into it.")});
        this.sql("ALTER TABLE T MODIFY e FLOAT", new Object[0]);
        result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647) NOT NULL,\n  `b` VARCHAR(2147483647),\n  `c` VARCHAR(2147483647),\n  `d` INT,\n  `e` FLOAT"});
        this.sql("ALTER TABLE T SET ('alter-column-null-to-not-null.disabled' = 'false')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY c STRING NOT NULL", new Object[0]);
        result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` VARCHAR(2147483647) NOT NULL,\n  `b` VARCHAR(2147483647),\n  `c` VARCHAR(2147483647) NOT NULL,\n  `d` INT,\n  `e` FLOAT"});
        Assertions.assertThatThrownBy(() -> this.sql("INSERT INTO T VALUES('aaa', 'bbb', CAST(NULL AS STRING), 1, CAST(NULL AS FLOAT))", new Object[0])).satisfies(new ThrowingConsumer[]{PaimonAssertions.anyCauseMatches(TableException.class, (String)"Column 'c' is NOT NULL, however, a null value is being written into it.")});
        this.sql("INSERT INTO T VALUES('aaa', 'bbb', 'ccc', 1, CAST(NULL AS FLOAT))", new Object[0]);
        result = this.sql("select * from T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[aaa, bbb, ccc, 1, null]]");
        this.tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_NOT_NULL_ENFORCER, (Object)ExecutionConfigOptions.NotNullEnforcer.DROP);
        this.sql("ALTER TABLE T MODIFY e FLOAT NOT NULL;\n", new Object[0]);
        this.sql("INSERT INTO T VALUES('aa2', 'bb2', 'cc2', 2, 2.5)", new Object[0]);
        result = this.sql("select * from T", new Object[0]);
        Assertions.assertThat((String)result.toString()).isEqualTo("[+I[aa2, bb2, cc2, 2, 2.5]]");
    }

    @Test
    public void testModifyColumnComment() {
        this.sql("CREATE TABLE T (a STRING, b STRING COMMENT 'from column b')", new Object[0]);
        List result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null, null]", "+I[b, STRING, true, null, null, null, from column b]"});
        this.sql("ALTER TABLE T MODIFY a STRING COMMENT 'from column a'", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null, from column a]", "+I[b, STRING, true, null, null, null, from column b]"});
        this.sql("ALTER TABLE T MODIFY b STRING COMMENT 'from column b updated'", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null, from column a]", "+I[b, STRING, true, null, null, null, from column b updated]"});
    }

    @Test
    public void testAddWatermark() {
        this.sql("CREATE TABLE T (a STRING, ts TIMESTAMP(3))", new Object[0]);
        List result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null]", "+I[ts, TIMESTAMP(3), true, null, null, null]"});
        this.sql("ALTER TABLE T ADD WATERMARK FOR ts AS ts - INTERVAL '1' HOUR", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null]", "+I[ts, TIMESTAMP(3), true, null, null, `ts` - INTERVAL '1' HOUR]"});
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T ADD WATERMARK FOR ts AS ts - INTERVAL '2' HOUR", new Object[0])).hasMessageContaining("The base table has already defined the watermark strategy");
    }

    @Test
    public void testDropWatermark() {
        this.sql("CREATE TABLE T (a STRING, ts TIMESTAMP(3), WATERMARK FOR ts AS ts - INTERVAL '1' HOUR)", new Object[0]);
        List result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null]", "+I[ts, TIMESTAMP(3), true, null, null, `ts` - INTERVAL '1' HOUR]"});
        this.sql("ALTER TABLE T DROP WATERMARK", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null]", "+I[ts, TIMESTAMP(3), true, null, null, null]"});
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T DROP WATERMARK", new Object[0])).hasMessageContaining("The base table does not define any watermark strategy");
    }

    @Test
    public void testModifyWatermark() {
        this.sql("CREATE TABLE T (a STRING, ts TIMESTAMP(3))", new Object[0]);
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T MODIFY WATERMARK FOR ts AS ts - INTERVAL '1' HOUR", new Object[0])).hasMessageContaining("The base table does not define any watermark");
        this.sql("ALTER TABLE T ADD WATERMARK FOR ts AS ts - INTERVAL '1' HOUR", new Object[0]);
        this.sql("ALTER TABLE T MODIFY WATERMARK FOR ts AS ts - INTERVAL '2' HOUR", new Object[0]);
        List result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null]", "+I[ts, TIMESTAMP(3), true, null, null, `ts` - INTERVAL '2' HOUR]"});
    }

    @Test
    public void testSetAndRemoveOption() throws Exception {
        this.sql("CREATE TABLE T (a STRING, b STRING, c STRING)", new Object[0]);
        this.sql("ALTER TABLE T SET ('xyc'='unknown1', 'abc'='unknown2')", new Object[0]);
        Map options = this.table("T").getOptions();
        Assertions.assertThat((Map)options).containsEntry((Object)"xyc", (Object)"unknown1");
        Assertions.assertThat((Map)options).containsEntry((Object)"abc", (Object)"unknown2");
        this.sql("ALTER TABLE T RESET ('xyc', 'abc')", new Object[0]);
        options = this.table("T").getOptions();
        Assertions.assertThat((Map)options).doesNotContainKey((Object)"xyc");
        Assertions.assertThat((Map)options).doesNotContainKey((Object)"abc");
    }

    @Test
    public void testSetAndResetImmutableOptionsOnEmptyTables() {
        this.sql("CREATE TABLE T1 (a INT, b INT)", new Object[0]);
        this.sql("ALTER TABLE T1 SET ('primary-key' = 'a', 'bucket' = '1', 'merge-engine' = 'first-row')", new Object[0]);
        this.sql("INSERT INTO T1 VALUES (1, 10), (2, 20), (1, 11), (2, 21)", new Object[0]);
        Assertions.assertThat(this.queryAndSort("SELECT * FROM T1")).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, 10}), Row.of((Object[])new Object[]{2, 20})});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T1 SET ('merge-engine' = 'deduplicate')", new Object[0])).rootCause().isInstanceOf(UnsupportedOperationException.class)).hasMessage("Change 'merge-engine' is not supported yet.");
        this.sql("CREATE TABLE T2 (a INT, b INT, PRIMARY KEY (a) NOT ENFORCED) WITH ('bucket' = '1', 'merge-engine' = 'first-row')", new Object[0]);
        this.sql("ALTER TABLE T2 RESET ('merge-engine')", new Object[0]);
        this.sql("INSERT INTO T2 VALUES (1, 10), (2, 20), (1, 11), (2, 21)", new Object[0]);
        Assertions.assertThat(this.queryAndSort("SELECT * FROM T2")).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, 11}), Row.of((Object[])new Object[]{2, 21})});
    }

    @Test
    public void testSetAndResetImmutableOptionsOnNonEmptyTables() {
        this.sql("CREATE TABLE T1 (a STRING, b STRING, c STRING) WITH ('bucket' = '1', 'bucket-key' = 'a')", new Object[0]);
        this.sql("INSERT INTO T1 VALUES ('a', 'b', 'c')", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T1 SET ('bucket-key' = 'c')", new Object[0])).rootCause().isInstanceOf(UnsupportedOperationException.class)).hasMessage("Change 'bucket-key' is not supported yet.");
        this.sql("CREATE TABLE T2 (a STRING, b STRING, c STRING) WITH ('bucket' = '1', 'bucket-key' = 'c')", new Object[0]);
        this.sql("INSERT INTO T2 VALUES ('a', 'b', 'c')", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T2 RESET ('bucket-key')", new Object[0])).rootCause().isInstanceOf(UnsupportedOperationException.class)).hasMessage("Change 'bucket-key' is not supported yet.");
        this.sql("CREATE TABLE T4 (a STRING, b STRING, c STRING) WITH ('merge-engine' = 'partial-update')", new Object[0]);
        this.sql("INSERT INTO T4 VALUES ('a', 'b', 'c')", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T4 RESET ('merge-engine')", new Object[0])).rootCause().isInstanceOf(UnsupportedOperationException.class)).hasMessage("Change 'merge-engine' is not supported yet.");
        this.sql("CREATE TABLE T5 (a STRING, b STRING, c STRING) WITH ('sequence.field' = 'b')", new Object[0]);
        this.sql("INSERT INTO T5 VALUES ('a', 'b', 'c')", new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T5 SET ('sequence.field' = 'c')", new Object[0])).rootCause().isInstanceOf(UnsupportedOperationException.class)).hasMessage("Change 'sequence.field' is not supported yet.");
    }

    @Test
    public void testAlterTableComment() throws Exception {
        this.sql("CREATE TABLE T (a STRING, b STRING, c STRING)", new Object[0]);
        this.sql("ALTER TABLE T SET ('comment'='t comment')", new Object[0]);
        String comment = this.table("T").getComment();
        Assertions.assertThat((String)comment).isEqualTo("t comment");
        this.sql("ALTER TABLE T SET ('comment'='t comment v2')", new Object[0]);
        comment = this.table("T").getComment();
        Assertions.assertThat((String)comment).isEqualTo("t comment v2");
        this.sql("ALTER TABLE T RESET ('comment')", new Object[0]);
        comment = this.table("T").getComment();
        Assertions.assertThat((String)comment).isEmpty();
    }

    @Test
    public void testAlterTableSchema() {
        this.sql("CREATE TABLE T (a STRING, b STRING COMMENT 'from column b')", new Object[0]);
        List result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null, null]", "+I[b, STRING, true, null, null, null, from column b]"});
        this.sql("ALTER TABLE T ADD (c INT AFTER b)", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null, null]", "+I[b, STRING, true, null, null, null, from column b]", "+I[c, INT, true, null, null, null, null]"});
        this.sql("ALTER TABLE T ADD (d INT FIRST)", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[d, INT, true, null, null, null, null]", "+I[a, STRING, true, null, null, null, null]", "+I[b, STRING, true, null, null, null, from column b]", "+I[c, INT, true, null, null, null, null]"});
        this.sql("ALTER TABLE T DROP d", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null, null]", "+I[b, STRING, true, null, null, null, from column b]", "+I[c, INT, true, null, null, null, null]"});
        this.sql("ALTER TABLE T MODIFY (c BIGINT)", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null, null]", "+I[b, STRING, true, null, null, null, from column b]", "+I[c, BIGINT, true, null, null, null, null]"});
        this.sql("ALTER TABLE T MODIFY (c INT)", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null, null]", "+I[b, STRING, true, null, null, null, from column b]", "+I[c, INT, true, null, null, null, null]"});
        this.sql("ALTER TABLE T MODIFY (c STRING)", new Object[0]);
        result = this.sql("DESC T", new Object[0]).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new String[]{"+I[a, STRING, true, null, null, null, null]", "+I[b, STRING, true, null, null, null, from column b]", "+I[c, STRING, true, null, null, null, null]"});
    }

    @Test
    public void testAlterTableNonPhysicalColumn() {
        this.sql("CREATE TABLE T (a INT,  c ROW < a INT, d INT> METADATA, b INT, ts TIMESTAMP(3), WATERMARK FOR ts AS ts)", new Object[0]);
        this.sql("ALTER TABLE T ADD e VARCHAR METADATA", new Object[0]);
        this.sql("ALTER TABLE T DROP c ", new Object[0]);
        this.sql("ALTER TABLE T RENAME e TO ee", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        ((AbstractStringAssert)Assertions.assertThat((String)result.get(0).toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` INT,\n  `b` INT,\n  `ts` TIMESTAMP(3),\n  `ee` VARCHAR(2147483647) METADATA,\n  WATERMARK FOR `ts` AS `ts`\n)"})).doesNotContain(new CharSequence[]{"schema"});
    }

    @Test
    public void testSequenceFieldSortOrder() {
        this.sql("CREATE TABLE T1 (a STRING PRIMARY KEY NOT ENFORCED, b STRING, c STRING) WITH ('sequence.field'='c')", new Object[0]);
        this.sql("INSERT INTO T1 VALUES ('a', 'b', 'l')", new Object[0]);
        this.sql("INSERT INTO T1 VALUES ('a', 'd', 'n')", new Object[0]);
        this.sql("INSERT INTO T1 VALUES ('a', 'e', 'm')", new Object[0]);
        Assertions.assertThat((String)this.sql("select * from T1", new Object[0]).toString()).isEqualTo("[+I[a, d, n]]");
        this.sql("CREATE TABLE T2 (a STRING PRIMARY KEY NOT ENFORCED, b STRING, c BIGINT) WITH ('sequence.field'='c', 'sequence.field.sort-order'='descending')", new Object[0]);
        this.sql("INSERT INTO T2 VALUES ('a', 'b', 1)", new Object[0]);
        this.sql("INSERT INTO T2 VALUES ('a', 'd', 3)", new Object[0]);
        this.sql("INSERT INTO T2 VALUES ('a', 'e', 2)", new Object[0]);
        Assertions.assertThat((String)this.sql("select * from T2", new Object[0]).toString()).isEqualTo("[+I[a, b, 1]]");
        this.sql("CREATE TABLE T3 (a STRING PRIMARY KEY NOT ENFORCED, b STRING, c DOUBLE) WITH ('sequence.field'='c', 'sequence.field.sort-order'='ascending')", new Object[0]);
        this.sql("INSERT INTO T3 VALUES ('a', 'b', 1.0)", new Object[0]);
        this.sql("INSERT INTO T3 VALUES ('a', 'd', 3.0)", new Object[0]);
        this.sql("INSERT INTO T3 VALUES ('a', 'e', 2.0)", new Object[0]);
        Assertions.assertThat((String)this.sql("select * from T3", new Object[0]).toString()).isEqualTo("[+I[a, d, 3.0]]");
    }

    @Test
    public void testAlterTableMetadataComment() {
        this.sql("CREATE TABLE T (a INT, name VARCHAR METADATA COMMENT 'header1', b INT)", new Object[0]);
        List<Row> result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        ((AbstractStringAssert)Assertions.assertThat((String)result.get(0).toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` INT,\n  `name` VARCHAR(2147483647) METADATA COMMENT 'header1',\n  `b` INT\n)"})).doesNotContain(new CharSequence[]{"schema"});
        this.sql("ALTER TABLE T MODIFY name VARCHAR METADATA COMMENT 'header2'", new Object[0]);
        result = this.sql("SHOW CREATE TABLE T", new Object[0]);
        ((AbstractStringAssert)Assertions.assertThat((String)result.get(0).toString()).contains(new CharSequence[]{"CREATE TABLE `PAIMON`.`default`.`T` (\n  `a` INT,\n  `name` VARCHAR(2147483647) METADATA COMMENT 'header2',\n  `b` INT\n)"})).doesNotContain(new CharSequence[]{"schema"});
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T MODIFY name VARCHAR COMMENT 'header3'", new Object[0])).satisfies(new ThrowingConsumer[]{PaimonAssertions.anyCauseMatches(UnsupportedOperationException.class, (String)"Change is not supported: class org.apache.flink.table.catalog.TableChange$ModifyColumn")});
    }

    @Test
    public void testAlterBucket() {
        this.sql("CREATE TABLE T1 (a INT PRIMARY KEY NOT ENFORCED, b STRING) WITH ('bucket' = '-1')", new Object[0]);
        this.sql("INSERT INTO T1 VALUES (1, '1')", new Object[0]);
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T1 RESET ('bucket')", new Object[0])).satisfies(new ThrowingConsumer[]{PaimonAssertions.anyCauseMatches(UnsupportedOperationException.class, (String)"Cannot reset bucket.")});
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T1 SET ('bucket' = '1')", new Object[0])).satisfies(new ThrowingConsumer[]{PaimonAssertions.anyCauseMatches(UnsupportedOperationException.class, (String)"Cannot change bucket when it is -1.")});
        this.sql("CREATE TABLE T2 (a INT PRIMARY KEY NOT ENFORCED, b STRING) WITH ('bucket' = '1')", new Object[0]);
        this.sql("INSERT INTO T2 VALUES (1, '1')", new Object[0]);
        Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE T2 SET ('bucket' = '-1')", new Object[0])).satisfies(new ThrowingConsumer[]{PaimonAssertions.anyCauseMatches(UnsupportedOperationException.class, (String)"Cannot change bucket to -1.")});
    }

    @ParameterizedTest
    @ValueSource(strings={"orc", "avro", "parquet"})
    public void testUpdateNestedColumn(String formatType) {
        this.sql("CREATE TABLE T ( k INT, v ROW(f1 INT, f2 ROW(f1 STRING, f2 INT NOT NULL)), PRIMARY KEY (k) NOT ENFORCED ) WITH ( 'bucket' = '1', 'file.format' = '" + formatType + "' )", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, ROW(10, ROW('apple', 100))), (2, ROW(20, ROW('banana', 200)))", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, Row.of((Object[])new Object[]{10, Row.of((Object[])new Object[]{"apple", 100})})}), Row.of((Object[])new Object[]{2, Row.of((Object[])new Object[]{20, Row.of((Object[])new Object[]{"banana", 200})})})});
        this.sql("ALTER TABLE T MODIFY (v ROW(f1 BIGINT, f2 ROW(f3 DOUBLE, f2 INT), f3 STRING))", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, ROW(1000000000001, ROW(101.0, 101), 'cat')), (3, ROW(3000000000001, ROW(301.0, CAST(NULL AS INT)), 'dog'))", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, Row.of((Object[])new Object[]{1000000000001L, Row.of((Object[])new Object[]{101.0, 101}), "cat"})}), Row.of((Object[])new Object[]{2, Row.of((Object[])new Object[]{20L, Row.of((Object[])new Object[]{null, 200}), null})}), Row.of((Object[])new Object[]{3, Row.of((Object[])new Object[]{3000000000001L, Row.of((Object[])new Object[]{301.0, null}), "dog"})})});
        this.sql("ALTER TABLE T MODIFY (v ROW(f1 BIGINT, f2 ROW(f3 DOUBLE, f1 STRING, f2 INT), f3 STRING))", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, ROW(1000000000002, ROW(102.0, 'APPLE', 102), 'cat')), (4, ROW(4000000000002, ROW(402.0, 'LEMON', 402), 'tiger'))", new Object[0]);
        Assertions.assertThat(this.sql("SELECT k, v.f2.f1, v.f3 FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, "APPLE", "cat"}), Row.of((Object[])new Object[]{2, null, null}), Row.of((Object[])new Object[]{3, null, "dog"}), Row.of((Object[])new Object[]{4, "LEMON", "tiger"})});
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY (v ROW(f1 BIGINT, f2 INT, f3 STRING))", new Object[0])).hasRootCauseMessage("Column v.f2 can only be updated to row type, and cannot be updated to INTEGER type");
    }

    @ParameterizedTest
    @ValueSource(strings={"orc", "avro", "parquet"})
    public void testUpdateRowInArrayAndMap(String formatType) {
        this.sql("CREATE TABLE T ( k INT, v1 ARRAY<ROW(f1 INT, f2 STRING)>, v2 MAP<INT, ROW(f1 STRING, f2 INT)>, PRIMARY KEY (k) NOT ENFORCED ) WITH ( 'bucket' = '1', 'file.format' = '" + formatType + "' )", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, ARRAY[ROW(100, 'apple'), ROW(101, 'banana')], MAP[100, ROW('cat', 1000), 101, ROW('dog', 1001)]), (2, ARRAY[ROW(200, 'pear'), ROW(201, 'grape')], MAP[200, ROW('tiger', 2000), 201, ROW('wolf', 2001)])", new Object[0]);
        HashMap<Integer, Row> map1 = new HashMap<Integer, Row>();
        map1.put(100, Row.of((Object[])new Object[]{"cat", 1000}));
        map1.put(101, Row.of((Object[])new Object[]{"dog", 1001}));
        HashMap<Integer, Row> map2 = new HashMap<Integer, Row>();
        map2.put(200, Row.of((Object[])new Object[]{"tiger", 2000}));
        map2.put(201, Row.of((Object[])new Object[]{"wolf", 2001}));
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, new Row[]{Row.of((Object[])new Object[]{100, "apple"}), Row.of((Object[])new Object[]{101, "banana"})}, map1}), Row.of((Object[])new Object[]{2, new Row[]{Row.of((Object[])new Object[]{200, "pear"}), Row.of((Object[])new Object[]{201, "grape"})}, map2})});
        this.sql("ALTER TABLE T MODIFY (v1 ARRAY<ROW(f1 BIGINT, f2 STRING, f3 STRING)>, v2 MAP<INT, ROW(f3 DOUBLE, f2 INT)>)", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, ARRAY[ROW(1000000000000, 'apple', 'A'), ROW(1000000000001, 'banana', 'B')], MAP[100, ROW(1000.0, 1000), 101, ROW(1001.0, 1001)]), (3, ARRAY[ROW(3000000000000, 'mango', 'M'), ROW(3000000000001, 'cherry', 'C')], MAP[300, ROW(3000.0, 3000), 301, ROW(3001.0, 3001)])", new Object[0]);
        map1.clear();
        map1.put(100, Row.of((Object[])new Object[]{1000.0, 1000}));
        map1.put(101, Row.of((Object[])new Object[]{1001.0, 1001}));
        map2.clear();
        map2.put(200, Row.of((Object[])new Object[]{null, 2000}));
        map2.put(201, Row.of((Object[])new Object[]{null, 2001}));
        HashMap<Integer, Row> map3 = new HashMap<Integer, Row>();
        map3.put(300, Row.of((Object[])new Object[]{3000.0, 3000}));
        map3.put(301, Row.of((Object[])new Object[]{3001.0, 3001}));
        Assertions.assertThat(this.sql("SELECT v2, v1, k FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{map1, new Row[]{Row.of((Object[])new Object[]{1000000000000L, "apple", "A"}), Row.of((Object[])new Object[]{1000000000001L, "banana", "B"})}, 1}), Row.of((Object[])new Object[]{map2, new Row[]{Row.of((Object[])new Object[]{200L, "pear", null}), Row.of((Object[])new Object[]{201L, "grape", null})}, 2}), Row.of((Object[])new Object[]{map3, new Row[]{Row.of((Object[])new Object[]{3000000000000L, "mango", "M"}), Row.of((Object[])new Object[]{3000000000001L, "cherry", "C"})}, 3})});
    }

    @ParameterizedTest
    @ValueSource(strings={"orc", "avro", "parquet"})
    public void testUpdateNullabilityPrimitiveType(String formatType) {
        this.sql("CREATE TABLE T ( k INT, v INT NOT NULL, PRIMARY KEY (k) NOT ENFORCED ) WITH ( 'bucket' = '1', 'file.format' = '" + formatType + "' )", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, 100), (2, 200)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 100}), Row.of((Object[])new Object[]{2, 200})});
        this.sql("ALTER TABLE T MODIFY v INT", new Object[0]);
        this.sql("INSERT INTO T VALUES (3, CAST(NULL AS INT))", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 100}), Row.of((Object[])new Object[]{2, 200}), Row.of((Object[])new Object[]{3, null})});
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY v INT NOT NULL", new Object[0])).hasStackTraceContaining("Cannot update column type from nullable to non nullable for v");
    }

    @ParameterizedTest
    @ValueSource(strings={"orc", "avro", "parquet"})
    public void testUpdateNullabilityRowType(String formatType) {
        this.sql("CREATE TABLE T ( k INT, v ROW(f1 INT, f2 INT NOT NULL) NOT NULL, PRIMARY KEY (k) NOT ENFORCED ) WITH ( 'bucket' = '1', 'file.format' = '" + formatType + "' )", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, ROW(10, 100)), (2, ROW(20, 200))", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, Row.of((Object[])new Object[]{10, 100})}), Row.of((Object[])new Object[]{2, Row.of((Object[])new Object[]{20, 200})})});
        this.sql("ALTER TABLE T MODIFY (v ROW(f1 INT, f2 INT) NOT NULL)", new Object[0]);
        this.sql("INSERT INTO T VALUES (3, ROW(30, CAST(NULL AS INT)))", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, Row.of((Object[])new Object[]{10, 100})}), Row.of((Object[])new Object[]{2, Row.of((Object[])new Object[]{20, 200})}), Row.of((Object[])new Object[]{3, Row.of((Object[])new Object[]{30, null})})});
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY (v ROW(f1 INT NOT NULL, f2 INT) NOT NULL)", new Object[0])).hasStackTraceContaining("Cannot update column type from nullable to non nullable for v.f1");
        this.sql("ALTER TABLE T MODIFY (v ROW(f1 INT, f2 INT))", new Object[0]);
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY (v ROW(f1 INT, f2 INT) NOT NULL)", new Object[0])).hasStackTraceContaining("Cannot update column type from nullable to non nullable for v");
    }

    @ParameterizedTest
    @ValueSource(strings={"orc", "avro", "parquet"})
    public void testUpdateNullabilityArrayAndMapType(String formatType) {
        this.sql("CREATE TABLE T ( k INT, v1 ARRAY<ROW(f1 INT, f2 INT) NOT NULL>, v2 MAP<INT, ROW(f1 INT, f2 INT) NOT NULL>, PRIMARY KEY (k) NOT ENFORCED ) WITH ( 'bucket' = '1', 'file.format' = '" + formatType + "' )", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, ARRAY[ROW(10, 100), ROW(20, 200)], MAP[11, ROW(10, 100), 12, ROW(11, 110)]), (2, ARRAY[ROW(30, 300), ROW(40, 400)], MAP[21, ROW(20, 200), 22, ROW(21, 210)])", new Object[0]);
        HashMap<Integer, Row> map1 = new HashMap<Integer, Row>();
        map1.put(11, Row.of((Object[])new Object[]{10, 100}));
        map1.put(12, Row.of((Object[])new Object[]{11, 110}));
        HashMap<Integer, Row> map2 = new HashMap<Integer, Row>();
        map2.put(21, Row.of((Object[])new Object[]{20, 200}));
        map2.put(22, Row.of((Object[])new Object[]{21, 210}));
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, new Row[]{Row.of((Object[])new Object[]{10, 100}), Row.of((Object[])new Object[]{20, 200})}, map1}), Row.of((Object[])new Object[]{2, new Row[]{Row.of((Object[])new Object[]{30, 300}), Row.of((Object[])new Object[]{40, 400})}, map2})});
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY (v1 ARRAY<ROW(f1 INT, f2 INT) NOT NULL> NOT NULL)", new Object[0])).hasRootCauseMessage("Cannot update column type from nullable to non nullable for v1. You can set table configuration option 'alter-column-null-to-not-null.disabled' = 'false' to allow converting null columns to not null");
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY (v1 ARRAY<ROW(f1 INT NOT NULL, f2 INT) NOT NULL>)", new Object[0])).hasStackTraceContaining("Cannot update column type from nullable to non nullable for v1.element.f1");
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY (v2 MAP<INT, ROW(f1 INT, f2 INT) NOT NULL> NOT NULL)", new Object[0])).hasStackTraceContaining("Cannot update column type from nullable to non nullable for v2");
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY (v2 MAP<INT, ROW(f1 INT, f2 INT NOT NULL) NOT NULL>)", new Object[0])).hasStackTraceContaining("Cannot update column type from nullable to non nullable for v2.value.f2");
    }

    @ParameterizedTest
    @ValueSource(strings={"orc", "avro", "parquet"})
    public void testUpdateNullabilityByEnablingNullToNotNullOption(String formatType) {
        this.sql("CREATE TABLE T ( k INT, v INT, PRIMARY KEY (k) NOT ENFORCED ) WITH ( 'bucket' = '1', 'file.format' = '" + formatType + "' )", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, 10), (2, 20)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 10}), Row.of((Object[])new Object[]{2, 20})});
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY v INT NOT NULL", new Object[0])).hasStackTraceContaining("Cannot update column type from nullable to non nullable for v");
        this.sql("ALTER TABLE T SET ('alter-column-null-to-not-null.disabled' = 'false')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY v INT NOT NULL", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 10}), Row.of((Object[])new Object[]{2, 20})});
    }

    @Test
    public void testAlterColumnTypeWithNullabilityUpdate() {
        this.sql("CREATE TABLE T ( k INT, v INT, PRIMARY KEY(k) NOT ENFORCED )", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, 10), (2, 20)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 10}), Row.of((Object[])new Object[]{2, 20})});
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY v BIGINT NOT NULL", new Object[0])).hasStackTraceContaining("Cannot update column type from nullable to non nullable for v");
        this.sql("ALTER TABLE T SET ('alter-column-null-to-not-null.disabled' = 'false')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY v BIGINT NOT NULL", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 10L}), Row.of((Object[])new Object[]{2, 20L})});
    }

    @Test
    public void testAlterColumnTypeNestedArrayAndMap() {
        this.sql("CREATE TABLE T ( k INT, v ARRAY<ARRAY<ARRAY<INT>>>, PRIMARY KEY(k) NOT ENFORCED )", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, ARRAY[ARRAY[ARRAY[1, 2]]]), (2, ARRAY[ARRAY[ARRAY[3, 4]]])", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, new Integer[][][]{{{1, 2}}}}), Row.of((Object[])new Object[]{2, new Integer[][][]{{{3, 4}}}})});
        this.sql("ALTER TABLE T MODIFY v ARRAY<ARRAY<ARRAY<BIGINT>>>", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, new Long[][][]{{{1L, 2L}}}}), Row.of((Object[])new Object[]{2, new Long[][][]{{{3L, 4L}}}})});
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY v ARRAY<ARRAY<ARRAY<BIGINT NOT NULL>>>", new Object[0])).hasStackTraceContaining("Cannot update column type from nullable to non nullable for v.element.element.element");
        this.sql("DROP TABLE T", new Object[0]);
        this.sql("CREATE TABLE T ( k INT, v MAP<STRING, MAP<STRING, MAP<STRING, INT NOT NULL>>>, PRIMARY KEY(k) NOT ENFORCED )", new Object[0]);
        HashMap mp1 = new HashMap();
        HashMap l1Mp1 = new HashMap();
        HashMap<String, Integer> l2Mp1 = new HashMap<String, Integer>();
        l2Mp1.put("aaa", 1);
        l2Mp1.put("aab", 2);
        l1Mp1.put("aa", l2Mp1);
        mp1.put("a", l1Mp1);
        HashMap mp2 = new HashMap();
        HashMap l1Mp2 = new HashMap();
        HashMap<String, Integer> l2Mp2 = new HashMap<String, Integer>();
        l2Mp2.put("bbb", 3);
        l2Mp2.put("bbc", 4);
        l1Mp2.put("bb", l2Mp2);
        mp2.put("b", l1Mp2);
        this.sql("INSERT INTO T VALUES (1, MAP['a', MAP['aa', MAP['aaa', 1, 'aab', 2]]]), (2, MAP['b', MAP['bb', MAP['bbb', 3, 'bbc', 4]]])", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, mp1}), Row.of((Object[])new Object[]{2, mp2})});
        this.sql("ALTER TABLE T MODIFY v MAP<STRING, MAP<STRING, MAP<STRING, BIGINT>>>", new Object[0]);
        HashMap mp3 = new HashMap();
        HashMap l1Mp3 = new HashMap();
        HashMap<String, Long> l2Mp3 = new HashMap<String, Long>();
        l2Mp3.put("aaa", 1L);
        l2Mp3.put("aab", 2L);
        l1Mp3.put("aa", l2Mp3);
        mp3.put("a", l1Mp3);
        HashMap mp4 = new HashMap();
        HashMap l1Mp4 = new HashMap();
        HashMap<String, Long> l2Mp4 = new HashMap<String, Long>();
        l2Mp4.put("bbb", 3L);
        l2Mp4.put("bbc", 4L);
        l1Mp4.put("bb", l2Mp4);
        mp4.put("b", l1Mp4);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, mp3}), Row.of((Object[])new Object[]{2, mp4})});
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY v MAP<STRING, MAP<STRING, MAP<STRING, BIGINT NOT NULL>>>", new Object[0])).hasStackTraceContaining("Cannot update column type from nullable to non nullable for v.value.value.value");
        this.sql("DROP TABLE T", new Object[0]);
        this.sql("CREATE TABLE T ( k INT, a ARRAY<INT NOT NULL>, b MAP<STRING, INT NOT NULL>, PRIMARY KEY(k) NOT ENFORCED )", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, ARRAY[1, 2, 3, 4], MAP['a', 1, 'b', 2])", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, new Integer[]{1, 2, 3, 4}, new HashMap<String, Integer>(){
            {
                this.put("a", 1);
                this.put("b", 2);
            }
        }})});
        this.sql("ALTER TABLE T MODIFY a ARRAY<BIGINT>", new Object[0]);
        this.sql("INSERT INTO T VALUES (2, ARRAY[5, 6, 7, CAST(NULL AS BIGINT)], MAP['c', 3, 'd', 4])", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, new Long[]{1L, 2L, 3L, 4L}, new HashMap<String, Integer>(){
            {
                this.put("a", 1);
                this.put("b", 2);
            }
        }}), Row.of((Object[])new Object[]{2, new Long[]{5L, 6L, 7L, null}, new HashMap<String, Integer>(){
            {
                this.put("c", 3);
                this.put("d", 4);
            }
        }})});
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY a ARRAY<BIGINT NOT NULL>", new Object[0])).hasStackTraceContaining("Cannot update column type from nullable to non nullable for a.element");
        this.sql("ALTER TABLE T MODIFY b MAP<STRING, BIGINT>", new Object[0]);
        this.sql("INSERT INTO T VALUES (2, ARRAY[5, 6, 7, CAST(NULL AS BIGINT)], MAP['c', 3, 'd', CAST(NULL AS BIGINT)])", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, new Long[]{1L, 2L, 3L, 4L}, new HashMap<String, Long>(){
            {
                this.put("a", 1L);
                this.put("b", 2L);
            }
        }}), Row.of((Object[])new Object[]{2, new Long[]{5L, 6L, 7L, null}, new HashMap<String, Long>(){
            {
                this.put("c", 3L);
                this.put("d", null);
            }
        }})});
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY b MAP<STRING, BIGINT NOT NULL>", new Object[0])).hasStackTraceContaining("Cannot update column type from nullable to non nullable for b.value");
        this.sql("DROP TABLE T", new Object[0]);
        this.sql("CREATE TABLE T ( k INT, a MAP<STRING, ARRAY<INT NOT NULL>>, PRIMARY KEY(k) NOT ENFORCED )", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, MAP['a', ARRAY[1, 2, 3]])", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, new HashMap<String, Integer[]>(){
            {
                this.put("a", new Integer[]{1, 2, 3});
            }
        }})});
        this.sql("ALTER TABLE T MODIFY a MAP<STRING, ARRAY<BIGINT>>", new Object[0]);
        this.sql("INSERT INTO T VALUES(1, MAP['a', ARRAY[1, 2, 3], 'b', ARRAY[2, 3, CAST(NULL AS BIGINT)]])", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, new HashMap<String, Long[]>(){
            {
                this.put("a", new Long[]{1L, 2L, 3L});
                this.put("b", new Long[]{2L, 3L, null});
            }
        }})});
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY a MAP<STRING, ARRAY<BIGINT NOT NULL>>", new Object[0])).hasStackTraceContaining("Cannot update column type from nullable to non nullable for a.value.element");
        this.sql("DROP TABLE T", new Object[0]);
        this.sql("CREATE TABLE T ( k INT, a ROW(c1 DOUBLE, c2 ARRAY<BOOLEAN> NOT NULL) NOT NULL, PRIMARY KEY(k) NOT ENFORCED )", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, ROW(1.0, ARRAY[true, false]))", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, Row.of((Object[])new Object[]{1.0, new Boolean[]{true, false}})})});
        this.sql("ALTER TABLE T MODIFY a ROW(c1 DOUBLE, c2 ARRAY<BOOLEAN>) NOT NULL", new Object[0]);
        this.sql("INSERT INTO T VALUES (2, ROW(2.0, CAST(NULL AS ARRAY<BOOLEAN>)))", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, Row.of((Object[])new Object[]{1.0, new Boolean[]{true, false}})}), Row.of((Object[])new Object[]{2, Row.of((Object[])new Object[]{2.0, null})})});
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY a ROW(c1 DOUBLE, c2 ARRAY<BOOLEAN> NOT NULL) NOT NULL", new Object[0])).hasStackTraceContaining("Cannot update column type from nullable to non nullable for a.c2");
        this.sql("ALTER TABLE T MODIFY a ROW(c1 DOUBLE, c2 ARRAY<BOOLEAN>, c3 ARRAY<MAP<STRING, BOOLEAN NOT NULL>>) NOT NULL", new Object[0]);
        this.sql("ALTER TABLE T MODIFY a ROW(c1 DOUBLE, c2 ARRAY<BOOLEAN>, c3 ARRAY<MAP<STRING, BOOLEAN>>) NOT NULL", new Object[0]);
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY a ROW(c1 DOUBLE, c2 ARRAY<BOOLEAN>, c3 ARRAY<MAP<STRING, BOOLEAN NOT NULL>>) NOT NULL", new Object[0])).hasStackTraceContaining("Cannot update column type from nullable to non nullable for a.c3.element.value");
    }

    @ParameterizedTest
    @ValueSource(strings={"orc", "avro", "parquet"})
    public void testDisableExplicitTypeCasting(String formatType) {
        this.sql("CREATE TABLE T ( k INT, v INT, PRIMARY KEY (k) NOT ENFORCED ) WITH ( 'bucket' = '1', 'file.format' = '" + formatType + "' )", new Object[0]);
        this.sql("ALTER TABLE T SET ('disable-explicit-type-casting' = 'true')", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, 10), (2, 20)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 10}), Row.of((Object[])new Object[]{2, 20})});
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY v SMALLINT", new Object[0])).hasStackTraceContaining("Column type v[INT] cannot be converted to SMALLINT without loosing information");
        this.sql("ALTER TABLE T MODIFY v BIGINT", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 10L}), Row.of((Object[])new Object[]{2, 20L})});
        Assertions.assertThatCode(() -> this.sql("ALTER TABLE T MODIFY v INT", new Object[0])).hasStackTraceContaining("Column type v[BIGINT] cannot be converted to INT without loosing information");
        this.sql("ALTER TABLE T SET ('disable-explicit-type-casting' = 'false')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY v INT", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 10}), Row.of((Object[])new Object[]{2, 20})});
    }
}

