/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.nio.file.Path;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.ExpireTagsAction;
import org.apache.paimon.flink.util.ReadWriteTableTestUtil;
import org.apache.paimon.table.FileStoreTable;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ExpireTagsActionTest
extends ActionITCaseBase {
    @TempDir
    private Path tempExternalPath;

    @BeforeEach
    public void setUp() {
        ReadWriteTableTestUtil.init(this.warehouse);
    }

    @Test
    public void testExpireTags() throws Exception {
        ReadWriteTableTestUtil.bEnv.executeSql("CREATE TABLE T (id STRING, name STRING, PRIMARY KEY (id) NOT ENFORCED) WITH ('bucket'='1', 'write-only'='true')");
        this.expireTags();
    }

    @Test
    public void testExpireTagsWithExternalPath() throws Exception {
        String externalPath = "file://" + this.tempExternalPath;
        ReadWriteTableTestUtil.bEnv.executeSql("CREATE TABLE T (id STRING, name STRING, PRIMARY KEY (id) NOT ENFORCED) WITH ('data-file.external-paths'='" + externalPath + "','data-file.external-paths.strategy' = 'round-robin','write-only'='true')");
        this.expireTags();
    }

    public void expireTags() throws Exception {
        FileStoreTable table = this.getFileStoreTable("T");
        for (int i = 1; i <= 5; ++i) {
            ReadWriteTableTestUtil.bEnv.executeSql("INSERT INTO T VALUES ('" + i + "', '" + i + "')").await();
        }
        Assertions.assertThat((long)table.snapshotManager().snapshotCount()).isEqualTo(5L);
        ReadWriteTableTestUtil.bEnv.executeSql("CALL sys.create_tag('default.T', 'tag-1', 1)").await();
        ReadWriteTableTestUtil.bEnv.executeSql("CALL sys.create_tag('default.T', 'tag-2', 2, '1h')").await();
        ReadWriteTableTestUtil.bEnv.executeSql("CALL sys.create_tag('default.T', 'tag-3', 3, '1h')").await();
        Assertions.assertThat((int)table.tagManager().tags().size()).isEqualTo(3);
        this.createAction(ExpireTagsAction.class, "expire_tags", "--warehouse", this.warehouse, "--database", this.database, "--table", "T").run();
        Assertions.assertThat((int)table.tagManager().tags().size()).isEqualTo(3);
        ReadWriteTableTestUtil.bEnv.executeSql("CALL sys.create_tag('default.T', 'tag-4', 4, '1s')").await();
        ReadWriteTableTestUtil.bEnv.executeSql("CALL sys.create_tag('default.T', 'tag-5', 5, '1s')").await();
        Assertions.assertThat((int)table.tagManager().tags().size()).isEqualTo(5);
        Thread.sleep(2000L);
        this.createAction(ExpireTagsAction.class, "expire_tags", "--warehouse", this.warehouse, "--database", this.database, "--table", "T").run();
        Assertions.assertThat((int)table.tagManager().tags().size()).isEqualTo(3);
        Assertions.assertThat((boolean)table.tagManager().tagExists("tag-4")).isFalse();
        Assertions.assertThat((boolean)table.tagManager().tagExists("tag-5")).isFalse();
        LocalDateTime olderThanTime = table.tagManager().getOrThrow("tag-3").getTagCreateTime();
        Timestamp timestamp = new Timestamp(org.apache.paimon.data.Timestamp.fromLocalDateTime((LocalDateTime)olderThanTime).getMillisecond());
        this.createAction(ExpireTagsAction.class, "expire_tags", "--warehouse", this.warehouse, "--database", this.database, "--table", "T", "--older_than", timestamp.toString()).run();
        Assertions.assertThat((int)table.tagManager().tags().size()).isEqualTo(1);
        Assertions.assertThat((boolean)table.tagManager().tagExists("tag-3")).isTrue();
    }
}

