/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.time.Duration;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.ReplaceTagAction;
import org.apache.paimon.flink.util.ReadWriteTableTestUtil;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.TagManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ReplaceTagActionTest
extends ActionITCaseBase {
    @BeforeEach
    public void setUp() {
        ReadWriteTableTestUtil.init(this.warehouse);
    }

    @Test
    public void testReplaceTag() throws Exception {
        ReadWriteTableTestUtil.bEnv.executeSql("CREATE TABLE T (id INT, name STRING, PRIMARY KEY (id) NOT ENFORCED) WITH ('bucket'='1')");
        FileStoreTable table = this.getFileStoreTable("T");
        TagManager tagManager = table.tagManager();
        ReadWriteTableTestUtil.bEnv.executeSql("INSERT INTO T VALUES (1, 'a')").await();
        ReadWriteTableTestUtil.bEnv.executeSql("INSERT INTO T VALUES (2, 'b')").await();
        Assertions.assertThat((long)table.snapshotManager().snapshotCount()).isEqualTo(2L);
        Assertions.assertThatThrownBy(() -> ReadWriteTableTestUtil.bEnv.executeSql("CALL sys.replace_tag(`table` => 'default.T', tag => 'test_tag')")).hasMessageContaining("Tag 'test_tag' doesn't exist.");
        ReadWriteTableTestUtil.bEnv.executeSql("CALL sys.create_tag(`table` => 'default.T', tag => 'test_tag')");
        Assertions.assertThat((boolean)tagManager.tagExists("test_tag")).isEqualTo(true);
        Assertions.assertThat((long)tagManager.getOrThrow("test_tag").id()).isEqualTo(2L);
        Assertions.assertThat((Duration)tagManager.getOrThrow("test_tag").getTagTimeRetained()).isEqualTo(null);
        this.createAction(ReplaceTagAction.class, "replace_tag", "--warehouse", this.warehouse, "--database", this.database, "--table", "T", "--tag_name", "test_tag", "--time_retained", "1 d").run();
        Assertions.assertThat((long)tagManager.getOrThrow("test_tag").getTagTimeRetained().toHours()).isEqualTo(24L);
        this.createAction(ReplaceTagAction.class, "replace_tag", "--warehouse", this.warehouse, "--database", this.database, "--table", "T", "--tag_name", "test_tag", "--snapshot", "1", "--time_retained", "2 d").run();
        Assertions.assertThat((long)tagManager.getOrThrow("test_tag").id()).isEqualTo(1L);
        Assertions.assertThat((long)tagManager.getOrThrow("test_tag").getTagTimeRetained().toHours()).isEqualTo(48L);
    }
}

