/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.SortCompactAction;
import org.apache.paimon.operation.KeyValueFileStoreScan;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.table.sink.BatchTableWrite;
import org.apache.paimon.table.sink.BatchWriteBuilder;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.utils.Pair;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SortCompactActionForDynamicBucketITCase
extends ActionITCaseBase {
    private static final Random RANDOM = new Random();

    @Test
    public void testDynamicBucketSort() throws Exception {
        this.createTable();
        this.commit(this.writeData(100));
        PredicateBuilder predicateBuilder = new PredicateBuilder(this.getTable().rowType());
        Predicate predicate = predicateBuilder.between(1, (Object)100L, (Object)200L);
        List files = this.getTable().store().newScan().plan().files();
        List filesFilter = ((KeyValueFileStoreScan)this.getTable().store().newScan()).withValueFilter(predicate).plan().files();
        this.zorder(Arrays.asList("f2", "f1"));
        List filesZorder = this.getTable().store().newScan().plan().files();
        List filesFilterZorder = ((KeyValueFileStoreScan)this.getTable().store().newScan()).withValueFilter(predicate).plan().files();
        Assertions.assertThat((double)((double)filesFilterZorder.size() / (double)filesZorder.size())).isLessThan((double)filesFilter.size() / (double)files.size());
    }

    @Test
    public void testDynamicBucketSortWithOrderAndZorder() throws Exception {
        this.createTable();
        this.commit(this.writeData(100));
        PredicateBuilder predicateBuilder = new PredicateBuilder(this.getTable().rowType());
        Predicate predicate = predicateBuilder.between(1, (Object)100L, (Object)200L);
        this.order(Arrays.asList("f2", "f1"));
        List files = this.getTable().store().newScan().plan().files();
        List filesFilter = ((KeyValueFileStoreScan)this.getTable().store().newScan()).withValueFilter(predicate).plan().files();
        this.zorder(Arrays.asList("f2", "f1"));
        List filesZorder = this.getTable().store().newScan().plan().files();
        List filesFilterZorder = ((KeyValueFileStoreScan)this.getTable().store().newScan()).withValueFilter(predicate).plan().files();
        Assertions.assertThat((double)((double)filesFilterZorder.size() / (double)filesZorder.size())).isLessThan((double)filesFilter.size() / (double)files.size());
    }

    @Test
    public void testDynamicBucketSortWithOrderAndHilbert() throws Exception {
        this.createTable();
        this.commit(this.writeData(100));
        PredicateBuilder predicateBuilder = new PredicateBuilder(this.getTable().rowType());
        Predicate predicate = predicateBuilder.between(1, (Object)100L, (Object)200L);
        this.order(Arrays.asList("f2", "f1"));
        List files = this.getTable().store().newScan().plan().files();
        List filesFilter = ((KeyValueFileStoreScan)this.getTable().store().newScan()).withValueFilter(predicate).plan().files();
        this.hilbert(Arrays.asList("f2", "f1"));
        List filesHilbert = this.getTable().store().newScan().plan().files();
        List filesFilterHilbert = ((KeyValueFileStoreScan)this.getTable().store().newScan()).withValueFilter(predicate).plan().files();
        Assertions.assertThat((double)((double)filesFilterHilbert.size() / (double)filesHilbert.size())).isLessThan((double)filesFilter.size() / (double)files.size());
    }

    @Test
    public void testDynamicBucketSortWithStringType() throws Exception {
        this.createTable();
        this.commit(this.writeData(100));
        PredicateBuilder predicateBuilder = new PredicateBuilder(this.getTable().rowType());
        Predicate predicate = predicateBuilder.between(4, (Object)BinaryString.fromString((String)"000000000100"), (Object)BinaryString.fromString((String)"000000000200"));
        List files = this.getTable().store().newScan().plan().files();
        List filesFilter = ((KeyValueFileStoreScan)this.getTable().store().newScan()).withValueFilter(predicate).plan().files();
        this.zorder(Collections.singletonList("f4"));
        List filesZorder = this.getTable().store().newScan().plan().files();
        List filesFilterZorder = ((KeyValueFileStoreScan)this.getTable().store().newScan()).withValueFilter(predicate).plan().files();
        Assertions.assertThat((double)((double)filesFilterZorder.size() / (double)filesZorder.size())).isLessThan((double)filesFilter.size() / (double)files.size());
    }

    private void zorder(List<String> columns) throws Exception {
        this.createAction("zorder", columns).run();
    }

    private void hilbert(List<String> columns) throws Exception {
        this.createAction("hilbert", columns).run();
    }

    private void order(List<String> columns) throws Exception {
        this.createAction("order", columns).run();
    }

    private SortCompactAction createAction(String orderStrategy, List<String> columns) {
        return this.createAction(SortCompactAction.class, "compact", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--order_strategy", orderStrategy, "--order_by", String.join((CharSequence)",", columns));
    }

    private static Schema schema() {
        Schema.Builder schemaBuilder = Schema.newBuilder();
        schemaBuilder.column("f0", (DataType)DataTypes.BIGINT());
        schemaBuilder.column("f1", (DataType)DataTypes.BIGINT());
        schemaBuilder.column("f2", (DataType)DataTypes.BIGINT());
        schemaBuilder.column("f3", (DataType)DataTypes.BIGINT());
        schemaBuilder.column("f4", (DataType)DataTypes.STRING());
        schemaBuilder.option("bucket", "-1");
        schemaBuilder.option("scan.parallelism", "6");
        schemaBuilder.option("sink.parallelism", "3");
        schemaBuilder.option("dynamic-bucket.target-row-num", "100");
        schemaBuilder.option(CoreOptions.ZORDER_VAR_LENGTH_CONTRIBUTION.key(), "14");
        schemaBuilder.primaryKey(new String[]{"f0"});
        return schemaBuilder.build();
    }

    private List<CommitMessage> writeData(int size) throws Exception {
        List messages;
        FileStoreTable table = this.getTable();
        BatchWriteBuilder builder = table.newBatchWriteBuilder();
        try (BatchTableWrite batchTableWrite = builder.newWrite();){
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < 100; ++j) {
                    Pair<InternalRow, Integer> rowWithBucket = SortCompactActionForDynamicBucketITCase.data(i);
                    batchTableWrite.write((InternalRow)rowWithBucket.getKey(), ((Integer)rowWithBucket.getValue()).intValue());
                }
            }
            messages = batchTableWrite.prepareCommit();
        }
        return messages;
    }

    private void commit(List<CommitMessage> messages) throws Exception {
        BatchTableCommit commit = this.getTable().newBatchWriteBuilder().newCommit();
        commit.commit(messages);
        commit.close();
    }

    private void createTable() throws Exception {
        this.catalog.createDatabase(this.database, true);
        this.catalog.createTable(this.identifier(), SortCompactActionForDynamicBucketITCase.schema(), true);
    }

    private FileStoreTable getTable() throws Exception {
        return (FileStoreTable)this.catalog.getTable(this.identifier());
    }

    private Identifier identifier() {
        return Identifier.create((String)this.database, (String)this.tableName);
    }

    private static Pair<InternalRow, Integer> data(int bucket) {
        String in = String.valueOf(Math.abs(RANDOM.nextInt(10000)));
        int count = 4 - in.length();
        for (int i = 0; i < count; ++i) {
            in = "0" + in;
        }
        assert (in.length() == 4);
        GenericRow row = GenericRow.of((Object[])new Object[]{RANDOM.nextLong(), (long)RANDOM.nextInt(10000), (long)RANDOM.nextInt(10000), (long)RANDOM.nextInt(10000), BinaryString.fromString((String)("00000000" + in))});
        return Pair.of((Object)row, (Object)bucket);
    }
}

