/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import org.apache.flink.types.Row;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.CreateTagAction;
import org.apache.paimon.flink.action.DeleteTagAction;
import org.apache.paimon.flink.action.RenameTagAction;
import org.apache.paimon.flink.util.ReadWriteTableTestUtil;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.TagManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TagActionITCase
extends ActionITCaseBase {
    private static Stream<String> testData() {
        return Stream.of("action", "procedure_indexed", "procedure_named");
    }

    @ParameterizedTest(name="{0}")
    @ValueSource(strings={"action", "procedure_indexed", "procedure_named"})
    public void testCreateAndDeleteTag(String invoker) throws Exception {
        ReadWriteTableTestUtil.init(this.warehouse);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"k", "v"});
        FileStoreTable table = this.createFileStoreTable(rowType, Collections.emptyList(), Collections.singletonList("k"), Collections.emptyList(), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(1L, BinaryString.fromString((String)"Hi")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Hello")));
        this.writeData(this.rowData(3L, BinaryString.fromString((String)"Paimon")));
        TagManager tagManager = new TagManager(table.fileIO(), table.location());
        switch (invoker) {
            case "action": {
                this.createAction(CreateTagAction.class, "create_tag", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--tag_name", "tag2", "--snapshot", "2").run();
                break;
            }
            case "procedure_indexed": {
                this.executeSQL(String.format("CALL sys.create_tag('%s.%s', 'tag2', 2)", this.database, this.tableName));
                break;
            }
            case "procedure_named": {
                this.executeSQL(String.format("CALL sys.create_tag(`table` => '%s.%s', tag => 'tag2', snapshot_id => cast(2 as bigint))", this.database, this.tableName));
                break;
            }
            default: {
                throw new UnsupportedOperationException(invoker);
            }
        }
        Assertions.assertThat((boolean)tagManager.tagExists("tag2")).isTrue();
        ReadWriteTableTestUtil.testBatchRead("SELECT * FROM `" + this.tableName + "` /*+ OPTIONS('scan.tag-name'='tag2') */", Arrays.asList(Row.of((Object[])new Object[]{1L, "Hi"}), Row.of((Object[])new Object[]{2L, "Hello"})));
        switch (invoker) {
            case "action": {
                this.createAction(DeleteTagAction.class, "delete_tag", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--tag_name", "tag2").run();
                break;
            }
            case "procedure_indexed": {
                this.executeSQL(String.format("CALL sys.delete_tag('%s.%s', 'tag2')", this.database, this.tableName));
                break;
            }
            case "procedure_named": {
                this.executeSQL(String.format("CALL sys.delete_tag(`table` => '%s.%s', tag => 'tag2')", this.database, this.tableName));
                break;
            }
            default: {
                throw new UnsupportedOperationException(invoker);
            }
        }
        Assertions.assertThat((boolean)tagManager.tagExists("tag2")).isFalse();
        switch (invoker) {
            case "action": {
                this.createAction(CreateTagAction.class, "create_tag", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--tag_name", "tag1", "--snapshot", "1").run();
                break;
            }
            case "procedure_indexed": {
                this.executeSQL(String.format("CALL sys.create_tag('%s.%s', 'tag1', 1)", this.database, this.tableName));
                break;
            }
            case "procedure_named": {
                this.executeSQL(String.format("CALL sys.create_tag(`table` => '%s.%s', tag => 'tag1', snapshot_id => cast(1 as bigint))", this.database, this.tableName));
                break;
            }
            default: {
                throw new UnsupportedOperationException(invoker);
            }
        }
        switch (invoker) {
            case "action": {
                this.createAction(CreateTagAction.class, "create_tag", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--tag_name", "tag3", "--snapshot", "3").run();
                break;
            }
            case "procedure_indexed": {
                this.executeSQL(String.format("CALL sys.create_tag('%s.%s', 'tag3', 3)", this.database, this.tableName));
                break;
            }
            case "procedure_named": {
                this.executeSQL(String.format("CALL sys.create_tag(`table` => '%s.%s', tag => 'tag3', snapshot_id => cast(3 as bigint))", this.database, this.tableName));
                break;
            }
            default: {
                throw new UnsupportedOperationException(invoker);
            }
        }
        switch (invoker) {
            case "action": {
                this.createAction(DeleteTagAction.class, "delete_tag", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--tag_name", "tag1,tag3").run();
                break;
            }
            case "procedure_indexed": {
                this.executeSQL(String.format("CALL sys.delete_tag('%s.%s', 'tag1,tag3')", this.database, this.tableName));
                break;
            }
            case "procedure_named": {
                this.executeSQL(String.format("CALL sys.delete_tag(`table` => '%s.%s', tag => 'tag1,tag3')", this.database, this.tableName));
                break;
            }
            default: {
                throw new UnsupportedOperationException(invoker);
            }
        }
        Assertions.assertThat((boolean)tagManager.tagExists("tag1")).isFalse();
        Assertions.assertThat((boolean)tagManager.tagExists("tag3")).isFalse();
    }

    @ParameterizedTest(name="{0}")
    @ValueSource(strings={"action", "procedure_indexed", "procedure_named"})
    public void testRenameTag(String invoker) throws Exception {
        ReadWriteTableTestUtil.init(this.warehouse);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"k", "v"});
        FileStoreTable table = this.createFileStoreTable(rowType, Collections.emptyList(), Collections.singletonList("k"), Collections.emptyList(), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(1L, BinaryString.fromString((String)"Hi")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Hello")));
        this.writeData(this.rowData(3L, BinaryString.fromString((String)"Paimon")));
        TagManager tagManager = new TagManager(table.fileIO(), table.location());
        switch (invoker) {
            case "action": {
                this.createAction(CreateTagAction.class, "create_tag", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--tag_name", "tag2").run();
                break;
            }
            case "procedure_indexed": {
                this.executeSQL(String.format("CALL sys.create_tag('%s.%s', 'tag2',  2)", this.database, this.tableName));
                break;
            }
            case "procedure_named": {
                this.executeSQL(String.format("CALL sys.create_tag(`table` => '%s.%s', tag => 'tag2', snapshot_id => cast(2 as bigint))", this.database, this.tableName));
                break;
            }
            default: {
                throw new UnsupportedOperationException(invoker);
            }
        }
        Assertions.assertThat((boolean)tagManager.tagExists("tag2")).isTrue();
        switch (invoker) {
            case "action": {
                this.createAction(RenameTagAction.class, "rename_tag", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--tag_name", "tag2", "--target_tag_name", "tag3").run();
                break;
            }
            case "procedure_indexed": {
                this.executeSQL(String.format("CALL sys.rename_tag('%s.%s', 'tag2', 'tag3')", this.database, this.tableName));
                break;
            }
            case "procedure_named": {
                this.executeSQL(String.format("CALL sys.rename_tag(`table` => '%s.%s', tagName => 'tag2', targetTagName => 'tag3')", this.database, this.tableName));
                break;
            }
            default: {
                throw new UnsupportedOperationException(invoker);
            }
        }
        Assertions.assertThat((boolean)tagManager.tagExists("tag2")).isFalse();
        Assertions.assertThat((boolean)tagManager.tagExists("tag3")).isTrue();
    }

    @ParameterizedTest(name="{0}")
    @ValueSource(strings={"action", "procedure_indexed", "procedure_named"})
    public void testCreateLatestTag(String invoker) throws Exception {
        ReadWriteTableTestUtil.init(this.warehouse);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"k", "v"});
        FileStoreTable table = this.createFileStoreTable(rowType, Collections.emptyList(), Collections.singletonList("k"), Collections.emptyList(), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(1L, BinaryString.fromString((String)"Hi")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Hello")));
        this.writeData(this.rowData(3L, BinaryString.fromString((String)"Paimon")));
        TagManager tagManager = new TagManager(table.fileIO(), table.location());
        switch (invoker) {
            case "action": {
                this.createAction(CreateTagAction.class, "create_tag", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--tag_name", "tag2").run();
                break;
            }
            case "procedure_indexed": {
                this.executeSQL(String.format("CALL sys.create_tag('%s.%s', 'tag2',  2)", this.database, this.tableName));
                break;
            }
            case "procedure_named": {
                this.executeSQL(String.format("CALL sys.create_tag(`table` => '%s.%s', tag => 'tag2', snapshot_id => cast(2 as bigint))", this.database, this.tableName));
                break;
            }
            default: {
                throw new UnsupportedOperationException(invoker);
            }
        }
        Assertions.assertThat((boolean)tagManager.tagExists("tag2")).isTrue();
    }
}

