/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.List;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.RESTCatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class AlterViewDialectITCase
extends RESTCatalogITCaseBase {
    @Test
    public void testAlterViewDialect() {
        this.sql(String.format("INSERT INTO %s.%s VALUES ('1', 11), ('2', 22)", "mydb", "t1"), new Object[0]);
        String viewName = "view_test";
        String query = String.format("SELECT * FROM `%s`.`%s` WHERE `b` > 1", "mydb", "t1");
        this.sql(String.format("CREATE VIEW %s.%s AS %s", "mydb", viewName, query), new Object[0]);
        String newQuery = String.format("SELECT * FROM `%s`.`%s` WHERE `b` > 2", "mydb", "t1");
        List<Row> result = this.sql(String.format("CALL sys.alter_view_dialect('%s.%s', 'update', '%s', '%s')", "mydb", viewName, "flink", newQuery), new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"Success"});
        result = this.sql(String.format("SHOW CREATE VIEW %s.%s", "mydb", viewName), new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{newQuery});
        result = this.sql(String.format("CALL sys.alter_view_dialect('%s.%s', 'drop', '%s')", "mydb", viewName, "flink"), new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"Success"});
        result = this.sql(String.format("CALL sys.alter_view_dialect('%s.%s', 'add', '%s', '%s')", "mydb", viewName, "flink", query), new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"Success"});
        result = this.sql(String.format("SHOW CREATE VIEW %s.%s", "mydb", viewName), new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{query});
        this.sql(String.format("CALL sys.alter_view_dialect(`view` => '%s.%s', `action` => 'update', `query` => '%s')", "mydb", viewName, newQuery), new Object[0]);
        result = this.sql(String.format("SHOW CREATE VIEW %s.%s", "mydb", viewName), new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{newQuery});
        this.sql(String.format("CALL sys.alter_view_dialect(`view` => '%s.%s', `action` => 'drop')", "mydb", viewName), new Object[0]);
        result = this.sql(String.format("SHOW CREATE VIEW %s.%s", "mydb", viewName), new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{"`b` > 1"});
        this.sql(String.format("CALL sys.alter_view_dialect(`view` => '%s.%s', `action` => 'add', `query` => '%s')", "mydb", viewName, query), new Object[0]);
        result = this.sql(String.format("SHOW CREATE VIEW %s.%s", "mydb", viewName), new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{query});
    }
}

