/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReplaceTagProcedureITCase
extends CatalogITCaseBase {
    @Test
    public void testExpireTagsByTagCreateTimeAndTagTimeRetained() throws Exception {
        this.sql("CREATE TABLE T (id INT, name STRING, PRIMARY KEY (id) NOT ENFORCED) WITH ('bucket'='1')", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, 'a')", new Object[0]);
        this.sql("INSERT INTO T VALUES (2, 'b')", new Object[0]);
        Assertions.assertThat((long)this.paimonTable("T").snapshotManager().snapshotCount()).isEqualTo(2L);
        Assertions.assertThatThrownBy(() -> this.sql("CALL sys.replace_tag(`table` => 'default.T', tag => 'test_tag')", new Object[0])).hasMessageContaining("Tag 'test_tag' doesn't exist.");
        this.sql("CALL sys.create_tag(`table` => 'default.T', tag => 'test_tag')", new Object[0]);
        Assertions.assertThat(this.sql("select tag_name,snapshot_id,time_retained from `T$tags`", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{"test_tag", 2L, null})});
        this.sql("CALL sys.replace_tag(`table` => 'default.T', tag => 'test_tag', time_retained => '1 d')", new Object[0]);
        Assertions.assertThat(this.sql("select tag_name,snapshot_id,time_retained from `T$tags`", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{"test_tag", 2L, "PT24H"})});
        this.sql("CALL sys.replace_tag(`table` => 'default.T', tag => 'test_tag', snapshot => 1, time_retained => '2 d')", new Object[0]);
        Assertions.assertThat(this.sql("select tag_name,snapshot_id,time_retained from `T$tags`", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{"test_tag", 2L, "PT48H"})});
    }
}

