/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.fileindex.FileIndexFormat;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class RewriteFileIndexProcedureITCase
extends CatalogITCaseBase {
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testFileIndexProcedureSchemaEvolution(boolean isNamedArgument) throws Exception {
        this.sql("CREATE TABLE T ( k INT, v STRING, hh INT, dt STRING) PARTITIONED BY (dt, hh) WITH ( 'write-only' = 'true', 'file.format' = 'avro', 'bucket' = '-1')", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, '10', 15, '20221208'), (4, '100', 16, '20221208'), (5, '1000', 15, '20221209')", new Object[0]);
        this.sql("ALTER TABLE T RENAME `k` TO order_id", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, '10', 15, '20221208'), (4, '100', 16, '20221208'), (5, '1000', 15, '20221209')", new Object[0]);
        FileStoreTable table = this.paimonTable("T");
        Predicate predicateK = new PredicateBuilder(table.rowType()).equal(0, (Object)2);
        Predicate predicateV = new PredicateBuilder(table.rowType()).equal(1, (Object)BinaryString.fromString((String)"101"));
        RecordReader reader = table.newRead().withFilter(PredicateBuilder.and((Predicate[])new Predicate[]{predicateK, predicateV})).createReader(table.newScan().plan());
        AtomicInteger count = new AtomicInteger(0);
        reader.forEachRemaining(r -> count.incrementAndGet());
        Assertions.assertThat((int)count.get()).isEqualTo(6);
        this.tEnv.getConfig().set(TableConfigOptions.TABLE_DML_SYNC, (Object)true);
        this.sql("ALTER TABLE T SET ('file-index.bloom-filter.columns'='order_id,v')", new Object[0]);
        if (isNamedArgument) {
            this.sql("CALL sys.rewrite_file_index(`table` => 'default.T')", new Object[0]);
        } else {
            this.sql("CALL sys.rewrite_file_index('default.T')", new Object[0]);
        }
        reader = table.newRead().withFilter(PredicateBuilder.and((Predicate[])new Predicate[]{predicateK, predicateV})).createReader(table.newScan().plan());
        count.set(0);
        reader.forEachRemaining(r -> count.incrementAndGet());
        Assertions.assertThat((int)count.get()).isEqualTo(0);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testPartitionFilter(boolean isNamedArgument) throws Exception {
        this.sql("CREATE TABLE T ( k INT, v STRING, hh INT, dt STRING) PARTITIONED BY (dt, hh) WITH ( 'write-only' = 'true', 'file.format' = 'avro', 'bucket' = '-1')", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, '10', 15, '20221208'), (4, '100', 16, '20221208'), (5, '1000', 15, '20221209')", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, '10', 15, '20221208'), (4, '100', 16, '20221208'), (5, '1000', 15, '20221209')", new Object[0]);
        FileStoreTable table = this.paimonTable("T");
        Predicate predicateK = new PredicateBuilder(table.rowType()).equal(0, (Object)2);
        Predicate predicateV = new PredicateBuilder(table.rowType()).equal(1, (Object)BinaryString.fromString((String)"101"));
        RecordReader reader = table.newRead().withFilter(PredicateBuilder.and((Predicate[])new Predicate[]{predicateK, predicateV})).createReader(table.newScan().plan());
        AtomicInteger count = new AtomicInteger(0);
        reader.forEachRemaining(r -> count.incrementAndGet());
        Assertions.assertThat((int)count.get()).isEqualTo(6);
        this.tEnv.getConfig().set(TableConfigOptions.TABLE_DML_SYNC, (Object)true);
        this.sql("ALTER TABLE T SET ('file-index.bloom-filter.columns'='order_id,v')", new Object[0]);
        if (isNamedArgument) {
            this.sql("CALL sys.rewrite_file_index(`table` => 'default.T', partitions => 'dt=20221208')", new Object[0]);
        } else {
            this.sql("CALL sys.rewrite_file_index('default.T', 'dt=20221208')", new Object[0]);
        }
        reader = table.newRead().withFilter(PredicateBuilder.and((Predicate[])new Predicate[]{predicateK, predicateV})).createReader(table.newScan().plan());
        count.set(0);
        reader.forEachRemaining(r -> count.incrementAndGet());
        Assertions.assertThat((int)count.get()).isEqualTo(2);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testFileIndexProcedureDropIndex(boolean isNamedArgument) throws Exception {
        List extraFiles;
        this.sql("CREATE TABLE T ( k INT, v STRING, hh INT, dt STRING) PARTITIONED BY (dt, hh) WITH ( 'write-only' = 'true', 'file-index.bloom-filter.columns' = 'k,v', 'bucket' = '-1')", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, '100', 15, '20221208'), (1, '100', 16, '20221208'), (1, '100', 15, '20221209')", new Object[0]);
        this.tEnv.getConfig().set(TableConfigOptions.TABLE_DML_SYNC, (Object)true);
        this.sql("ALTER TABLE T SET ('file-index.bloom-filter.columns'='k')", new Object[0]);
        if (isNamedArgument) {
            this.sql("CALL sys.rewrite_file_index(`table` => 'default.T')", new Object[0]);
        } else {
            this.sql("CALL sys.rewrite_file_index('default.T')", new Object[0]);
        }
        FileStoreTable table = this.paimonTable("T");
        List list = table.store().newScan().plan().files();
        for (ManifestEntry entry : list) {
            extraFiles = entry.file().extraFiles().stream().filter(s -> s.endsWith(".index")).collect(Collectors.toList());
            Assertions.assertThat((int)extraFiles.size()).isEqualTo(1);
            String file = (String)extraFiles.get(0);
            Path indexFilePath = table.store().pathFactory().createDataFilePathFactory(entry.partition(), entry.bucket()).toAlignedPath(file, entry.file());
            FileIndexFormat.Reader reader = FileIndexFormat.createReader((SeekableInputStream)table.fileIO().newInputStream(indexFilePath), (RowType)table.rowType());
            Throwable throwable = null;
            try {
                Set readerSetK = reader.readColumnIndex("v");
                Assertions.assertThat((int)readerSetK.size()).isEqualTo(0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
        this.sql("ALTER TABLE T RESET ('file-index.bloom-filter.columns')", new Object[0]);
        if (isNamedArgument) {
            this.sql("CALL sys.rewrite_file_index('default.T')", new Object[0]);
        } else {
            this.sql("CALL sys.rewrite_file_index(`table` => 'default.T')", new Object[0]);
        }
        table = this.paimonTable("T");
        list = table.store().newScan().plan().files();
        for (ManifestEntry entry : list) {
            extraFiles = entry.file().extraFiles().stream().filter(s -> s.endsWith(".index")).collect(Collectors.toList());
            Assertions.assertThat((int)extraFiles.size()).isEqualTo(0);
        }
    }
}

