/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.SnapshotManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class RollbackProcedureITCase
extends CatalogITCaseBase {
    @Test
    public void testRollbackTo() throws Exception {
        this.sql("CREATE TABLE T (id STRING, name STRING, PRIMARY KEY (id) NOT ENFORCED) WITH ('bucket'='1', 'write-only'='true')", new Object[0]);
        FileStoreTable table = this.paimonTable("T");
        SnapshotManager snapshotManager = table.snapshotManager();
        for (int i = 1; i <= 5; ++i) {
            this.sql("INSERT INTO T VALUES ('" + i + "', '" + i + "')", new Object[0]);
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)5L, (Long)snapshotManager.latestSnapshotId());
        this.sql("CALL sys.create_tag(`table` => 'default.T', tag => 'tag-2', snapshot_id => 2)", new Object[0]);
        long latestSnapshotId = snapshotManager.latestSnapshot().id();
        Assertions.assertThat(this.sql("CALL sys.rollback_to(`table` => 'default.T', snapshot_id => 4)", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{latestSnapshotId, 4L})});
        latestSnapshotId = snapshotManager.latestSnapshot().id();
        Assertions.assertThat(this.sql("CALL sys.rollback_to(`table` => 'default.T', tag => 'tag-2')", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{latestSnapshotId, 2L})});
    }

    @Test
    public void testRollbackToTimestamp() throws Exception {
        this.sql("CREATE TABLE T (id STRING, name STRING, PRIMARY KEY (id) NOT ENFORCED) WITH ('bucket'='1', 'write-only'='true')", new Object[0]);
        FileStoreTable table = this.paimonTable("T");
        SnapshotManager snapshotManager = table.snapshotManager();
        this.sql("INSERT INTO T VALUES ('1', 'a')", new Object[0]);
        this.sql("INSERT INTO T VALUES ('1', 'b')", new Object[0]);
        long timestamp = System.currentTimeMillis();
        this.sql("INSERT INTO T VALUES ('3', 'c')", new Object[0]);
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (Long)snapshotManager.latestSnapshotId());
        long latestSnapshotId = snapshotManager.latestSnapshot().id();
        Assertions.assertThat(this.sql(String.format("CALL sys.rollback_to_timestamp(`table` => 'default.T', `timestamp` => %s)", timestamp), new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{latestSnapshotId, 2L})});
    }
}

