/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure.privilege;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.paimon.flink.FlinkCatalog;
import org.apache.paimon.flink.util.AbstractTestBase;
import org.apache.paimon.privilege.FileBasedPrivilegeManager;
import org.apache.paimon.privilege.NoPrivilegeException;
import org.apache.paimon.privilege.PrivilegedCatalog;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class PrivilegeProcedureITCase
extends AbstractTestBase {
    private String path;

    @BeforeEach
    public void beforeEach() {
        this.path = this.getTempDirPath();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testUserPrivileges(boolean isNamedArgument) throws Exception {
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql(String.format("CREATE CATALOG mycat WITH (\n  'type' = 'paimon',\n  'warehouse' = '%s'\n)", this.path));
        tEnv.executeSql("USE CATALOG mycat");
        tEnv.executeSql("CREATE DATABASE mydb");
        tEnv.executeSql("CREATE DATABASE mydb2");
        tEnv.executeSql("CREATE TABLE mydb.T1 (\n  k INT,\n  v INT,\n  PRIMARY KEY (k) NOT ENFORCED\n)");
        tEnv.executeSql("INSERT INTO mydb.T1 VALUES (1, 10), (2, 20), (3, 30)").await();
        if (isNamedArgument) {
            tEnv.executeSql("CALL sys.init_file_based_privilege(root_password => 'root-passwd')");
        } else {
            tEnv.executeSql("CALL sys.init_file_based_privilege('root-passwd')");
        }
        tEnv.executeSql(String.format("CREATE CATALOG anonymouscat WITH (\n  'type' = 'paimon',\n  'warehouse' = '%s'\n)", this.path));
        Catalog catalog = (Catalog)tEnv.getCatalog("anonymouscat").get();
        Assertions.assertThat((Object)catalog).isInstanceOf(FlinkCatalog.class);
        org.apache.paimon.catalog.Catalog paimonCatalog = ((FlinkCatalog)catalog).catalog();
        Assertions.assertThat((Object)paimonCatalog).isInstanceOf(PrivilegedCatalog.class);
        PrivilegedCatalog privilegedCatalog = (PrivilegedCatalog)paimonCatalog;
        Assertions.assertThat((Object)privilegedCatalog.privilegeManager()).isInstanceOf(FileBasedPrivilegeManager.class);
        Assertions.assertThat((boolean)privilegedCatalog.privilegeManager().privilegeEnabled()).isTrue();
        tEnv.executeSql("USE CATALOG anonymouscat");
        this.assertNoPrivilege(() -> tEnv.executeSql("INSERT INTO mydb.T1 VALUES (1, 11), (2, 21)").await());
        this.assertNoPrivilege(() -> this.collect(tEnv, "SELECT * FROM mydb.T1 ORDER BY k"));
        this.assertNoPrivilege(() -> tEnv.executeSql("CREATE TABLE mydb.S1 ( a INT, b INT )"));
        this.assertNoPrivilege(() -> tEnv.executeSql("DROP TABLE mydb.T1"));
        this.assertNoPrivilege(() -> tEnv.executeSql("ALTER TABLE mydb.T1 RENAME TO mydb.T2"));
        this.assertNoPrivilege(() -> tEnv.executeSql("CREATE DATABASE anotherdb"));
        this.assertNoPrivilege(() -> tEnv.executeSql("DROP DATABASE mydb CASCADE"));
        if (isNamedArgument) {
            this.assertNoPrivilege(() -> tEnv.executeSql("CALL sys.create_privileged_user(username => 'test2', password => 'test2-passwd')"));
        } else {
            this.assertNoPrivilege(() -> tEnv.executeSql("CALL sys.create_privileged_user('test2', 'test2-passwd')"));
        }
        tEnv.executeSql(String.format("CREATE CATALOG rootcat WITH (\n  'type' = 'paimon',\n  'warehouse' = '%s',\n  'user' = 'root',\n  'password' = 'root-passwd'\n)", this.path));
        tEnv.executeSql("USE CATALOG rootcat");
        tEnv.executeSql("CREATE TABLE mydb2.T2 (\n  k INT,\n  v INT,\n  PRIMARY KEY (k) NOT ENFORCED\n)");
        tEnv.executeSql("INSERT INTO mydb2.T2 VALUES (100, 1000), (200, 2000), (300, 3000)").await();
        if (isNamedArgument) {
            tEnv.executeSql("CALL sys.create_privileged_user(username => 'test', password => 'test-passwd')");
            tEnv.executeSql("CALL sys.grant_privilege_to_user(username => 'test', privilege => 'CREATE_TABLE', database => 'mydb')");
            tEnv.executeSql("CALL sys.grant_privilege_to_user(username => 'test', privilege => 'SELECT', database => 'mydb')");
            tEnv.executeSql("CALL sys.grant_privilege_to_user(username => 'test', privilege => 'INSERT', database => 'mydb')");
        } else {
            tEnv.executeSql("CALL sys.create_privileged_user('test', 'test-passwd')");
            tEnv.executeSql("CALL sys.grant_privilege_to_user('test', 'CREATE_TABLE', 'mydb')");
            tEnv.executeSql("CALL sys.grant_privilege_to_user('test', 'SELECT', 'mydb')");
            tEnv.executeSql("CALL sys.grant_privilege_to_user('test', 'INSERT', 'mydb')");
        }
        tEnv.executeSql(String.format("CREATE CATALOG testcat WITH (\n  'type' = 'paimon',\n  'warehouse' = '%s',\n  'user' = 'test',\n  'password' = 'test-passwd'\n)", this.path));
        tEnv.executeSql("USE CATALOG testcat");
        tEnv.executeSql("INSERT INTO mydb.T1 VALUES (1, 12), (2, 22)").await();
        Assertions.assertThat(this.collect(tEnv, "SELECT * FROM mydb.T1 ORDER BY k")).isEqualTo(Arrays.asList(Row.of((Object[])new Object[]{1, 12}), Row.of((Object[])new Object[]{2, 22}), Row.of((Object[])new Object[]{3, 30})));
        tEnv.executeSql("CREATE TABLE mydb.S1 ( a INT, b INT )");
        tEnv.executeSql("INSERT INTO mydb.S1 VALUES (1, 100), (2, 200), (3, 300)").await();
        Assertions.assertThat(this.collect(tEnv, "SELECT * FROM mydb.S1 ORDER BY a")).isEqualTo(Arrays.asList(Row.of((Object[])new Object[]{1, 100}), Row.of((Object[])new Object[]{2, 200}), Row.of((Object[])new Object[]{3, 300})));
        this.assertNoPrivilege(() -> tEnv.executeSql("DROP TABLE mydb.T1"));
        this.assertNoPrivilege(() -> tEnv.executeSql("ALTER TABLE mydb.T1 RENAME TO mydb.T2"));
        this.assertNoPrivilege(() -> tEnv.executeSql("DROP TABLE mydb.S1"));
        this.assertNoPrivilege(() -> tEnv.executeSql("ALTER TABLE mydb.S1 RENAME TO mydb.S2"));
        this.assertNoPrivilege(() -> tEnv.executeSql("CREATE DATABASE anotherdb"));
        this.assertNoPrivilege(() -> tEnv.executeSql("DROP DATABASE mydb CASCADE"));
        if (isNamedArgument) {
            this.assertNoPrivilege(() -> tEnv.executeSql("CALL sys.create_privileged_user(username => 'test2', password => 'test2-passwd')"));
            tEnv.executeSql("USE CATALOG rootcat");
            tEnv.executeSql("CALL sys.create_privileged_user(username => 'test2', password => 'test2-passwd')");
            tEnv.executeSql("CALL sys.grant_privilege_to_user(username => 'test2', privilege => 'SELECT', database => 'mydb2')");
            tEnv.executeSql("CALL sys.grant_privilege_to_user(username => 'test2', privilege => 'INSERT', database => 'mydb', `table` => 'T1')");
            tEnv.executeSql("CALL sys.grant_privilege_to_user(username => 'test2', privilege => 'SELECT', database => 'mydb', `table` => 'S1')");
            tEnv.executeSql("CALL sys.grant_privilege_to_user(username => 'test2', privilege => 'CREATE_DATABASE')");
        } else {
            this.assertNoPrivilege(() -> tEnv.executeSql("CALL sys.create_privileged_user('test2', 'test2-passwd')"));
            tEnv.executeSql("USE CATALOG rootcat");
            tEnv.executeSql("CALL sys.create_privileged_user('test2', 'test2-passwd')");
            tEnv.executeSql("CALL sys.grant_privilege_to_user('test2', 'SELECT', 'mydb2')");
            tEnv.executeSql("CALL sys.grant_privilege_to_user('test2', 'INSERT', 'mydb', 'T1')");
            tEnv.executeSql("CALL sys.grant_privilege_to_user('test2', 'SELECT', 'mydb', 'S1')");
            tEnv.executeSql("CALL sys.grant_privilege_to_user('test2', 'CREATE_DATABASE')");
        }
        tEnv.executeSql(String.format("CREATE CATALOG test2cat WITH (\n  'type' = 'paimon',\n  'warehouse' = '%s',\n  'user' = 'test2',\n  'password' = 'test2-passwd'\n)", this.path));
        tEnv.executeSql("USE CATALOG test2cat");
        tEnv.executeSql("INSERT INTO mydb.T1 VALUES (1, 13), (2, 23)").await();
        this.assertNoPrivilege(() -> this.collect(tEnv, "SELECT * FROM mydb.T1 ORDER BY k"));
        this.assertNoPrivilege(() -> tEnv.executeSql("CREATE TABLE mydb.S2 ( a INT, b INT )"));
        this.assertNoPrivilege(() -> tEnv.executeSql("INSERT INTO mydb.S1 VALUES (1, 100), (2, 200), (3, 300)").await());
        Assertions.assertThat(this.collect(tEnv, "SELECT * FROM mydb.S1 ORDER BY a")).isEqualTo(Arrays.asList(Row.of((Object[])new Object[]{1, 100}), Row.of((Object[])new Object[]{2, 200}), Row.of((Object[])new Object[]{3, 300})));
        this.assertNoPrivilege(() -> tEnv.executeSql("INSERT INTO mydb2.T2 VALUES (100, 1001), (200, 2001), (300, 3001)").await());
        Assertions.assertThat(this.collect(tEnv, "SELECT * FROM mydb2.T2 ORDER BY k")).isEqualTo(Arrays.asList(Row.of((Object[])new Object[]{100, 1000}), Row.of((Object[])new Object[]{200, 2000}), Row.of((Object[])new Object[]{300, 3000})));
        tEnv.executeSql("CREATE DATABASE anotherdb");
        this.assertNoPrivilege(() -> tEnv.executeSql("DROP TABLE mydb.T1"));
        this.assertNoPrivilege(() -> tEnv.executeSql("ALTER TABLE mydb.T1 RENAME TO mydb.T2"));
        this.assertNoPrivilege(() -> tEnv.executeSql("DROP TABLE mydb.S1"));
        this.assertNoPrivilege(() -> tEnv.executeSql("ALTER TABLE mydb.S1 RENAME TO mydb.S2"));
        this.assertNoPrivilege(() -> tEnv.executeSql("DROP DATABASE mydb CASCADE"));
        if (isNamedArgument) {
            this.assertNoPrivilege(() -> tEnv.executeSql("CALL sys.create_privileged_user(username => 'test3', password => 'test3-passwd')"));
            tEnv.executeSql("USE CATALOG rootcat");
            Assertions.assertThat(this.collect(tEnv, "SELECT * FROM mydb.T1 ORDER BY k")).isEqualTo(Arrays.asList(Row.of((Object[])new Object[]{1, 13}), Row.of((Object[])new Object[]{2, 23}), Row.of((Object[])new Object[]{3, 30})));
            tEnv.executeSql("CALL sys.revoke_privilege_from_user(username => 'test2', privilege => 'SELECT')");
            tEnv.executeSql("CALL sys.drop_privileged_user(username => 'test')");
        } else {
            this.assertNoPrivilege(() -> tEnv.executeSql("CALL sys.create_privileged_user('test3', 'test3-passwd')"));
            tEnv.executeSql("USE CATALOG rootcat");
            Assertions.assertThat(this.collect(tEnv, "SELECT * FROM mydb.T1 ORDER BY k")).isEqualTo(Arrays.asList(Row.of((Object[])new Object[]{1, 13}), Row.of((Object[])new Object[]{2, 23}), Row.of((Object[])new Object[]{3, 30})));
            tEnv.executeSql("CALL sys.revoke_privilege_from_user('test2', 'SELECT')");
            tEnv.executeSql("CALL sys.drop_privileged_user('test')");
        }
        tEnv.executeSql("USE CATALOG testcat");
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, () -> this.collect(tEnv, "SELECT * FROM mydb.T1 ORDER BY k"));
        Assertions.assertThat((Throwable)e).hasRootCauseMessage("User test not found, or password incorrect.");
        tEnv.executeSql("USE CATALOG test2cat");
        this.assertNoPrivilege(() -> this.collect(tEnv, "SELECT * FROM mydb.S1 ORDER BY a"));
        this.assertNoPrivilege(() -> this.collect(tEnv, "SELECT * FROM mydb2.T2 ORDER BY k"));
        tEnv.executeSql("INSERT INTO mydb.T1 VALUES (1, 14), (2, 24)").await();
        tEnv.executeSql("USE CATALOG rootcat");
        Assertions.assertThat(this.collect(tEnv, "SELECT * FROM mydb.T1 ORDER BY k")).isEqualTo(Arrays.asList(Row.of((Object[])new Object[]{1, 14}), Row.of((Object[])new Object[]{2, 24}), Row.of((Object[])new Object[]{3, 30})));
        tEnv.executeSql("DROP DATABASE mydb CASCADE");
        tEnv.executeSql("DROP DATABASE mydb2 CASCADE");
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDropUser(boolean isNamedArgument) throws Exception {
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        this.initializeSingleUserTest(tEnv, isNamedArgument);
        tEnv.executeSql("USE CATALOG rootcat");
        if (isNamedArgument) {
            tEnv.executeSql("CALL sys.drop_privileged_user(username => 'test')");
            tEnv.executeSql("CALL sys.create_privileged_user(username => 'test', password => 'test-passwd')");
        } else {
            tEnv.executeSql("CALL sys.drop_privileged_user('test')");
            tEnv.executeSql("CALL sys.create_privileged_user('test', 'test-passwd')");
        }
        tEnv.executeSql("USE CATALOG testcat");
        this.assertNoPrivilege(() -> this.collect(tEnv, "SELECT * FROM mydb.T1 ORDER BY k"));
        this.assertNoPrivilege(() -> tEnv.executeSql("INSERT INTO mydb.T1 VALUES (1, 12), (2, 22)").await());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testDropObject(boolean isNamedArgument) throws Exception {
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        this.initializeSingleUserTest(tEnv, isNamedArgument);
        tEnv.executeSql("USE CATALOG rootcat");
        tEnv.executeSql("DROP TABLE mydb.T1");
        tEnv.executeSql("CREATE TABLE mydb.T1 (\n  k INT,\n  v INT,\n  PRIMARY KEY (k) NOT ENFORCED\n)");
        tEnv.executeSql("USE CATALOG testcat");
        this.assertNoPrivilege(() -> this.collect(tEnv, "SELECT * FROM mydb.T1 ORDER BY k"));
        this.assertNoPrivilege(() -> tEnv.executeSql("INSERT INTO mydb.T1 VALUES (1, 12), (2, 22)").await());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testRenameObject(boolean isNamedArgument) throws Exception {
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        this.initializeSingleUserTest(tEnv, isNamedArgument);
        tEnv.executeSql("USE CATALOG rootcat");
        tEnv.executeSql("ALTER TABLE mydb.T1 RENAME TO mydb.T2");
        tEnv.executeSql("USE CATALOG testcat");
        Assertions.assertThat(this.collect(tEnv, "SELECT * FROM mydb.T2 ORDER BY k")).isEqualTo(Arrays.asList(Row.of((Object[])new Object[]{1, 11}), Row.of((Object[])new Object[]{2, 21}), Row.of((Object[])new Object[]{3, 30})));
        tEnv.executeSql("INSERT INTO mydb.T2 VALUES (1, 12), (2, 22)").await();
        Assertions.assertThat(this.collect(tEnv, "SELECT * FROM mydb.T2 ORDER BY k")).isEqualTo(Arrays.asList(Row.of((Object[])new Object[]{1, 12}), Row.of((Object[])new Object[]{2, 22}), Row.of((Object[])new Object[]{3, 30})));
    }

    private void initializeSingleUserTest(TableEnvironment tEnv, boolean isNamedArgument) throws Exception {
        tEnv.executeSql(String.format("CREATE CATALOG mycat WITH (\n  'type' = 'paimon',\n  'warehouse' = '%s'\n)", this.path));
        tEnv.executeSql("USE CATALOG mycat");
        tEnv.executeSql("CREATE DATABASE mydb");
        tEnv.executeSql("CREATE TABLE mydb.T1 (\n  k INT,\n  v INT,\n  PRIMARY KEY (k) NOT ENFORCED\n)");
        tEnv.executeSql("INSERT INTO mydb.T1 VALUES (1, 10), (2, 20), (3, 30)").await();
        if (isNamedArgument) {
            tEnv.executeSql("CALL sys.init_file_based_privilege(root_password => 'root-passwd')");
        } else {
            tEnv.executeSql("CALL sys.init_file_based_privilege('root-passwd')");
        }
        tEnv.executeSql(String.format("CREATE CATALOG rootcat WITH (\n  'type' = 'paimon',\n  'warehouse' = '%s',\n  'user' = 'root',\n  'password' = 'root-passwd'\n)", this.path));
        tEnv.executeSql("USE CATALOG rootcat");
        if (isNamedArgument) {
            tEnv.executeSql("CALL sys.create_privileged_user(username => 'test', password => 'test-passwd')");
            tEnv.executeSql("CALL sys.grant_privilege_to_user(username => 'test', privilege => 'SELECT', database => 'mydb', `table` => 'T1')");
            tEnv.executeSql("CALL sys.grant_privilege_to_user(username => 'test', privilege => 'INSERT', database => 'mydb', `table` => 'T1')");
        } else {
            tEnv.executeSql("CALL sys.create_privileged_user('test', 'test-passwd')");
            tEnv.executeSql("CALL sys.grant_privilege_to_user('test', 'SELECT', 'mydb', 'T1')");
            tEnv.executeSql("CALL sys.grant_privilege_to_user('test', 'INSERT', 'mydb', 'T1')");
        }
        tEnv.executeSql(String.format("CREATE CATALOG testcat WITH (\n  'type' = 'paimon',\n  'warehouse' = '%s',\n  'user' = 'test',\n  'password' = 'test-passwd'\n)", this.path));
        tEnv.executeSql("USE CATALOG testcat");
        Assertions.assertThat(this.collect(tEnv, "SELECT * FROM mydb.T1 ORDER BY k")).isEqualTo(Arrays.asList(Row.of((Object[])new Object[]{1, 10}), Row.of((Object[])new Object[]{2, 20}), Row.of((Object[])new Object[]{3, 30})));
        tEnv.executeSql("INSERT INTO mydb.T1 VALUES (1, 11), (2, 21)").await();
        Assertions.assertThat(this.collect(tEnv, "SELECT * FROM mydb.T1 ORDER BY k")).isEqualTo(Arrays.asList(Row.of((Object[])new Object[]{1, 11}), Row.of((Object[])new Object[]{2, 21}), Row.of((Object[])new Object[]{3, 30})));
    }

    private List<Row> collect(TableEnvironment tEnv, String sql) throws Exception {
        ArrayList<Row> result = new ArrayList<Row>();
        try (CloseableIterator it = tEnv.executeSql(sql).collect();){
            while (it.hasNext()) {
                result.add((Row)it.next());
            }
        }
        return result;
    }

    private void assertNoPrivilege(Executable executable) {
        Exception e = (Exception)org.junit.jupiter.api.Assertions.assertThrows(Exception.class, (Executable)executable);
        if (e.getCause() != null) {
            Assertions.assertThat((Throwable)e).hasRootCauseInstanceOf(NoPrivilegeException.class);
        } else {
            Assertions.assertThat((Throwable)e).isInstanceOf(NoPrivilegeException.class);
        }
    }
}

