/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.options.Options;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.reader.RecordReaderIterator;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;

public abstract class CommitterOperatorTestBase {
    private static final RowType ROW_TYPE = RowType.of((DataType[])new DataType[]{DataTypes.INT(), DataTypes.BIGINT()}, (String[])new String[]{"a", "b"});
    @TempDir
    public java.nio.file.Path tempDir;
    protected Path tablePath;

    @BeforeEach
    public void before() {
        this.tablePath = new Path(this.tempDir.toString());
    }

    protected void assertResults(FileStoreTable table, String ... expected) {
        TableRead read = table.newReadBuilder().newRead();
        ArrayList actual = new ArrayList();
        table.newReadBuilder().newScan().plan().splits().forEach(s -> {
            try {
                RecordReader recordReader = read.createReader(s);
                RecordReaderIterator it = new RecordReaderIterator(recordReader);
                while (it.hasNext()) {
                    InternalRow row = (InternalRow)it.next();
                    actual.add(row.getInt(0) + ", " + row.getLong(1));
                }
                it.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        Collections.sort(actual);
        Assertions.assertThat(actual).isEqualTo(Arrays.asList(expected));
    }

    protected FileStoreTable createFileStoreTable() throws Exception {
        return this.createFileStoreTable(options -> {}, Collections.emptyList());
    }

    protected FileStoreTable createFileStoreTable(Consumer<Options> setOptions) throws Exception {
        return this.createFileStoreTable(setOptions, Collections.emptyList());
    }

    protected FileStoreTable createFileStoreTable(Consumer<Options> setOptions, List<String> partitionKeys) throws Exception {
        Options conf = new Options();
        conf.set(CoreOptions.PATH, (Object)this.tablePath.toString());
        conf.setString("bucket", "1");
        conf.setString("bucket-key", "a");
        setOptions.accept(conf);
        SchemaManager schemaManager = new SchemaManager((FileIO)LocalFileIO.create(), this.tablePath);
        schemaManager.createTable(new Schema(ROW_TYPE.getFields(), partitionKeys, Collections.emptyList(), conf.toMap(), ""));
        return FileStoreTableFactory.create((FileIO)LocalFileIO.create(), (Options)conf);
    }
}

