/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.paimon.flink.sink.TableFilter;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TableFilterTest {
    @Test
    public void testFilterTables() {
        List<String> tableWhitelist = Collections.singletonList("white_listed_table");
        List<String> tablePrefixes = Collections.singletonList("test_");
        List<String> tableSuffixes = Collections.EMPTY_LIST;
        String tblIncludingPattern = ".*";
        String tblExcludingPattern = "";
        List<String> allTables = Arrays.asList("test_table1", "test_table2", "test_table1_suffix_in", "test_table2_suffix_in", "test_table1_suffix_ex", "test_table2_suffix_ex", "test_excluded1", "test_excluded2", "white_listed_table", "other_table1", "other_table2");
        TableFilter tableFilter = new TableFilter("", tableWhitelist, tablePrefixes, (List)tableSuffixes, tblIncludingPattern, tblExcludingPattern);
        List filteredTables = tableFilter.filterTables(allTables);
        Assertions.assertThat((int)filteredTables.size()).isEqualTo(9);
        Assertions.assertThat((List)filteredTables).contains((Object[])new String[]{"test_table1", "test_table2", "test_table1_suffix_in", "test_table2_suffix_in", "test_table1_suffix_ex", "test_table2_suffix_ex", "test_excluded1", "test_excluded2", "white_listed_table"});
        tblExcludingPattern = "excluded.*";
        tableFilter.setTblExcludingPattern(tblExcludingPattern);
        filteredTables = tableFilter.filterTables(allTables);
        Assertions.assertThat((int)filteredTables.size()).isEqualTo(7);
        Assertions.assertThat((List)filteredTables).contains((Object[])new String[]{"test_table1", "test_table2", "test_table1_suffix_in", "test_table2_suffix_in", "test_table1_suffix_ex", "test_table2_suffix_ex", "white_listed_table"});
        tableSuffixes = Collections.singletonList("_suffix_in");
        tableFilter.setTableSuffixes(tableSuffixes);
        filteredTables = tableFilter.filterTables(allTables);
        Assertions.assertThat((int)filteredTables.size()).isEqualTo(3);
        Assertions.assertThat((List)filteredTables).contains((Object[])new String[]{"test_table1_suffix_in", "test_table2_suffix_in", "white_listed_table"});
        filteredTables = tableFilter.filterTables(Collections.emptyList());
        Assertions.assertThat((int)filteredTables.size()).isEqualTo(0);
    }
}

