/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.listener;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.partition.PartitionStatistics;
import org.apache.paimon.partition.actions.AddDonePartitionAction;
import org.apache.paimon.table.PartitionHandler;
import org.apache.paimon.utils.PartitionPathUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AddDonePartitionActionTest {
    AddDonePartitionActionTest() {
    }

    @Test
    public void test() throws Exception {
        final AtomicBoolean closed = new AtomicBoolean(false);
        final HashSet donePartitions = new HashSet();
        PartitionHandler partitionHandler = new PartitionHandler(){

            public void close() throws Exception {
                closed.set(true);
            }

            public void createPartitions(List<Map<String, String>> partitions) throws Catalog.TableNotExistException {
                partitions.forEach(partition -> donePartitions.add(PartitionPathUtils.generatePartitionPath(new LinkedHashMap(partition))));
            }

            public void dropPartitions(List<Map<String, String>> partitions) throws Catalog.TableNotExistException {
            }

            public void alterPartitions(List<PartitionStatistics> partitions) throws Catalog.TableNotExistException {
            }

            public void markDonePartitions(List<Map<String, String>> partitions) throws Catalog.TableNotExistException {
            }
        };
        AddDonePartitionAction action = new AddDonePartitionAction(partitionHandler);
        action.markDone("dt=20201202");
        Assertions.assertThat(donePartitions).containsExactlyInAnyOrder((Object[])new String[]{"dt=20201202.done/"});
        action.markDone("dt=20201202/hour=02");
        Assertions.assertThat(donePartitions).containsExactlyInAnyOrder((Object[])new String[]{"dt=20201202.done/", "dt=20201202/hour=02.done/"});
        action.close();
        Assertions.assertThat((AtomicBoolean)closed).isTrue();
    }
}

