/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.listener;

import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.streaming.api.operators.collect.utils.MockOperatorStateStore;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.sink.listener.ListenerTestUtils;
import org.apache.paimon.flink.sink.listener.PartitionMarkDoneListener;
import org.apache.paimon.fs.Path;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.TableTestBase;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class PartitionMarkDoneTest
extends TableTestBase {
    PartitionMarkDoneTest() {
    }

    @Test
    public void testTriggerByCompaction() throws Exception {
        this.innerTest(true, true);
    }

    @Test
    public void testNotTriggerByCompaction() throws Exception {
        this.innerTest(false, true);
    }

    @Test
    public void testNotTriggerWhenRecoveryFromState() throws Exception {
        this.innerTest(false, false);
    }

    private void innerTest(boolean deletionVectors, boolean partitionMarkDoneRecoverFromState) throws Exception {
        Identifier identifier = this.identifier("T");
        Schema schema = Schema.newBuilder().column("a", (DataType)DataTypes.INT()).column("b", (DataType)DataTypes.INT()).column("c", (DataType)DataTypes.INT()).partitionKeys(new String[]{"a"}).primaryKey(new String[]{"a", "b"}).option(CoreOptions.PARTITION_MARK_DONE_WHEN_END_INPUT.key(), "true").option(CoreOptions.PARTITION_MARK_DONE_ACTION.key(), "success-file").option(CoreOptions.DELETION_VECTORS_ENABLED.key(), Boolean.valueOf(deletionVectors).toString()).build();
        this.catalog.createTable(identifier, schema, true);
        FileStoreTable table = (FileStoreTable)this.catalog.getTable(identifier);
        Path location = table.location();
        Path successFile = new Path(location, "a=0/_SUCCESS");
        PartitionMarkDoneListener markDone = (PartitionMarkDoneListener)PartitionMarkDoneListener.create((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (boolean)false, (boolean)false, (OperatorStateStore)new MockOperatorStateStore(), (FileStoreTable)table).get();
        if (!partitionMarkDoneRecoverFromState) {
            ListenerTestUtils.notifyCommits(markDone, false, partitionMarkDoneRecoverFromState);
            Assertions.assertThat((boolean)table.fileIO().exists(successFile)).isEqualTo(false);
            return;
        }
        ListenerTestUtils.notifyCommits(markDone, true, partitionMarkDoneRecoverFromState);
        Assertions.assertThat((boolean)table.fileIO().exists(successFile)).isEqualTo(deletionVectors);
        if (!deletionVectors) {
            ListenerTestUtils.notifyCommits(markDone, false, partitionMarkDoneRecoverFromState);
            Assertions.assertThat((boolean)table.fileIO().exists(successFile)).isEqualTo(true);
        }
    }
}

