/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sorter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.sorter.TableSortInfo;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TableSortInfoTest {
    @Test
    public void testTableSortInfoBuilderWithValidParameters() {
        TableSortInfo tableSortInfo = new TableSortInfo.Builder().setSortColumns(Arrays.asList("column1", "column2")).setSortStrategy(CoreOptions.OrderType.ORDER).setSortInCluster(true).setRangeNumber(10).setSinkParallelism(5).setLocalSampleSize(100).setGlobalSampleSize(500).build();
        Assertions.assertThat((List)tableSortInfo.getSortColumns()).containsExactly((Object[])new String[]{"column1", "column2"});
        Assertions.assertThat((Comparable)tableSortInfo.getSortStrategy()).isEqualTo((Object)CoreOptions.OrderType.ORDER);
        Assertions.assertThat((boolean)tableSortInfo.isSortInCluster()).isTrue();
        Assertions.assertThat((int)tableSortInfo.getRangeNumber()).isEqualTo(10);
        Assertions.assertThat((int)tableSortInfo.getSinkParallelism()).isEqualTo(5);
        Assertions.assertThat((int)tableSortInfo.getLocalSampleSize()).isEqualTo(100);
        Assertions.assertThat((int)tableSortInfo.getGlobalSampleSize()).isEqualTo(500);
    }

    @Test
    public void testTableSortInfoBuilderWithEmptySortColumns() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> new TableSortInfo.Builder().setSortColumns(Collections.emptyList()).setSortStrategy(CoreOptions.OrderType.ORDER).setSortInCluster(true).setRangeNumber(10).setSinkParallelism(5).setLocalSampleSize(100).setGlobalSampleSize(500).build()).withMessage("Sort columns cannot be empty");
    }

    @Test
    public void testTableSortInfoBuilderWithNullSortStrategy() {
        Assertions.assertThatExceptionOfType(NullPointerException.class).isThrownBy(() -> new TableSortInfo.Builder().setSortColumns(Arrays.asList("column1", "column2")).setSortStrategy(null).setSortInCluster(true).setRangeNumber(10).setSinkParallelism(5).setLocalSampleSize(100).setGlobalSampleSize(500).build()).withMessage("Sort strategy cannot be null");
    }

    @Test
    public void testTableSortInfoBuilderWithNegativeRangeNumber() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> new TableSortInfo.Builder().setSortColumns(Arrays.asList("column1", "column2")).setSortStrategy(CoreOptions.OrderType.ORDER).setSortInCluster(true).setRangeNumber(-1).setSinkParallelism(5).setLocalSampleSize(100).setGlobalSampleSize(500).build()).withMessage("Range number must be positive");
    }

    @Test
    public void testTableSortInfoBuilderWithZeroSinkParallelism() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> new TableSortInfo.Builder().setSortColumns(Arrays.asList("column1", "column2")).setSortStrategy(CoreOptions.OrderType.ORDER).setSortInCluster(true).setRangeNumber(10).setSinkParallelism(0).setLocalSampleSize(100).setGlobalSampleSize(500).build()).withMessageContaining("The sink parallelism must be specified when sorting the table data. Please set it using the key: %s", new Object[]{FlinkConnectorOptions.SINK_PARALLELISM.key()});
    }

    @Test
    public void testTableSortInfoBuilderWithZeroLocalSampleSize() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> new TableSortInfo.Builder().setSortColumns(Arrays.asList("column1", "column2")).setSortStrategy(CoreOptions.OrderType.ORDER).setSortInCluster(true).setRangeNumber(10).setSinkParallelism(5).setLocalSampleSize(0).setGlobalSampleSize(500).build()).withMessage("Local sample size must be positive");
    }

    @Test
    public void testTableSortInfoBuilderWithNegativeGlobalSampleSize() {
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> new TableSortInfo.Builder().setSortColumns(Arrays.asList("column1", "column2")).setSortStrategy(CoreOptions.OrderType.ORDER).setSortInCluster(true).setRangeNumber(10).setSinkParallelism(5).setLocalSampleSize(100).setGlobalSampleSize(-1).build()).withMessage("Global sample size must be positive");
    }
}

