/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.flink.source.FileStoreSourceSplit;
import org.apache.paimon.flink.source.FileStoreSourceSplitGenerator;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.mergetree.compact.MergeTreeCompactManagerTest;
import org.apache.paimon.stats.StatsTestUtils;
import org.apache.paimon.table.source.DataFilePlan;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.TableScan;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileStoreSourceSplitGeneratorTest {
    @Test
    public void test() {
        List<DataSplit> scanSplits = Arrays.asList(this.dataSplit(1, 0, "f0", "f1"), this.dataSplit(1, 1, "f2"), this.dataSplit(2, 0, "f3", "f4", "f5"), this.dataSplit(2, 1, "f6"), this.dataSplit(3, 0, "f7"), this.dataSplit(3, 1, "f8"), this.dataSplit(4, 0, "f9"), this.dataSplit(4, 1, "f10"), this.dataSplit(5, 0, "f11"), this.dataSplit(5, 1, "f12"), this.dataSplit(6, 0, "f13"), this.dataSplit(6, 1, "f14"));
        DataFilePlan tableScanPlan = new DataFilePlan(scanSplits);
        List splits = new FileStoreSourceSplitGenerator().createSplits((TableScan.Plan)tableScanPlan);
        Assertions.assertThat((int)splits.size()).isEqualTo(12);
        splits.sort(Comparator.comparingInt(o -> ((DataSplit)((FileStoreSourceSplit)o).split()).partition().getInt(0)).thenComparing(o -> ((DataSplit)((FileStoreSourceSplit)o).split()).bucket()));
        this.assertSplit((FileStoreSourceSplit)splits.get(0), "0000000001", 1, 0, Arrays.asList("f0", "f1"));
        this.assertSplit((FileStoreSourceSplit)splits.get(1), "0000000002", 1, 1, Collections.singletonList("f2"));
        this.assertSplit((FileStoreSourceSplit)splits.get(2), "0000000003", 2, 0, Arrays.asList("f3", "f4", "f5"));
        this.assertSplit((FileStoreSourceSplit)splits.get(3), "0000000004", 2, 1, Collections.singletonList("f6"));
        this.assertSplit((FileStoreSourceSplit)splits.get(4), "0000000005", 3, 0, Collections.singletonList("f7"));
        this.assertSplit((FileStoreSourceSplit)splits.get(5), "0000000006", 3, 1, Collections.singletonList("f8"));
        this.assertSplit((FileStoreSourceSplit)splits.get(6), "0000000007", 4, 0, Collections.singletonList("f9"));
        this.assertSplit((FileStoreSourceSplit)splits.get(7), "0000000008", 4, 1, Collections.singletonList("f10"));
        this.assertSplit((FileStoreSourceSplit)splits.get(8), "0000000009", 5, 0, Collections.singletonList("f11"));
        this.assertSplit((FileStoreSourceSplit)splits.get(9), "0000000010", 5, 1, Collections.singletonList("f12"));
        this.assertSplit((FileStoreSourceSplit)splits.get(10), "0000000011", 6, 0, Collections.singletonList("f13"));
        this.assertSplit((FileStoreSourceSplit)splits.get(11), "0000000012", 6, 1, Collections.singletonList("f14"));
    }

    private void assertSplit(FileStoreSourceSplit split, String splitId, int part, int bucket, List<String> files) {
        Assertions.assertThat((String)split.splitId()).isEqualTo(splitId);
        Assertions.assertThat((int)((DataSplit)split.split()).partition().getInt(0)).isEqualTo(part);
        Assertions.assertThat((int)((DataSplit)split.split()).bucket()).isEqualTo(bucket);
        Assertions.assertThat(((DataSplit)split.split()).dataFiles().stream().map(DataFileMeta::fileName).collect(Collectors.toList())).isEqualTo(files);
    }

    private DataSplit dataSplit(int partition, int bucket, String ... fileNames) {
        ArrayList<DataFileMeta> metas = new ArrayList<DataFileMeta>();
        for (String fileName : fileNames) {
            metas.add(new DataFileMeta(fileName, 0L, 0L, null, null, StatsTestUtils.newEmptySimpleStats(), StatsTestUtils.newEmptySimpleStats(), 0L, 0L, 0L, 0, Long.valueOf(0L), null, FileSource.APPEND, null));
        }
        return DataSplit.builder().withSnapshot(1L).withPartition(MergeTreeCompactManagerTest.row((int)partition)).withBucket(bucket).isStreaming(false).withDataFiles(metas).rawConvertible(false).withBucketPath("/").build();
    }
}

