/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.ArrayList;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.paimon.types.BinaryType;
import org.apache.paimon.types.CharType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypeVisitor;
import org.apache.paimon.types.DateType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.DoubleType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.SmallIntType;
import org.apache.paimon.types.TimeType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.types.VariantType;

public class DataTypeToLogicalType
implements DataTypeVisitor<LogicalType> {
    public static final DataTypeToLogicalType INSTANCE = new DataTypeToLogicalType();

    @Override
    public LogicalType visit(CharType charType) {
        return new org.apache.flink.table.types.logical.CharType(charType.isNullable(), charType.getLength());
    }

    @Override
    public LogicalType visit(VarCharType varCharType) {
        return new org.apache.flink.table.types.logical.VarCharType(varCharType.isNullable(), varCharType.getLength());
    }

    @Override
    public LogicalType visit(org.apache.paimon.types.BooleanType booleanType) {
        return new BooleanType(booleanType.isNullable());
    }

    @Override
    public LogicalType visit(BinaryType binaryType) {
        return new org.apache.flink.table.types.logical.BinaryType(binaryType.isNullable(), binaryType.getLength());
    }

    @Override
    public LogicalType visit(org.apache.paimon.types.VarBinaryType varBinaryType) {
        return new VarBinaryType(varBinaryType.isNullable(), varBinaryType.getLength());
    }

    @Override
    public LogicalType visit(DecimalType decimalType) {
        return new org.apache.flink.table.types.logical.DecimalType(decimalType.isNullable(), decimalType.getPrecision(), decimalType.getScale());
    }

    @Override
    public LogicalType visit(org.apache.paimon.types.TinyIntType tinyIntType) {
        return new TinyIntType(tinyIntType.isNullable());
    }

    @Override
    public LogicalType visit(SmallIntType smallIntType) {
        return new org.apache.flink.table.types.logical.SmallIntType(smallIntType.isNullable());
    }

    @Override
    public LogicalType visit(IntType intType) {
        return new org.apache.flink.table.types.logical.IntType(intType.isNullable());
    }

    @Override
    public LogicalType visit(org.apache.paimon.types.BigIntType bigIntType) {
        return new BigIntType(bigIntType.isNullable());
    }

    @Override
    public LogicalType visit(org.apache.paimon.types.FloatType floatType) {
        return new FloatType(floatType.isNullable());
    }

    @Override
    public LogicalType visit(DoubleType doubleType) {
        return new org.apache.flink.table.types.logical.DoubleType(doubleType.isNullable());
    }

    @Override
    public LogicalType visit(DateType dateType) {
        return new org.apache.flink.table.types.logical.DateType(dateType.isNullable());
    }

    @Override
    public LogicalType visit(TimeType timeType) {
        return new org.apache.flink.table.types.logical.TimeType(timeType.isNullable(), timeType.getPrecision());
    }

    @Override
    public LogicalType visit(org.apache.paimon.types.TimestampType timestampType) {
        return new TimestampType(timestampType.isNullable(), timestampType.getPrecision());
    }

    @Override
    public LogicalType visit(LocalZonedTimestampType localZonedTimestampType) {
        return new org.apache.flink.table.types.logical.LocalZonedTimestampType(localZonedTimestampType.isNullable(), localZonedTimestampType.getPrecision());
    }

    @Override
    public LogicalType visit(VariantType variantType) {
        throw new UnsupportedOperationException("VariantType is not supported.");
    }

    @Override
    public LogicalType visit(org.apache.paimon.types.ArrayType arrayType) {
        return new ArrayType(arrayType.isNullable(), arrayType.getElementType().accept(this));
    }

    @Override
    public LogicalType visit(MultisetType multisetType) {
        return new org.apache.flink.table.types.logical.MultisetType(multisetType.isNullable(), multisetType.getElementType().accept(this));
    }

    @Override
    public LogicalType visit(org.apache.paimon.types.MapType mapType) {
        return new MapType(mapType.isNullable(), mapType.getKeyType().accept(this), mapType.getValueType().accept(this));
    }

    @Override
    public LogicalType visit(RowType rowType) {
        ArrayList<RowType.RowField> dataFields = new ArrayList<RowType.RowField>();
        for (DataField field : rowType.getFields()) {
            LogicalType fieldType = field.type().accept(this);
            dataFields.add(new RowType.RowField(field.name(), fieldType, field.description()));
        }
        return new org.apache.flink.table.types.logical.RowType(rowType.isNullable(), dataFields);
    }
}

