/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.ExpireChangelogsAction;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;

public class ExpireChangelogsActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "expire_changelogs";
    private static final String RETAIN_MAX = "retain_max";
    private static final String RETAIN_MIN = "retain_min";
    private static final String OLDER_THAN = "older_than";
    private static final String MAX_DELETES = "max_deletes";
    private static final String DELETE_ALL = "delete_all";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        Integer retainMax = params.has(RETAIN_MAX) ? Integer.valueOf(Integer.parseInt(params.get(RETAIN_MAX))) : null;
        Integer retainMin = params.has(RETAIN_MIN) ? Integer.valueOf(Integer.parseInt(params.get(RETAIN_MIN))) : null;
        String olderThan = params.has(OLDER_THAN) ? params.get(OLDER_THAN) : null;
        Integer maxDeletes = params.has(MAX_DELETES) ? Integer.valueOf(Integer.parseInt(params.get(MAX_DELETES))) : null;
        Boolean deleteAll = params.has(DELETE_ALL) && Boolean.parseBoolean(params.get(DELETE_ALL));
        ExpireChangelogsAction action = new ExpireChangelogsAction(params.getRequired("database"), params.getRequired("table"), this.catalogConfigMap(params), retainMax, retainMin, olderThan, maxDeletes, deleteAll);
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"expire_changelogs\" expire the target changelogs.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  expire_changelogs \\\n--warehouse <warehouse_path> \\\n--database <database> \\\n--table <table> \\\n--retain_max <max> \\\n--retain_min <min> \\\n--older_than <older_than> \\\n--max_delete <max_delete> \\\n--delete_all <delete_all>");
    }
}

