/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Optional;
import org.apache.paimon.flink.action.Action;
import org.apache.paimon.flink.action.ActionFactory;
import org.apache.paimon.flink.action.MultipleParameterToolAdapter;
import org.apache.paimon.flink.action.RemoveUnexistingFilesAction;

public class RemoveUnexistingFilesActionFactory
implements ActionFactory {
    public static final String IDENTIFIER = "remove_unexisting_files";
    private static final String DRY_RUN = "dry_run";
    private static final String PARALLELISM = "parallelism";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Optional<Action> create(MultipleParameterToolAdapter params) {
        RemoveUnexistingFilesAction action = new RemoveUnexistingFilesAction(params.getRequired("database"), params.getRequired("table"), this.catalogConfigMap(params));
        if (params.has(DRY_RUN) && Boolean.parseBoolean(params.get(DRY_RUN))) {
            action.dryRun();
        }
        if (params.has(PARALLELISM)) {
            action.withParallelism(Integer.parseInt(params.get(PARALLELISM)));
        }
        return Optional.of(action);
    }

    @Override
    public void printHelp() {
        System.out.println("Action \"remove_unexisting_files\" removes unexisting data files from manifest entries.");
        System.out.println("See Java docs in https://paimon.apache.org/docs/master/api/java/org/apache/paimon/flink/action/RemoveUnexistingFilesAction.html for detailed use cases.");
        System.out.println("Note that user is on his own risk using this procedure, which may cause data loss when used outside from the use cases in Java docs.");
        System.out.println();
        System.out.println("Syntax:");
        System.out.println("  remove_unexisting_files \\\n--warehouse <warehouse_path> \\\n--database <database_name> \\\n--table <table_name> \\\n[--partition <partition_name> [--partition <partition_name> ...]] \\\n[--dry_run <false/true>] \\\n[--parallelism <parallelism>]");
        System.out.println("If partitions are not specified, this action will remove unexisting files from all partitions.");
        System.out.println("When dry_run is set to true (default false), this action only checks what files will be removed, but not really remove them.");
    }
}

