/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.clone;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.util.Collector;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.flink.clone.CloneFileInfo;
import org.apache.paimon.flink.clone.CloneProcessFunction;
import org.apache.paimon.flink.clone.DataFileInfo;
import org.apache.paimon.format.SimpleStatsExtractor;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.migrate.FileMetaUtils;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.IOUtils;

public class CloneFilesFunction
extends CloneProcessFunction<CloneFileInfo, DataFileInfo> {
    private static final long serialVersionUID = 1L;
    private transient Map<Identifier, Map<BinaryRow, DataFilePathFactory>> pathFactoryMap;

    public CloneFilesFunction(Map<String, String> sourceCatalogConfig, Map<String, String> targetCatalogConfig) {
        super(sourceCatalogConfig, targetCatalogConfig);
    }

    @Override
    public void open(Configuration conf) throws Exception {
        super.open(conf);
        this.pathFactoryMap = new HashMap<Identifier, Map<BinaryRow, DataFilePathFactory>>();
    }

    public void processElement(CloneFileInfo cloneFileInfo, ProcessFunction.Context context, Collector<DataFileInfo> collector) throws Exception {
        Identifier identifier = cloneFileInfo.identifier();
        String format = cloneFileInfo.format();
        Path path = cloneFileInfo.path();
        BinaryRow partition = cloneFileInfo.partition();
        FileIO sourceFileIO = this.hiveCatalog.fileIO();
        FileStoreTable targetTable = (FileStoreTable)this.getTable(identifier);
        Path targetFilePath = this.pathFactory(identifier, partition).newPathFromExtension("." + format);
        IOUtils.copyBytes(sourceFileIO.newInputStream(path), targetTable.fileIO().newOutputStream(targetFilePath, false));
        SimpleStatsExtractor simpleStatsExtractor = FileMetaUtils.createSimpleStatsExtractor(targetTable, format);
        DataFileMeta dataFileMeta = FileMetaUtils.constructFileMeta(targetFilePath.getName(), cloneFileInfo.fileSize(), path, simpleStatsExtractor, sourceFileIO, targetTable);
        collector.collect((Object)new DataFileInfo(identifier, partition, this.dataFileSerializer.serializeToBytes(dataFileMeta)));
    }

    private DataFilePathFactory pathFactory(Identifier identifier, BinaryRow part) {
        return this.pathFactoryMap.computeIfAbsent(identifier, k -> new HashMap()).computeIfAbsent(part, k -> {
            FileStoreTable targetTable = (FileStoreTable)this.getTable(identifier);
            return targetTable.store().pathFactory().createDataFilePathFactory(part, 0);
        });
    }
}

