/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.compact;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.transformations.PartitionTransformation;
import org.apache.flink.streaming.runtime.partitioner.RebalancePartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.paimon.append.AppendCompactTask;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.sink.AppendTableCompactSink;
import org.apache.paimon.flink.source.AppendTableCompactSource;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.Preconditions;

public class AppendTableCompactBuilder {
    private final transient StreamExecutionEnvironment env;
    private final String tableIdentifier;
    private final FileStoreTable table;
    private boolean isContinuous = false;
    @Nullable
    private Predicate partitionPredicate;
    @Nullable
    private Duration partitionIdleTime = null;

    public AppendTableCompactBuilder(StreamExecutionEnvironment env, String tableIdentifier, FileStoreTable table) {
        this.env = env;
        this.tableIdentifier = tableIdentifier;
        this.table = table;
    }

    public void withContinuousMode(boolean isContinuous) {
        this.isContinuous = isContinuous;
    }

    public void withPartitionPredicate(Predicate predicate) {
        this.partitionPredicate = predicate;
    }

    public void withPartitionIdleTime(@Nullable Duration partitionIdleTime) {
        this.partitionIdleTime = partitionIdleTime;
    }

    public void build() {
        DataStreamSource source2 = this.buildSource();
        if (this.isContinuous) {
            Preconditions.checkArgument(this.partitionIdleTime == null, "Streaming mode does not support partitionIdleTime");
        } else if (this.partitionIdleTime != null) {
            Map<BinaryRow, Long> partitionInfo = this.getPartitionInfo(this.table);
            long historyMilli = LocalDateTime.now().minus(this.partitionIdleTime).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            SingleOutputStreamOperator filterStream = source2.filter((FilterFunction & Serializable)task -> {
                BinaryRow partition = task.partition();
                return (Long)partitionInfo.get(partition) <= historyMilli;
            });
            source2 = new DataStreamSource(filterStream);
        }
        this.sinkFromSource(source2);
    }

    private Map<BinaryRow, Long> getPartitionInfo(FileStoreTable table) {
        List<PartitionEntry> partitions = table.newSnapshotReader().partitionEntries();
        return partitions.stream().collect(Collectors.toMap(PartitionEntry::partition, PartitionEntry::lastFileCreationTime));
    }

    private DataStreamSource<AppendCompactTask> buildSource() {
        long scanInterval = this.table.coreOptions().continuousDiscoveryInterval().toMillis();
        AppendTableCompactSource source2 = new AppendTableCompactSource(this.table, this.isContinuous, scanInterval, this.partitionPredicate);
        return AppendTableCompactSource.buildSource(this.env, source2, this.tableIdentifier);
    }

    private void sinkFromSource(DataStreamSource<AppendCompactTask> input) {
        DataStream<AppendCompactTask> rebalanced = this.rebalanceInput(input);
        AppendTableCompactSink.sink(this.table, rebalanced);
    }

    private DataStream<AppendCompactTask> rebalanceInput(DataStreamSource<AppendCompactTask> input) {
        Options conf = Options.fromMap(this.table.options());
        Integer compactionWorkerParallelism = conf.get(FlinkConnectorOptions.UNAWARE_BUCKET_COMPACTION_PARALLELISM);
        PartitionTransformation transformation = new PartitionTransformation(input.getTransformation(), (StreamPartitioner)new RebalancePartitioner());
        if (compactionWorkerParallelism != null) {
            transformation.setParallelism(compactionWorkerParallelism.intValue());
        } else {
            transformation.setParallelism(this.env.getParallelism());
        }
        return new DataStream(this.env, (Transformation)transformation);
    }
}

