/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.compact;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.compact.MultiTableScanBase;
import org.apache.paimon.flink.utils.MultiTablesCompactorUtil;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.StreamTableScan;
import org.apache.paimon.table.system.CompactBucketsTable;

public class MultiAwareBucketTableScan
extends MultiTableScanBase<Tuple2<Split, String>> {
    protected transient Map<Identifier, CompactBucketsTable> tablesMap = new HashMap<Identifier, CompactBucketsTable>();
    protected transient Map<Identifier, StreamTableScan> scansMap = new HashMap<Identifier, StreamTableScan>();

    public MultiAwareBucketTableScan(CatalogLoader catalogLoader, Pattern includingPattern, Pattern excludingPattern, Pattern databasePattern, boolean isStreaming, Map<String, String> tableOptions) {
        super(catalogLoader, includingPattern, excludingPattern, databasePattern, isStreaming, tableOptions);
    }

    @Override
    List<Tuple2<Split, String>> doScan() {
        ArrayList<Tuple2<Split, String>> splits = new ArrayList<Tuple2<Split, String>>();
        for (Map.Entry<Identifier, StreamTableScan> entry : this.scansMap.entrySet()) {
            Identifier identifier = entry.getKey();
            StreamTableScan scan = entry.getValue();
            splits.addAll(scan.plan().splits().stream().map(split -> new Tuple2(split, (Object)identifier.getFullName())).collect(Collectors.toList()));
        }
        return splits;
    }

    @Override
    public boolean checkTableScanned(Identifier identifier) {
        return this.tablesMap.containsKey(identifier);
    }

    @Override
    public void addScanTable(FileStoreTable fileStoreTable, Identifier identifier) {
        if (fileStoreTable.bucketMode() != BucketMode.BUCKET_UNAWARE) {
            Table bucketsTable = new CompactBucketsTable(fileStoreTable, this.isStreaming, identifier.getDatabaseName()).copy((Map)MultiTablesCompactorUtil.compactOptions(this.isStreaming));
            this.tablesMap.put(identifier, (CompactBucketsTable)bucketsTable);
            this.scansMap.put(identifier, bucketsTable.newReadBuilder().newStreamScan());
        }
    }
}

