/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.apache.paimon.utils.StringUtils;

public class AlterColumnDefaultValueProcedure
extends ProcedureBase {
    @Override
    public String identifier() {
        return "alter_column_default_value";
    }

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="column", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="default_value", type=@DataTypeHint(value="STRING"))})
    public String[] call(ProcedureContext procedureContext, String table, String column, String defaultValue) throws Catalog.ColumnAlreadyExistException, Catalog.TableNotExistException, Catalog.ColumnNotExistException {
        Identifier identifier = Identifier.fromString(table);
        String[] fieldNames = StringUtils.split(column, ".");
        SchemaChange schemaChange = SchemaChange.updateColumnDefaultValue(fieldNames, defaultValue);
        this.catalog.alterTable(identifier, ImmutableList.of(schemaChange), false);
        return new String[]{"Success"};
    }
}

