/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.apache.paimon.utils.StringUtils;
import org.apache.paimon.view.ViewChange;

public class AlterViewDialectProcedure
extends ProcedureBase {
    @ProcedureHint(argument={@ArgumentHint(name="view", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="action", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="engine", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="query", type=@DataTypeHint(value="STRING"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String view, String action, String engine, String query) throws Catalog.ViewNotExistException, Catalog.DialectAlreadyExistException, Catalog.DialectNotExistException {
        ViewChange viewChange;
        Identifier identifier = Identifier.fromString(view);
        String dialect = StringUtils.isNullOrWhitespaceOnly(engine) ? "flink" : engine;
        switch (action) {
            case "add": {
                if (StringUtils.isNullOrWhitespaceOnly(query)) {
                    throw new IllegalArgumentException("query is required for add action.");
                }
                viewChange = ViewChange.addDialect(dialect, query);
                break;
            }
            case "update": {
                if (StringUtils.isNullOrWhitespaceOnly(query)) {
                    throw new IllegalArgumentException("query is required for update action.");
                }
                viewChange = ViewChange.updateDialect(dialect, query);
                break;
            }
            case "drop": {
                viewChange = ViewChange.dropDialect(dialect);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported action: " + action);
            }
        }
        this.catalog.alterView(identifier, ImmutableList.of(viewChange), false);
        return new String[]{"Success"};
    }

    @Override
    public String identifier() {
        return "alter_view_dialect";
    }
}

