/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.time.LocalDateTime;
import java.util.List;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.flink.types.Row;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.tag.TagTimeExpire;
import org.apache.paimon.utils.DateTimeUtils;

public class ExpireTagsProcedure
extends ProcedureBase {
    private static final String IDENTIFIER = "expire_tags";

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="older_than", type=@DataTypeHint(value="STRING"), isOptional=true)})
    @DataTypeHint(value="ROW<expired_tags STRING>")
    public Row[] call(ProcedureContext procedureContext, String tableId, @Nullable String olderThanStr) throws Catalog.TableNotExistException {
        Row[] rowArray;
        List<String> expired;
        FileStoreTable fileStoreTable = (FileStoreTable)this.table(tableId);
        TagTimeExpire tagTimeExpire = fileStoreTable.store().newTagCreationManager(fileStoreTable).getTagTimeExpire();
        if (olderThanStr != null) {
            LocalDateTime olderThanTime = DateTimeUtils.parseTimestampData(olderThanStr, 3, TimeZone.getDefault()).toLocalDateTime();
            tagTimeExpire.withOlderThanTime(olderThanTime);
        }
        if ((expired = tagTimeExpire.expire()).isEmpty()) {
            Row[] rowArray2 = new Row[1];
            rowArray = rowArray2;
            rowArray2[0] = Row.of((Object[])new Object[]{"No expired tags."});
        } else {
            rowArray = (Row[])expired.stream().map(xva$0 -> Row.of((Object[])new Object[]{xva$0})).toArray(Row[]::new);
        }
        return rowArray;
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

