/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import org.apache.paimon.data.InternalRow;
import org.apache.paimon.index.BucketAssigner;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.sink.ChannelComputer;
import org.apache.paimon.table.sink.RowPartitionKeyExtractor;
import org.apache.paimon.utils.MathUtils;

public class RowAssignerChannelComputer
implements ChannelComputer<InternalRow> {
    private static final long serialVersionUID = 1L;
    private final TableSchema schema;
    private Integer numAssigners;
    private transient int numChannels;
    private transient RowPartitionKeyExtractor extractor;

    public RowAssignerChannelComputer(TableSchema schema, Integer numAssigners) {
        this.schema = schema;
        this.numAssigners = numAssigners;
    }

    @Override
    public void setup(int numChannels) {
        this.numChannels = numChannels;
        this.numAssigners = MathUtils.min(this.numAssigners, numChannels);
        this.extractor = new RowPartitionKeyExtractor(this.schema);
    }

    @Override
    public int channel(InternalRow record) {
        int partitionHash = this.extractor.partition(record).hashCode();
        int keyHash = this.extractor.trimmedPrimaryKey(record).hashCode();
        return BucketAssigner.computeAssigner(partitionHash, keyHash, this.numChannels, this.numAssigners);
    }

    public String toString() {
        return "shuffle by key hash";
    }
}

