/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.utils;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.flink.utils.InternalTypeSerializer;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;

public class InternalRowTypeSerializer
extends InternalTypeSerializer<InternalRow> {
    private final InternalRowSerializer internalRowSerializer;

    public InternalRowTypeSerializer(RowType rowType) {
        this(rowType.getFieldTypes().toArray(new DataType[0]));
    }

    public InternalRowTypeSerializer(DataType ... types) {
        this.internalRowSerializer = new InternalRowSerializer(types);
    }

    public TypeSerializer<InternalRow> duplicate() {
        return new InternalRowTypeSerializer(this.internalRowSerializer.fieldTypes());
    }

    public InternalRow createInstance() {
        return new BinaryRow(this.internalRowSerializer.getArity());
    }

    public InternalRow copy(InternalRow from) {
        return this.internalRowSerializer.copy(from);
    }

    @Override
    public InternalRow copy(InternalRow from, InternalRow reuse) {
        return this.internalRowSerializer.copyRowData(from, reuse);
    }

    public void serialize(InternalRow record, DataOutputView target) throws IOException {
        BinaryRow row = this.internalRowSerializer.toBinaryRow(record);
        target.writeInt(row.getSizeInBytes());
        target.write(row.toBytes());
    }

    public InternalRow deserialize(DataInputView source2) throws IOException {
        return this.deserialize(this.createInstance(), source2);
    }

    @Override
    public InternalRow deserialize(InternalRow reuse, DataInputView source2) throws IOException {
        BinaryRow reuseRow = (BinaryRow)reuse;
        int len = source2.readInt();
        byte[] bytes = new byte[len];
        source2.readFully(bytes);
        reuseRow.pointTo(MemorySegment.wrap(bytes), 0, len);
        return reuse;
    }

    @Override
    public void copy(DataInputView source2, DataOutputView target) throws IOException {
        int length = source2.readInt();
        target.writeInt(length);
        target.write(source2, length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        InternalRowTypeSerializer that = (InternalRowTypeSerializer)((Object)o);
        return Objects.equals(this.internalRowSerializer, that.internalRowSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.internalRowSerializer);
    }
}

