/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.List;
import org.apache.flink.types.Row;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class BucketFunctionTypeITCase
extends CatalogITCaseBase {
    @ParameterizedTest
    @EnumSource(value=CoreOptions.BucketFunctionType.class)
    public void testInsertAndSelect(CoreOptions.BucketFunctionType bucketFunctionType) {
        int i;
        this.sql("CREATE TABLE T (a INT, b STRING, c INT) with ('bucket-function.type' = '%s', 'bucket-key' = 'a', 'bucket' = '4', 'metadata.stats-mode' = 'none')", bucketFunctionType);
        for (i = 0; i < 10; ++i) {
            this.sql("INSERT INTO T (a, b, c) VALUES (%s, '%s', %s)", i, i, i);
        }
        for (i = 0; i < 10; ++i) {
            List<Row> rows = this.sql("SELECT * FROM T where a = %s", i);
            Assertions.assertThat((int)rows.size()).isEqualTo(1);
            Assertions.assertThat((Object)rows.get(0)).isEqualTo((Object)Row.of((Object[])new Object[]{i, String.valueOf(i), i}));
        }
    }
}

