/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogView;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedCatalogView;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.types.DataType;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.flink.FlinkCatalog;
import org.apache.paimon.flink.FlinkCatalogFactory;
import org.apache.paimon.flink.RESTCatalogITCaseBase;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.rest.RESTCatalogOptions;
import org.apache.paimon.rest.auth.AuthProviderEnum;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FlinkRestCatalogITCase
extends RESTCatalogITCaseBase {
    private FlinkCatalog catalog;

    @Override
    @BeforeEach
    public void before() throws IOException {
        super.before();
        this.initFlinkCatalog();
    }

    @Test
    void testListTableReturnsView() throws Exception {
        this.catalog.createDatabase("test", null, true);
        this.catalog.createTable(new ObjectPath("test", "t1"), (CatalogBaseTable)this.createTable(Collections.emptyMap()), true);
        AssertionsForInterfaceTypes.assertThat((List)this.catalog.listTables("test")).containsExactly((Object[])new String[]{"t1"});
        this.catalog.createTable(new ObjectPath("test", "v"), (CatalogBaseTable)this.createView(), true);
        AssertionsForInterfaceTypes.assertThat((List)this.catalog.listTables("test")).containsExactlyInAnyOrder((Object[])new String[]{"t1", "v"});
    }

    private CatalogTable createTable(Map<String, String> options) {
        ResolvedSchema resolvedSchema = this.createSchema();
        CatalogTable origin = CatalogTable.newBuilder().schema(Schema.newBuilder().fromResolvedSchema(resolvedSchema).build()).comment("test comment").partitionKeys(Collections.emptyList()).options(options).build();
        return new ResolvedCatalogTable(origin, resolvedSchema);
    }

    private CatalogView createView() {
        ResolvedSchema resolvedSchema = this.createSchema();
        String query = "SELECT * FROM test.t1";
        CatalogView view = CatalogView.of((Schema)Schema.newBuilder().fromResolvedSchema(resolvedSchema).build(), null, (String)query, (String)query, Collections.emptyMap());
        return new ResolvedCatalogView(view, resolvedSchema);
    }

    private ResolvedSchema createSchema() {
        return new ResolvedSchema(Arrays.asList(Column.physical((String)"first", (DataType)DataTypes.STRING()), Column.physical((String)"second", (DataType)DataTypes.INT()), Column.physical((String)"third", (DataType)DataTypes.STRING()), Column.physical((String)"four", (DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"f1", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"f2", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"f3", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT()))}))), Collections.emptyList(), null);
    }

    private void initFlinkCatalog() {
        ImmutableMap authMap = ImmutableMap.of((Object)RESTCatalogOptions.TOKEN.key(), (Object)"init_token", (Object)RESTCatalogOptions.TOKEN_PROVIDER.key(), (Object)AuthProviderEnum.BEAR.identifier());
        Options options = new Options();
        for (Map.Entry entry : authMap.entrySet()) {
            options.set((String)entry.getKey(), (String)entry.getValue());
        }
        options.set(CatalogOptions.METASTORE, (Object)"rest");
        options.set(CatalogOptions.WAREHOUSE.key(), this.warehouse);
        options.set(RESTCatalogOptions.URI, (Object)this.restCatalogServer.getUrl());
        options.set("rest.test.data-path", this.path);
        this.catalog = FlinkCatalogFactory.createCatalog((String)"c", (CatalogContext)CatalogContext.create((Options)options), (ClassLoader)FlinkRestCatalogITCase.class.getClassLoader());
    }
}

