/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class PredicateITCase
extends CatalogITCaseBase {
    @Test
    public void testPkFilterBucket() throws Exception {
        this.sql("CREATE TABLE T (a INT PRIMARY KEY NOT ENFORCED, b INT) WITH ('bucket' = '5')", new Object[0]);
        this.writeRecords();
        this.innerTestSingleField();
        this.innerTestAllFields();
    }

    @Test
    public void testNoPkFilterBucket() throws Exception {
        this.sql("CREATE TABLE T (a INT, b INT) WITH ('bucket' = '5', 'bucket-key'='a')", new Object[0]);
        this.writeRecords();
        this.innerTestSingleField();
        this.innerTestAllFields();
    }

    @Test
    public void testAppendFilterBucket() throws Exception {
        this.sql("CREATE TABLE T (a INT, b INT) WITH ('bucket' = '5', 'bucket-key'='a')", new Object[0]);
        this.writeRecords();
        this.innerTestSingleField();
        this.innerTestAllFields();
    }

    @Test
    public void testIntegerFilter() {
        int rand = ThreadLocalRandom.current().nextInt(3);
        String fileFormat = rand == 0 ? "avro" : (rand == 1 ? "parquet" : "orc");
        this.sql("CREATE TABLE T (a TINYINT,b SMALLINT,c INT,d BIGINT) WITH ('file.format' = '%s')", fileFormat);
        this.sql("INSERT INTO T VALUES (CAST (1 AS TINYINT), CAST (1 AS SMALLINT), 1, 1), (CAST (2 AS TINYINT), CAST (2 AS SMALLINT), 2, 2)", new Object[0]);
        Row expectedResult = Row.of((Object[])new Object[]{(byte)1, (short)1, 1, 1L});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = CAST (1 AS TINYINT)", new Object[0])).containsExactly((Object[])new Row[]{expectedResult});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE b = CAST (1 AS SMALLINT)", new Object[0])).containsExactly((Object[])new Row[]{expectedResult});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE c = 1", new Object[0])).containsExactly((Object[])new Row[]{expectedResult});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE d = CAST (1 AS BIGINT)", new Object[0])).containsExactly((Object[])new Row[]{expectedResult});
    }

    private void writeRecords() throws Exception {
        this.sql("INSERT INTO T VALUES (1, 2), (3, 4), (5, 6), (7, 8), (9, 10)", new Object[0]);
    }

    private void innerTestSingleField() throws Exception {
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 1", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 3", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{3, 4})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 5", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{5, 6})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 7", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{7, 8})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 9", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{9, 10})});
    }

    private void innerTestAllFields() throws Exception {
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 1 and b = 2", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 3 and b = 4", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{3, 4})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 5 and b = 6", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{5, 6})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 7 and b = 8", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{7, 8})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE a = 9 and b = 10", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{9, 10})});
    }
}

