/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogFunctionImpl;
import org.apache.flink.table.catalog.FunctionLanguage;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.resource.ResourceType;
import org.apache.flink.table.resource.ResourceUri;
import org.apache.flink.types.Row;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.RESTCatalogITCaseBase;
import org.apache.paimon.rest.RESTToken;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableMap;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RESTCatalogITCase
extends RESTCatalogITCaseBase {
    RESTCatalogITCase() {
    }

    @Test
    void testCreateTable() {
        List<Row> result = this.sql(String.format("SHOW CREATE TABLE %s.%s", "mydb", "t1"), new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{String.format("CREATE TABLE `PAIMON`.`%s`.`%s` (\n  `a` VARCHAR(2147483647),\n  `b` DOUBLE", "mydb", "t1")});
    }

    @Test
    void testAlterTable() {
        this.sql(String.format("ALTER TABLE %s.%s ADD e INT AFTER b", "mydb", "t1"), new Object[0]);
        this.sql(String.format("ALTER TABLE %s.%s DROP b", "mydb", "t1"), new Object[0]);
        this.sql(String.format("ALTER TABLE %s.%s RENAME a TO a1", "mydb", "t1"), new Object[0]);
        this.sql(String.format("ALTER TABLE %s.%s MODIFY e DOUBLE", "mydb", "t1"), new Object[0]);
        List<Row> result = this.sql(String.format("SHOW CREATE TABLE %s.%s", "mydb", "t1"), new Object[0]);
        Assertions.assertThat((String)result.toString()).contains(new CharSequence[]{String.format("CREATE TABLE `PAIMON`.`%s`.`%s` (\n  `a1` VARCHAR(2147483647),\n  `e` DOUBLE", "mydb", "t1")});
    }

    @Test
    public void testWriteAndRead() {
        this.batchSql(String.format("INSERT INTO %s.%s VALUES ('1', 11), ('2', 22)", "mydb", "t1"), new Object[0]);
        Assertions.assertThat(this.batchSql(String.format("SELECT * FROM %s.%s", "mydb", "t1"), new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{"1", 11.0}), Row.of((Object[])new Object[]{"2", 22.0})});
    }

    @Test
    public void testExpiredDataToken() {
        Identifier identifier = Identifier.create((String)"mydb", (String)"t1");
        RESTToken expiredDataToken = new RESTToken((Map)ImmutableMap.of((Object)"akId", (Object)"akId-expire", (Object)"akSecret", (Object)UUID.randomUUID().toString()), System.currentTimeMillis() - 100000L);
        this.restCatalogServer.setDataToken(identifier, expiredDataToken);
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> this.batchSql(String.format("INSERT INTO %s.%s VALUES ('1', 11), ('2', 22)", "mydb", "t1"), new Object[0]));
        RESTToken dataToken = new RESTToken((Map)ImmutableMap.of((Object)"akId", (Object)"akId", (Object)"akSecret", (Object)UUID.randomUUID().toString()), System.currentTimeMillis() + 100000L);
        this.restCatalogServer.setDataToken(identifier, dataToken);
        this.batchSql(String.format("INSERT INTO %s.%s VALUES ('1', 11), ('2', 22)", "mydb", "t1"), new Object[0]);
        Assertions.assertThat(this.batchSql(String.format("SELECT * FROM %s.%s", "mydb", "t1"), new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{"1", 11.0}), Row.of((Object[])new Object[]{"2", 22.0})});
    }

    @Test
    public void testFunction() throws Exception {
        Catalog catalog = (Catalog)this.tEnv.getCatalog("PAIMON").get();
        String functionName = "test_str2";
        String identifier = "com.streaming.flink.udf.StrUdf";
        String jarResourcePath = "xxxx.jar";
        String jarResourcePath2 = "xxxx-yyyyy.jar";
        CatalogFunctionImpl function = new CatalogFunctionImpl(identifier, FunctionLanguage.JAVA, (List)ImmutableList.of((Object)new ResourceUri(ResourceType.JAR, jarResourcePath), (Object)new ResourceUri(ResourceType.JAR, jarResourcePath2)));
        this.sql(String.format("CREATE FUNCTION %s.%s AS '%s' LANGUAGE %s USING %s '%s', %s '%s'", "mydb", functionName, function.getClassName(), function.getFunctionLanguage(), ResourceType.JAR, jarResourcePath, ResourceType.JAR, jarResourcePath2), new Object[0]);
        Assertions.assertThat(this.batchSql(String.format("SHOW FUNCTIONS in %s", "mydb"), new Object[0])).contains((Object[])new Row[]{Row.of((Object[])new Object[]{functionName})});
        ObjectPath functionObjectPath = new ObjectPath("mydb", functionName);
        CatalogFunction getFunction = catalog.getFunction(functionObjectPath);
        Assertions.assertThat((Object)getFunction).isEqualTo((Object)function);
        identifier = "com.streaming.flink.udf.StrUdf2";
        this.sql(String.format("ALTER FUNCTION PAIMON.%s.%s AS '%s' LANGUAGE %s", "mydb", functionName, identifier, function.getFunctionLanguage()), new Object[0]);
        getFunction = catalog.getFunction(functionObjectPath);
        Assertions.assertThat((String)getFunction.getClassName()).isEqualTo(identifier);
        this.sql(String.format("DROP FUNCTION %s.%s", "mydb", functionName), new Object[0]);
        Assertions.assertThat((boolean)catalog.functionExists(functionObjectPath)).isFalse();
    }
}

