/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.rest.RESTCatalogInternalOptions;
import org.apache.paimon.rest.RESTCatalogOptions;
import org.apache.paimon.rest.RESTCatalogServer;
import org.apache.paimon.rest.RESTTokenFileIO;
import org.apache.paimon.rest.auth.AuthProvider;
import org.apache.paimon.rest.auth.AuthProviderEnum;
import org.apache.paimon.rest.auth.BearTokenAuthProvider;
import org.apache.paimon.rest.responses.ConfigResponse;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableMap;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;

public abstract class RESTCatalogITCaseBase
extends CatalogITCaseBase {
    protected static final String DATABASE_NAME = "mydb";
    protected static final String TABLE_NAME = "t1";
    protected static final String INIT_TOKEN = "init_token";
    protected RESTCatalogServer restCatalogServer;
    private String serverUrl;
    protected String dataPath;
    protected String warehouse;
    @TempDir
    Path tempFile;

    @Override
    @BeforeEach
    public void before() throws IOException {
        this.dataPath = this.tempFile.toUri().toString();
        this.warehouse = UUID.randomUUID().toString();
        ConfigResponse config = new ConfigResponse((Map)ImmutableMap.of((Object)RESTCatalogInternalOptions.PREFIX.key(), (Object)"paimon", (Object)RESTTokenFileIO.DATA_TOKEN_ENABLED.key(), (Object)"true", (Object)CatalogOptions.WAREHOUSE.key(), (Object)this.warehouse), (Map)ImmutableMap.of());
        BearTokenAuthProvider authProvider = new BearTokenAuthProvider(INIT_TOKEN);
        this.restCatalogServer = new RESTCatalogServer(this.dataPath, (AuthProvider)authProvider, config, this.warehouse);
        this.restCatalogServer.start();
        this.serverUrl = this.restCatalogServer.getUrl();
        super.before();
        this.sql(String.format("CREATE DATABASE %s", DATABASE_NAME), new Object[0]);
        this.sql(String.format("CREATE TABLE %s.%s (a STRING, b DOUBLE)", DATABASE_NAME, TABLE_NAME), new Object[0]);
    }

    @Override
    protected Map<String, String> catalogOptions() {
        String initToken = INIT_TOKEN;
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("metastore", "rest");
        options.put(CatalogOptions.WAREHOUSE.key(), this.warehouse);
        options.put(RESTCatalogOptions.URI.key(), this.serverUrl);
        options.put(RESTCatalogOptions.TOKEN.key(), initToken);
        options.put(RESTCatalogOptions.TOKEN_PROVIDER.key(), AuthProviderEnum.BEAR.identifier());
        options.put(RESTTokenFileIO.DATA_TOKEN_ENABLED.key(), "true");
        options.put("rest.test.data-path", this.dataPath.replaceFirst("file", "rest-test-file-io"));
        return options;
    }

    @Override
    protected String getTempDirPath() {
        return this.dataPath;
    }

    @Override
    protected boolean supportDefineWarehouse() {
        return false;
    }
}

