/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.CreateBranchAction;
import org.apache.paimon.flink.action.DeleteBranchAction;
import org.apache.paimon.flink.action.FastForwardAction;
import org.apache.paimon.flink.util.ReadWriteTableTestUtil;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class BranchActionITCase
extends ActionITCaseBase {
    @Test
    void testCreateAndDeleteBranch() throws Exception {
        ReadWriteTableTestUtil.init(this.warehouse);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"k", "v"});
        FileStoreTable table = this.createFileStoreTable(rowType, Collections.emptyList(), Collections.singletonList("k"), Collections.emptyList(), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(1L, BinaryString.fromString((String)"Hi")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Hello")));
        this.writeData(this.rowData(3L, BinaryString.fromString((String)"Paimon")));
        TagManager tagManager = new TagManager(table.fileIO(), table.location());
        this.executeSQL(String.format("CALL sys.create_tag('%s.%s', 'tag2', 2, '5 d')", this.database, this.tableName));
        Assertions.assertThat((boolean)tagManager.tagExists("tag2")).isTrue();
        BranchManager branchManager = table.branchManager();
        this.executeSQL(String.format("CALL sys.create_branch('%s.%s', 'branch_name', 'tag2')", this.database, this.tableName));
        Assertions.assertThat((boolean)branchManager.branchExists("branch_name")).isTrue();
        this.executeSQL(String.format("CALL sys.create_branch(`table` => '%s.%s', branch => 'branch_name_named_argument', tag => 'tag2')", this.database, this.tableName));
        Assertions.assertThat((boolean)branchManager.branchExists("branch_name_named_argument")).isTrue();
        this.executeSQL(String.format("CALL sys.delete_branch('%s.%s', 'branch_name')", this.database, this.tableName));
        Assertions.assertThat((boolean)branchManager.branchExists("branch_name")).isFalse();
        this.executeSQL(String.format("CALL sys.delete_branch(`table` => '%s.%s', branch => 'branch_name_named_argument')", this.database, this.tableName));
        Assertions.assertThat((boolean)branchManager.branchExists("branch_name_named_argument")).isFalse();
        this.createAction(CreateBranchAction.class, "create_branch", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--branch_name", "branch_name", "--tag_name", "tag2").run();
        Assertions.assertThat((boolean)branchManager.branchExists("branch_name")).isTrue();
        this.createAction(DeleteBranchAction.class, "delete_branch", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--branch_name", "branch_name").run();
        Assertions.assertThat((boolean)branchManager.branchExists("branch_name")).isFalse();
    }

    @Test
    void testCreateAndDeleteEmptyBranch() throws Exception {
        ReadWriteTableTestUtil.init(this.warehouse);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"k", "v"});
        FileStoreTable table = this.createFileStoreTable(rowType, Collections.emptyList(), Collections.singletonList("k"), Collections.emptyList(), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(1L, BinaryString.fromString((String)"Hi")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Hello")));
        this.writeData(this.rowData(3L, BinaryString.fromString((String)"Paimon")));
        BranchManager branchManager = table.branchManager();
        this.executeSQL(String.format("CALL sys.create_branch('%s.%s', 'empty_branch_name')", this.database, this.tableName));
        Assertions.assertThat((boolean)branchManager.branchExists("empty_branch_name")).isTrue();
        this.executeSQL(String.format("CALL sys.create_branch(`table` => '%s.%s', branch => 'empty_branch_named_argument')", this.database, this.tableName));
        Assertions.assertThat((boolean)branchManager.branchExists("empty_branch_named_argument")).isTrue();
        this.executeSQL(String.format("CALL sys.delete_branch('%s.%s', 'empty_branch_name')", this.database, this.tableName));
        Assertions.assertThat((boolean)branchManager.branchExists("empty_branch_name")).isFalse();
        this.executeSQL(String.format("CALL sys.delete_branch(`table` => '%s.%s', branch => 'empty_branch_named_argument')", this.database, this.tableName));
        Assertions.assertThat((boolean)branchManager.branchExists("empty_branch_named_argument")).isFalse();
        this.createAction(CreateBranchAction.class, "create_branch", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--branch_name", "empty_branch_name").run();
        Assertions.assertThat((boolean)branchManager.branchExists("empty_branch_name")).isTrue();
        this.createAction(DeleteBranchAction.class, "delete_branch", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--branch_name", "empty_branch_name").run();
        Assertions.assertThat((boolean)branchManager.branchExists("empty_branch_name")).isFalse();
    }

    @Test
    void testFastForward() throws Exception {
        ReadWriteTableTestUtil.init(this.warehouse);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"k", "v"});
        FileStoreTable table = this.createFileStoreTable(rowType, Collections.emptyList(), Collections.singletonList("k"), Collections.emptyList(), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(1L, BinaryString.fromString((String)"Hi")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Hello")));
        this.writeData(this.rowData(3L, BinaryString.fromString((String)"Paimon")));
        TagManager tagManager = new TagManager(table.fileIO(), table.location());
        this.executeSQL(String.format("CALL sys.create_tag('%s.%s', 'tag2', 2)", this.database, this.tableName));
        Assertions.assertThat((boolean)tagManager.tagExists("tag2")).isTrue();
        this.executeSQL(String.format("CALL sys.create_tag('%s.%s', 'tag3', 3)", this.database, this.tableName));
        Assertions.assertThat((boolean)tagManager.tagExists("tag3")).isTrue();
        BranchManager branchManager = table.branchManager();
        this.executeSQL(String.format("CALL sys.create_branch('%s.%s', 'branch_name', 'tag2')", this.database, this.tableName));
        Assertions.assertThat((boolean)branchManager.branchExists("branch_name")).isTrue();
        this.createAction(CreateBranchAction.class, "create_branch", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--branch_name", "branch_name_action", "--tag_name", "tag3").run();
        Assertions.assertThat((boolean)branchManager.branchExists("branch_name_action")).isTrue();
        this.executeSQL(String.format("CALL sys.fast_forward('%s.%s', 'branch_name')", this.database, this.tableName));
        SnapshotManager snapshotManager = table.snapshotManager();
        Assertions.assertThat((boolean)snapshotManager.snapshotExists(3L)).isFalse();
        this.createAction(FastForwardAction.class, "fast_forward", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--branch_name", "branch_name_action").run();
        Assertions.assertThat((boolean)snapshotManager.snapshotExists(3L)).isTrue();
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        for (long i = 4L; i < 14L; ++i) {
            this.writeData(this.rowData(i, BinaryString.fromString((String)String.format("new.data_%s", i))));
        }
        List<String> result = this.readTableData(table);
        ArrayList<String> sortedActual = new ArrayList<String>(result);
        List<String> expected = Arrays.asList("+I[1, Hi]", "+I[2, Hello]", "+I[3, Paimon]", "+I[4, new.data_4]", "+I[5, new.data_5]", "+I[6, new.data_6]", "+I[7, new.data_7]", "+I[8, new.data_8]", "+I[9, new.data_9]", "+I[10, new.data_10]", "+I[11, new.data_11]", "+I[12, new.data_12]", "+I[13, new.data_13]");
        org.junit.jupiter.api.Assertions.assertEquals(expected, sortedActual);
        this.executeSQL(String.format("CALL sys.fast_forward(`table` => '%s.%s', branch => 'branch_name')", this.database, this.tableName));
        result = this.readTableData(table);
        sortedActual = new ArrayList<String>(result);
        expected = Arrays.asList("+I[1, Hi]", "+I[2, Hello]");
        org.junit.jupiter.api.Assertions.assertEquals(expected, sortedActual);
        this.createAction(FastForwardAction.class, "fast_forward", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--branch_name", "branch_name_action").run();
        result = this.readTableData(table);
        sortedActual = new ArrayList<String>(result);
        expected = Arrays.asList("+I[1, Hi]", "+I[2, Hello]", "+I[3, Paimon]");
        org.junit.jupiter.api.Assertions.assertEquals(expected, sortedActual);
    }

    protected List<String> readTableData(FileStoreTable table) throws Exception {
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()}, (String[])new String[]{"k", "v"});
        ReadBuilder readBuilder = table.newReadBuilder();
        TableScan.Plan plan = readBuilder.newScan().plan();
        List<String> result = this.getResult(readBuilder.newRead(), plan == null ? Collections.emptyList() : plan.splits(), rowType);
        return result;
    }
}

