/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.io.IOException;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileIOLoader;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.fs.PositionOutputStreamWrapper;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.fs.SeekableInputStreamWrapper;
import org.apache.paimon.fs.local.LocalFileIO;

public class CopyFilesActionSlowFileIO
extends LocalFileIO {
    public static final String SCHEME = "copy-slow";
    private static final int SLEEP_MILLIS = 150;

    public SeekableInputStream newInputStream(Path f) throws IOException {
        return new SlowSeekableInputStreamWrapper(super.newInputStream(f));
    }

    public PositionOutputStream newOutputStream(Path filePath, boolean overwrite) throws IOException {
        return new SlowPositionOutputStreamWrapper(super.newOutputStream(filePath, overwrite));
    }

    private static boolean checkStackTrace() {
        for (StackTraceElement layer : Thread.currentThread().getStackTrace()) {
            if (!layer.getMethodName().contains("copyBytes")) continue;
            return true;
        }
        return false;
    }

    public static class Loader
    implements FileIOLoader {
        private static final long serialVersionUID = 1L;

        public String getScheme() {
            return CopyFilesActionSlowFileIO.SCHEME;
        }

        public FileIO load(Path path) {
            return new CopyFilesActionSlowFileIO();
        }
    }

    private static class SlowPositionOutputStreamWrapper
    extends PositionOutputStreamWrapper {
        public SlowPositionOutputStreamWrapper(PositionOutputStream outputStream) {
            super(outputStream);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (CopyFilesActionSlowFileIO.checkStackTrace()) {
                try {
                    Thread.sleep(150L);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            super.write(b, off, len);
        }
    }

    private static class SlowSeekableInputStreamWrapper
    extends SeekableInputStreamWrapper {
        public SlowSeekableInputStreamWrapper(SeekableInputStream inputStream) {
            super(inputStream);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (CopyFilesActionSlowFileIO.checkStackTrace()) {
                try {
                    Thread.sleep(150L);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return super.read(b, off, len);
        }
    }
}

