/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.ExpirePartitionsAction;
import org.apache.paimon.flink.util.ReadWriteTableTestUtil;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SnapshotManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExpirePartitionsActionITCase
extends ActionITCaseBase {
    private static final DataType[] FIELD_TYPES = new DataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()};
    private static final RowType ROW_TYPE = RowType.of((DataType[])FIELD_TYPES, (String[])new String[]{"k", "dt", "hm"});

    @BeforeEach
    public void setUp() {
        ReadWriteTableTestUtil.init(this.warehouse);
    }

    @Test
    public void testExpirePartitionsAction() throws Exception {
        FileStoreTable table = this.prepareTable();
        TableScan.Plan plan = table.newReadBuilder().newScan().plan();
        List<String> actual = this.getResult(table.newReadBuilder().newRead(), plan.splits(), ROW_TYPE);
        List<String> expected = Arrays.asList("+I[1, 2024-01-01, 01:00]", "+I[2, 9999-09-20, 02:00]");
        Assertions.assertThat(actual).isEqualTo(expected);
        this.createAction(ExpirePartitionsAction.class, "expire_partitions", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--expiration_time", "1 d", "--timestamp_formatter", "yyyy-MM-dd").run();
        SnapshotManager snapshotManager = this.getFileStoreTable(this.tableName).snapshotManager();
        Snapshot snapshot = snapshotManager.snapshot(snapshotManager.latestSnapshotId().longValue());
        Assertions.assertThat((long)snapshot.id()).isEqualTo(3L);
        Assertions.assertThat((Comparable)snapshot.commitKind()).isEqualTo((Object)Snapshot.CommitKind.OVERWRITE);
        plan = table.newReadBuilder().newScan().plan();
        actual = this.getResult(table.newReadBuilder().newRead(), plan.splits(), ROW_TYPE);
        expected = Arrays.asList("+I[2, 9999-09-20, 02:00]");
        Assertions.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void testExpirePartitionsActionWithTimePartition() throws Exception {
        FileStoreTable table = this.prepareTable();
        TableScan.Plan plan = table.newReadBuilder().newScan().plan();
        List<String> actual = this.getResult(table.newReadBuilder().newRead(), plan.splits(), ROW_TYPE);
        List<String> expected = Arrays.asList("+I[1, 2024-01-01, 01:00]", "+I[2, 9999-09-20, 02:00]");
        Assertions.assertThat(actual).isEqualTo(expected);
        this.createAction(ExpirePartitionsAction.class, "expire_partitions", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--expiration_time", "1 d", "--timestamp_formatter", "yyyy-MM-dd HH:mm", "--timestamp_pattern", "$dt $hm").run();
        plan = table.newReadBuilder().newScan().plan();
        actual = this.getResult(table.newReadBuilder().newRead(), plan.splits(), ROW_TYPE);
        expected = Arrays.asList("+I[2, 9999-09-20, 02:00]");
        Assertions.assertThat(actual).isEqualTo(expected);
    }

    @Test
    public void testExpirePartitionsWithTableConf() throws Exception {
        FileStoreTable table = this.prepareTable();
        this.writeData(this.rowData(BinaryString.fromString((String)"3"), BinaryString.fromString((String)"2024-01-01"), BinaryString.fromString((String)"02:00")));
        this.writeData(this.rowData(BinaryString.fromString((String)"4"), BinaryString.fromString((String)"2024-01-02"), BinaryString.fromString((String)"01:00")));
        TableScan.Plan plan = table.newReadBuilder().newScan().plan();
        List<String> actual = this.getResult(table.newReadBuilder().newRead(), plan.splits(), ROW_TYPE);
        List<String> expected = Arrays.asList("+I[1, 2024-01-01, 01:00]", "+I[2, 9999-09-20, 02:00]", "+I[3, 2024-01-01, 02:00]", "+I[4, 2024-01-02, 01:00]");
        Assertions.assertThat(actual).isEqualTo(expected);
        this.createAction(ExpirePartitionsAction.class, "expire_partitions", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--expiration_time", "1 d", "--timestamp_formatter", "yyyy-MM-dd", "--timestamp_pattern", "$dt", "--table_conf", "partition.expiration-max-num=1", "--table_conf", "partition.expiration-batch-size=1").run();
        plan = table.newReadBuilder().newScan().plan();
        actual = this.getResult(table.newReadBuilder().newRead(), plan.splits(), ROW_TYPE);
        expected = Arrays.asList("+I[2, 9999-09-20, 02:00]", "+I[3, 2024-01-01, 02:00]", "+I[4, 2024-01-02, 01:00]");
        Assertions.assertThat(actual).isEqualTo(expected);
    }

    private FileStoreTable prepareTable() throws Exception {
        ReadWriteTableTestUtil.init(this.warehouse);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()}, (String[])new String[]{"k", "dt", "hm"});
        String[] pk = new String[]{"k", "dt", "hm"};
        String[] partitions = new String[]{"dt", "hm"};
        FileStoreTable table = this.createFileStoreTable(rowType, new ArrayList<String>(Arrays.asList(partitions)), new ArrayList<String>(Arrays.asList(pk)), Collections.singletonList("k"), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(BinaryString.fromString((String)"1"), BinaryString.fromString((String)"2024-01-01"), BinaryString.fromString((String)"01:00")));
        this.writeData(this.rowData(BinaryString.fromString((String)"2"), BinaryString.fromString((String)"9999-09-20"), BinaryString.fromString((String)"02:00")));
        return table;
    }
}

