/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.RemoveUnexistingFilesAction;
import org.apache.paimon.operation.ListUnexistingFilesTest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class RemoveUnexistingFilesActionITCase
extends ActionITCaseBase {
    @ParameterizedTest
    @ValueSource(ints={-1, 3})
    public void testAction(int bucket) throws Exception {
        int numPartitions = 2;
        int numFiles = 10;
        int[] numDeletes = new int[numPartitions];
        ListUnexistingFilesTest.prepareRandomlyDeletedTable((String)this.warehouse, (String)"mydb", (String)"t", (int)bucket, (int)numFiles, (int[])numDeletes);
        RemoveUnexistingFilesAction action = this.createAction(RemoveUnexistingFilesAction.class, "remove_unexisting_files", "--warehouse", this.warehouse, "--database", "mydb", "--table", "t", "--dry_run", "true").withParallelism(2);
        int[] actual = new int[numPartitions];
        Pattern pattern = Pattern.compile("pt=(\\d+?)/");
        try (CloseableIterator it = action.buildDataStream().executeAndCollect();){
            while (it.hasNext()) {
                String path = (String)it.next();
                Matcher matcher = pattern.matcher(path);
                if (!matcher.find()) continue;
                int n = Integer.parseInt(matcher.group(1));
                actual[n] = actual[n] + 1;
            }
        }
        Assertions.assertThat((int[])actual).isEqualTo((Object)numDeletes);
        action = this.createAction(RemoveUnexistingFilesAction.class, "remove_unexisting_files", "--warehouse", this.warehouse, "--database", "mydb", "--table", "t").withParallelism(2);
        action.run();
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG mycat WITH (\n  'type' = 'paimon',\n  'warehouse' = '" + this.warehouse + "'\n)");
        tEnv.executeSql("USE CATALOG mycat");
        try (CloseableIterator it = tEnv.executeSql("SELECT pt, CAST(COUNT(*) AS INT) FROM mydb.t GROUP BY pt").collect();){
            while (it.hasNext()) {
                Row row = (Row)it.next();
                Assertions.assertThat((Object)row.getField(1)).isEqualTo((Object)(numFiles - numDeletes[(Integer)row.getField(0)]));
            }
        }
    }
}

