/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.types.Row;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.RollbackToAction;
import org.apache.paimon.flink.action.RollbackToTimestampAction;
import org.apache.paimon.flink.util.ReadWriteTableTestUtil;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class RollbackToActionITCase
extends ActionITCaseBase {
    private static final DataType[] FIELD_TYPES = new DataType[]{DataTypes.BIGINT(), DataTypes.STRING()};
    private static final RowType ROW_TYPE = RowType.of((DataType[])FIELD_TYPES, (String[])new String[]{"k", "v"});

    @BeforeEach
    public void setUp() {
        ReadWriteTableTestUtil.init(this.warehouse);
    }

    @ParameterizedTest
    @ValueSource(strings={"action", "procedure_named", "procedure_indexed"})
    public void rollbackToSnapshotTest(String invoker) throws Exception {
        FileStoreTable table = this.createFileStoreTable(ROW_TYPE, Collections.emptyList(), Collections.singletonList("k"), Collections.emptyList(), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(1L, BinaryString.fromString((String)"Hi")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Hello")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"World")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Flink")));
        switch (invoker) {
            case "action": {
                this.createAction(RollbackToAction.class, "rollback_to", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--version", "2").run();
                break;
            }
            case "procedure_indexed": {
                this.executeSQL(String.format("CALL sys.rollback_to('%s.%s', '', cast(2 as bigint))", this.database, this.tableName));
                break;
            }
            case "procedure_named": {
                this.executeSQL(String.format("CALL sys.rollback_to(`table` => '%s.%s', snapshot_id => cast(2 as bigint))", this.database, this.tableName));
                break;
            }
            default: {
                throw new UnsupportedOperationException(invoker);
            }
        }
        ReadWriteTableTestUtil.testBatchRead("SELECT * FROM `" + this.tableName + "`", Arrays.asList(Row.of((Object[])new Object[]{1L, "Hi"}), Row.of((Object[])new Object[]{2L, "Hello"})));
    }

    @ParameterizedTest
    @ValueSource(strings={"action", "procedure_named", "procedure_indexed"})
    public void rollbackToTagTest(String invoker) throws Exception {
        FileStoreTable table = this.createFileStoreTable(ROW_TYPE, Collections.emptyList(), Collections.singletonList("k"), Collections.emptyList(), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(1L, BinaryString.fromString((String)"Hi")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Apache")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Paimon")));
        table.createTag("tag1", 1L);
        table.createTag("tag2", 2L);
        table.createTag("tag3", 3L);
        switch (invoker) {
            case "action": {
                this.createAction(RollbackToAction.class, "rollback_to", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--version", "tag2").run();
                break;
            }
            case "procedure_indexed": {
                this.executeSQL(String.format("CALL sys.rollback_to('%s.%s', 'tag2')", this.database, this.tableName));
                break;
            }
            case "procedure_named": {
                this.executeSQL(String.format("CALL sys.rollback_to(`table` => '%s.%s', tag => 'tag2')", this.database, this.tableName));
                break;
            }
            default: {
                throw new UnsupportedOperationException(invoker);
            }
        }
        ReadWriteTableTestUtil.testBatchRead("SELECT * FROM `" + this.tableName + "`", Arrays.asList(Row.of((Object[])new Object[]{1L, "Hi"}), Row.of((Object[])new Object[]{2L, "Apache"})));
    }

    @ParameterizedTest
    @ValueSource(strings={"action", "procedure_named", "procedure_indexed"})
    public void rollbackToTimestampTest(String invoker) throws Exception {
        FileStoreTable table = this.createFileStoreTable(ROW_TYPE, Collections.emptyList(), Collections.singletonList("k"), Collections.emptyList(), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(1L, BinaryString.fromString((String)"Hi")));
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Apache")));
        long timestamp = System.currentTimeMillis();
        this.writeData(this.rowData(2L, BinaryString.fromString((String)"Paimon")));
        switch (invoker) {
            case "action": {
                this.createAction(RollbackToTimestampAction.class, "rollback_to_timestamp", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--timestamp", timestamp + "").run();
                break;
            }
            case "procedure_indexed": {
                this.executeSQL(String.format("CALL sys.rollback_to_timestamp('%s.%s', %s)", this.database, this.tableName, timestamp));
                break;
            }
            case "procedure_named": {
                this.executeSQL(String.format("CALL sys.rollback_to_timestamp(`table` => '%s.%s', `timestamp` => %s)", this.database, this.tableName, timestamp));
                break;
            }
            default: {
                throw new UnsupportedOperationException(invoker);
            }
        }
        ReadWriteTableTestUtil.testBatchRead("SELECT * FROM `" + this.tableName + "`", Arrays.asList(Row.of((Object[])new Object[]{1L, "Hi"}), Row.of((Object[])new Object[]{2L, "Apache"})));
    }
}

