/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.aggregation;

import java.util.Collections;
import java.util.List;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class BasicAggregateITCase
extends CatalogITCaseBase {
    @Override
    protected List<String> ddl() {
        return Collections.singletonList("CREATE TABLE T (k INT,v INT,d INT,PRIMARY KEY (k, d) NOT ENFORCED) PARTITIONED BY (d)  WITH ('merge-engine'='aggregation', 'fields.v.aggregate-function'='sum','local-merge-buffer-size'='5m');");
    }

    @Test
    public void testLocalMerge() {
        this.sql("INSERT INTO T VALUES(1, 1, 1), (2, 1, 1), (1, 2, 1)", new Object[0]);
        Assertions.assertThat(this.batchSql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 3, 1}), Row.of((Object[])new Object[]{2, 1, 1})});
    }

    @Test
    public void testMergeRead() {
        this.sql("INSERT INTO T VALUES(1, 1, 1), (2, 1, 1)", new Object[0]);
        this.sql("INSERT INTO T VALUES(1, 2, 1)", new Object[0]);
        Assertions.assertThat(this.batchSql("SELECT * FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 3, 1}), Row.of((Object[])new Object[]{2, 1, 1})});
        Assertions.assertThat(this.batchSql("SELECT * FROM T where v = 3", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 3, 1})});
        Assertions.assertThat(this.batchSql("SELECT * FROM T where v = 1", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{2, 1, 1})});
    }

    @Test
    public void testSequenceFieldWithDefaultAgg() {
        this.sql("CREATE TABLE seq_default_agg ( pk INT PRIMARY KEY NOT ENFORCED, seq INT, v INT) WITH ( 'merge-engine'='aggregation', 'sequence.field'='seq', 'fields.default-aggregate-function'='sum')", new Object[0]);
        this.sql("INSERT INTO seq_default_agg VALUES (0, 1, 1)", new Object[0]);
        this.sql("INSERT INTO seq_default_agg VALUES (0, 2, 2)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM seq_default_agg", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{0, 2, 3})});
    }
}

