/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.aggregation;

import java.util.Collections;
import java.util.List;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class BoolOrAndAggregationITCase
extends CatalogITCaseBase {
    @Override
    protected List<String> ddl() {
        return Collections.singletonList("CREATE TABLE IF NOT EXISTS T7 (j INT, k INT, a BOOLEAN, b BOOLEAN,PRIMARY KEY (j,k) NOT ENFORCED) WITH ('merge-engine'='aggregation', 'fields.a.aggregate-function'='bool_or','fields.b.aggregate-function'='bool_and');");
    }

    @Test
    public void testMergeInMemory() {
        this.batchSql("INSERT INTO T7 VALUES (1, 2, CAST('TRUE' AS  BOOLEAN), CAST('TRUE' AS BOOLEAN)),(1, 2, CAST(NULL AS BOOLEAN), CAST(NULL AS BOOLEAN)), (1, 2, CAST('FALSE' AS BOOLEAN), CAST('FALSE' AS BOOLEAN))", new Object[0]);
        List<Row> result = this.batchSql("SELECT * FROM T7", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, true, false})});
    }

    @Test
    public void testMergeRead() {
        this.batchSql("INSERT INTO T7 VALUES (1, 2, CAST('TRUE' AS  BOOLEAN), CAST('TRUE' AS BOOLEAN))", new Object[0]);
        this.batchSql("INSERT INTO T7 VALUES (1, 2, CAST(NULL AS BOOLEAN), CAST(NULL AS BOOLEAN))", new Object[0]);
        this.batchSql("INSERT INTO T7 VALUES (1, 2, CAST('FALSE' AS BOOLEAN), CAST('FALSE' AS BOOLEAN))", new Object[0]);
        List<Row> result = this.batchSql("SELECT * FROM T7", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, true, false})});
    }

    @Test
    public void testMergeCompaction() {
        this.batchSql("ALTER TABLE T7 SET ('commit.force-compact'='true')", new Object[0]);
        this.batchSql("INSERT INTO T7 VALUES (1, 2, CAST('TRUE' AS  BOOLEAN), CAST('TRUE' AS BOOLEAN))", new Object[0]);
        this.batchSql("INSERT INTO T7 VALUES (1, 2, CAST(NULL AS BOOLEAN), CAST(NULL AS BOOLEAN))", new Object[0]);
        this.batchSql("INSERT INTO T7 VALUES (1, 2, CAST('FALSE' AS BOOLEAN), CAST('FALSE' AS BOOLEAN))", new Object[0]);
        this.batchSql("INSERT INTO T7 VALUES (1, 3, CAST('FALSE' AS  BOOLEAN), CAST('TRUE' AS BOOLEAN))", new Object[0]);
        this.batchSql("INSERT INTO T7 VALUES (1, 3, CAST(NULL AS BOOLEAN), CAST(NULL AS BOOLEAN))", new Object[0]);
        this.batchSql("INSERT INTO T7 VALUES (1, 3, CAST('FALSE' AS BOOLEAN), CAST('TRUE' AS BOOLEAN))", new Object[0]);
        Assertions.assertThat(this.batchSql("SELECT * FROM T7", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, true, false}), Row.of((Object[])new Object[]{1, 3, false, true})});
    }

    @Test
    public void testStreamingRead() {
        Assertions.assertThatThrownBy(() -> this.sEnv.from("T7").execute().print(), (String)"Pre-aggregate continuous reading is not supported", (Object[])new Object[0]);
    }
}

