/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.aggregation;

import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FieldsDefaultAggregationITCase
extends CatalogITCaseBase {
    @Override
    protected int defaultParallelism() {
        return 1;
    }

    @Override
    protected List<String> ddl() {
        return Collections.singletonList("CREATE TABLE IF NOT EXISTS test_default_agg_func (j INT, k INT, a INT, b INT, i DATE,PRIMARY KEY (j,k) NOT ENFORCED) WITH ('merge-engine'='aggregation', 'fields.default-aggregate-function'='first_non_null_value', 'fields.i.aggregate-function'='last_non_null_value');");
    }

    @Test
    public void testMergeInMemory() {
        this.batchSql("CREATE TABLE myTable AS SELECT b, c, d, e, f FROM (VALUES   (1, 1, 2, CAST(NULL AS INT), 4, CAST('2020-01-01' AS DATE)),  (2, 1, 2, 2, CAST(NULL as INT), CAST('2020-01-02' AS DATE)),  (3, 1, 2, 3, 5, CAST(NULL AS DATE))) AS V(a, b, c, d, e, f) ORDER BY a", new Object[0]);
        this.batchSql("INSERT INTO test_default_agg_func SELECT * FROM myTable", new Object[0]);
        List<Row> result = this.batchSql("SELECT * FROM test_default_agg_func", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, 2, 4, LocalDate.of(2020, 1, 2)})});
    }

    @Test
    public void testMergeRead() {
        this.batchSql("INSERT INTO test_default_agg_func VALUES (1, 2, CAST(NULL AS INT), 3, CAST('2020-01-01' AS DATE))", new Object[0]);
        this.batchSql("INSERT INTO test_default_agg_func VALUES (1, 2, 2, CAST(NULL AS INT), CAST('2020-01-02' AS DATE))", new Object[0]);
        this.batchSql("INSERT INTO test_default_agg_func VALUES (1, 2, 3, 5, CAST(NULL AS DATE))", new Object[0]);
        List<Row> result = this.batchSql("SELECT * FROM test_default_agg_func", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, 2, 3, LocalDate.of(2020, 1, 2)})});
    }

    @Test
    public void testMergeCompaction() {
        this.batchSql("ALTER TABLE test_default_agg_func SET ('commit.force-compact'='true')", new Object[0]);
        this.batchSql("INSERT INTO test_default_agg_func VALUES (1, 2, CAST(NULL AS INT), 3, CAST('2020-01-01' AS DATE))", new Object[0]);
        this.batchSql("INSERT INTO test_default_agg_func VALUES (1, 2, 2, CAST(NULL AS INT), CAST('2020-01-02' AS DATE))", new Object[0]);
        this.batchSql("INSERT INTO test_default_agg_func VALUES (1, 2, 3, 5, CAST(NULL AS DATE))", new Object[0]);
        this.batchSql("INSERT INTO test_default_agg_func VALUES (1, 3, 3, 4, CAST('2020-01-01' AS DATE))", new Object[0]);
        this.batchSql("INSERT INTO test_default_agg_func VALUES (1, 3, 2, 6, CAST(NULL AS DATE))", new Object[0]);
        this.batchSql("INSERT INTO test_default_agg_func VALUES (1, 3, CAST(NULL AS INT), CAST(NULL AS INT), CAST('2022-01-02' AS DATE))", new Object[0]);
        Assertions.assertThat(this.batchSql("SELECT * FROM test_default_agg_func", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, 2, 3, LocalDate.of(2020, 1, 2)}), Row.of((Object[])new Object[]{1, 3, 3, 4, LocalDate.of(2022, 1, 2)})});
    }

    @Test
    public void testStreamingRead() {
        Assertions.assertThatThrownBy(() -> this.sEnv.from("test_default_agg_func").execute().print(), (String)"Pre-aggregate continuous reading is not supported", (Object[])new Object[0]);
    }
}

