/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.aggregation;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FirstValueAggregationITCase
extends CatalogITCaseBase {
    @Override
    protected List<String> ddl() {
        return Arrays.asList("CREATE TABLE T (k INT,a INT,b VARCHAR,c VARCHAR,d VARCHAR,PRIMARY KEY (k) NOT ENFORCED) WITH ('merge-engine'='aggregation', 'changelog-producer' = 'full-compaction','fields.b.aggregate-function'='first_value','fields.c.aggregate-function'='first_non_null_value','fields.d.aggregate-function'='first_not_null_value','sequence.field'='a');", "CREATE TABLE T2 (k INT,v STRING,PRIMARY KEY (k) NOT ENFORCED)WITH ('merge-engine' = 'aggregation','fields.v.aggregate-function' = 'first_value','fields.v.ignore-retract' = 'true');");
    }

    @Test
    public void tesInMemoryMerge() {
        this.batchSql("INSERT INTO T VALUES (1, 0, CAST(NULL AS VARCHAR), CAST(NULL AS VARCHAR), CAST(NULL AS VARCHAR)),(1, 1, '1', '1', '1'), (2, 2, '2', '2', '2'),(2, 3, '22', '22', '22')", new Object[0]);
        List<Row> result = this.batchSql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 1, null, "1", "1"}), Row.of((Object[])new Object[]{2, 3, "2", "2", "2"})});
    }

    @Test
    public void tesUnOrderInput() {
        this.batchSql("INSERT INTO T VALUES (1, 0, CAST(NULL AS VARCHAR), CAST(NULL AS VARCHAR), CAST(NULL AS VARCHAR)),(1, 1, '1', '1', '1'), (2, 3, '2', '2', '2'),(2, 2, '22', '22', '22')", new Object[0]);
        List<Row> result = this.batchSql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 1, null, "1", "1"}), Row.of((Object[])new Object[]{2, 3, "22", "22", "22"})});
        this.batchSql("INSERT INTO T VALUES (2, 1, '1', '1', '1')", new Object[0]);
        result = this.batchSql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 1, null, "1", "1"}), Row.of((Object[])new Object[]{2, 3, "1", "1", "1"})});
    }

    @Test
    public void testMergeRead() {
        this.batchSql("INSERT INTO T VALUES (1, 1, CAST(NULL AS VARCHAR), CAST(NULL AS VARCHAR), CAST(NULL AS VARCHAR))", new Object[0]);
        this.batchSql("INSERT INTO T VALUES (1, 2, '1', '1', '1')", new Object[0]);
        this.batchSql("INSERT INTO T VALUES (2, 1, '2', '2', '2')", new Object[0]);
        this.batchSql("INSERT INTO T VALUES (2, 2, '22', '22', '22')", new Object[0]);
        List<Row> result = this.batchSql("SELECT * FROM T", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, null, "1", "1"}), Row.of((Object[])new Object[]{2, 2, "2", "2", "2"})});
    }

    @Test
    public void testAggregatorResetWhenIgnoringRetract() {
        int numRows = 100;
        this.batchSql("INSERT INTO T2 VALUES " + IntStream.range(0, numRows).mapToObj(i -> String.format("(%d, '%d')", i, i)).collect(Collectors.joining(", ")), new Object[0]);
        this.batchSql("INSERT INTO T2 VALUES " + IntStream.range(numRows / 2, numRows).mapToObj(i -> String.format("(%d, '%d')", i, i + numRows)).collect(Collectors.joining(", ")), new Object[0]);
        List<Row> result = this.batchSql("SELECT * FROM T2", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])IntStream.range(0, numRows).mapToObj(i -> Row.of((Object[])new Object[]{i, String.valueOf(i)})).toArray(Row[]::new));
    }
}

