/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.aggregation;

import java.util.Collections;
import java.util.List;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ListAggAggregationITCase
extends CatalogITCaseBase {
    @Override
    protected int defaultParallelism() {
        return 1;
    }

    @Override
    protected List<String> ddl() {
        return Collections.singletonList("CREATE TABLE IF NOT EXISTS T6 (j INT, k INT, a STRING, PRIMARY KEY (j,k) NOT ENFORCED) WITH ('merge-engine'='aggregation', 'fields.a.aggregate-function'='listagg');");
    }

    @Test
    public void testMergeInMemory() {
        this.batchSql("CREATE TABLE myTable AS SELECT b, c, d FROM (VALUES   (1, 1, 2, 'first line'),  (2, 1, 2, CAST(NULL AS STRING)),  (3, 1, 2, 'second line')) AS V(a, b, c, d) ORDER BY a", new Object[0]);
        this.batchSql("INSERT INTO T6 SELECT * FROM myTable", new Object[0]);
        List<Row> result = this.batchSql("SELECT * FROM T6", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, "first line,second line"})});
    }

    @Test
    public void testMergeRead() {
        this.batchSql("INSERT INTO T6 VALUES (1, 2, 'first line')", new Object[0]);
        this.batchSql("INSERT INTO T6 VALUES (1, 2, CAST(NULL AS STRING))", new Object[0]);
        this.batchSql("INSERT INTO T6 VALUES (1, 2, 'second line')", new Object[0]);
        List<Row> result = this.batchSql("SELECT * FROM T6", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, "first line,second line"})});
    }

    @Test
    public void testMergeCompaction() {
        this.batchSql("ALTER TABLE T6 SET ('commit.force-compact'='true')", new Object[0]);
        this.batchSql("INSERT INTO T6 VALUES (1, 2, 'first line')", new Object[0]);
        this.batchSql("INSERT INTO T6 VALUES (1, 2, CAST(NULL AS STRING))", new Object[0]);
        this.batchSql("INSERT INTO T6 VALUES (1, 2, 'second line')", new Object[0]);
        this.batchSql("INSERT INTO T6 VALUES (1, 3, CAST(NULL AS STRING))", new Object[0]);
        this.batchSql("INSERT INTO T6 VALUES (1, 3, CAST(NULL AS STRING))", new Object[0]);
        this.batchSql("INSERT INTO T6 VALUES (1, 3, CAST(NULL AS STRING))", new Object[0]);
        Assertions.assertThat(this.batchSql("SELECT * FROM T6", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, "first line,second line"}), Row.of((Object[])new Object[]{1, 3, null})});
    }

    @Test
    public void testStreamingRead() {
        Assertions.assertThatThrownBy(() -> this.sEnv.from("T6").execute().print(), (String)"Pre-aggregate continuous reading is not supported", (Object[])new Object[0]);
    }
}

