/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.aggregation;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class MaxAggregationITCase
extends CatalogITCaseBase {
    @Override
    protected List<String> ddl() {
        return Collections.singletonList("CREATE TABLE IF NOT EXISTS T2 (j INT, k INT, a INT, b Decimal(4,2), c TINYINT,d SMALLINT,e BIGINT,f FLOAT,h DOUBLE,i DATE,l TIMESTAMP,m CHAR,n VARCHAR,PRIMARY KEY (j,k) NOT ENFORCED) WITH ('merge-engine'='aggregation', 'fields.a.aggregate-function'='max', 'fields.b.aggregate-function'='max', 'fields.c.aggregate-function'='max', 'fields.d.aggregate-function'='max', 'fields.e.aggregate-function'='max', 'fields.f.aggregate-function'='max','fields.h.aggregate-function'='max','fields.i.aggregate-function'='max','fields.l.aggregate-function'='max','fields.m.aggregate-function'='max','fields.n.aggregate-function'='max');");
    }

    @Test
    public void testMergeInMemory() {
        this.batchSql("INSERT INTO T2 VALUES (1, 2, CAST(NULL AS INT), 1.01, CAST(1 AS TINYINT), CAST(-1 AS SMALLINT), CAST(1000 AS BIGINT), 1.11, CAST(1.11 AS DOUBLE), CAST('2020-01-01' AS DATE), CAST('2021-01-01 01:01:01' AS TIMESTAMP), 'a', 'aaa'),(1, 2, 2, 1.10, CAST(2 AS TINYINT), CAST(2 AS SMALLINT), CAST(100000 AS BIGINT), -1.11, CAST(1.21 AS DOUBLE), CAST('2020-01-02' AS DATE), CAST('2022-01-01 01:01:01' AS TIMESTAMP), 'b', 'bbb'), (1, 2, 3, 10.00, CAST(1 AS TINYINT), CAST(1 AS SMALLINT), CAST(10000000 AS BIGINT), 0, CAST(-1.11 AS DOUBLE), CAST('2022-01-02' AS DATE), CAST('2022-01-01 02:00:00' AS TIMESTAMP), 'c', 'ccc')", new Object[0]);
        List<Row> result = this.batchSql("SELECT * FROM T2", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, 3, new BigDecimal("10.00"), (byte)2, (short)2, 10000000L, Float.valueOf(1.11f), 1.21, LocalDate.of(2022, 1, 2), LocalDateTime.of(2022, 1, 1, 2, 0, 0), "c", "ccc"})});
    }

    @Test
    public void testMergeRead() {
        this.batchSql("INSERT INTO T2 VALUES (1, 2, CAST(NULL AS INT), 1.01, CAST(1 AS TINYINT), CAST(-1 AS SMALLINT), CAST(1000 AS BIGINT), 1.11, CAST(1.11 AS DOUBLE), CAST('2020-01-01' AS DATE), CAST('2021-01-01 01:01:01' AS TIMESTAMP), 'a', 'aaa')", new Object[0]);
        this.batchSql("INSERT INTO T2 VALUES (1, 2, 2, 1.10, CAST(2 AS TINYINT), CAST(2 AS SMALLINT), CAST(100000 AS BIGINT), -1.11, CAST(1.21 AS DOUBLE), CAST('2020-01-02' AS DATE), CAST('2022-01-01 01:01:01' AS TIMESTAMP), 'b', 'bbb')", new Object[0]);
        this.batchSql("INSERT INTO T2 VALUES (1, 2, 3, 10.00, CAST(1 AS TINYINT), CAST(1 AS SMALLINT), CAST(10000000 AS BIGINT), 0, CAST(-1.11 AS DOUBLE), CAST('2022-01-02' AS DATE), CAST('2022-01-01 02:00:00' AS TIMESTAMP), 'c', 'ccc')", new Object[0]);
        List<Row> result = this.batchSql("SELECT * FROM T2", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, 3, new BigDecimal("10.00"), (byte)2, (short)2, 10000000L, Float.valueOf(1.11f), 1.21, LocalDate.of(2022, 1, 2), LocalDateTime.of(2022, 1, 1, 2, 0, 0), "c", "ccc"})});
    }

    @Test
    public void testMergeCompaction() {
        this.batchSql("ALTER TABLE T2 SET ('commit.force-compact'='true')", new Object[0]);
        this.batchSql("INSERT INTO T2 VALUES (1, 2, CAST(NULL AS INT), 1.01, CAST(1 AS TINYINT), CAST(-1 AS SMALLINT), CAST(1000 AS BIGINT), 1.11, CAST(1.11 AS DOUBLE), CAST('2020-01-01' AS DATE), CAST('2021-01-01 01:01:01' AS TIMESTAMP), 'a', 'aaa')", new Object[0]);
        this.batchSql("INSERT INTO T2 VALUES (1, 2, 2, 1.10, CAST(2 AS TINYINT), CAST(2 AS SMALLINT), CAST(100000 AS BIGINT), -1.11, CAST(1.21 AS DOUBLE), CAST('2020-01-02' AS DATE), CAST('2022-01-01 01:01:01' AS TIMESTAMP), 'c', 'ccc')", new Object[0]);
        this.batchSql("INSERT INTO T2 VALUES (1, 2, 3, 10.00, CAST(1 AS TINYINT), CAST(1 AS SMALLINT), CAST(10000000 AS BIGINT), 0, CAST(-1.11 AS DOUBLE), CAST('2022-01-02' AS DATE), CAST('2022-01-01 02:00:00' AS TIMESTAMP), 'b', 'bbb')", new Object[0]);
        this.batchSql("INSERT INTO T2 VALUES (1, 3, CAST(NULL AS INT), 1.01, CAST(1 AS TINYINT), CAST(-1 AS SMALLINT), CAST(1000 AS BIGINT), 1.11, CAST(1.11 AS DOUBLE), CAST('2020-01-01' AS DATE), CAST('2021-01-01 01:01:01' AS TIMESTAMP), 'a', 'aaa')", new Object[0]);
        this.batchSql("INSERT INTO T2 VALUES (1, 3, 6, 1.10, CAST(2 AS TINYINT), CAST(2 AS SMALLINT), CAST(100000 AS BIGINT), -1.11, CAST(1.21 AS DOUBLE), CAST('2020-01-02' AS DATE), CAST('2022-01-01 01:01:01' AS TIMESTAMP), 'c', 'ccc')", new Object[0]);
        this.batchSql("INSERT INTO T2 VALUES (1, 3, 3, 10.00, CAST(1 AS TINYINT), CAST(1 AS SMALLINT), CAST(10000000 AS BIGINT), 0, CAST(-1.11 AS DOUBLE), CAST('2022-01-02' AS DATE), CAST('2022-01-01 02:00:00' AS TIMESTAMP), 'b', 'bbb')", new Object[0]);
        Assertions.assertThat(this.batchSql("SELECT * FROM T2", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 2, 3, new BigDecimal("10.00"), (byte)2, (short)2, 10000000L, Float.valueOf(1.11f), 1.21, LocalDate.of(2022, 1, 2), LocalDateTime.of(2022, 1, 1, 2, 0, 0), "c", "ccc"}), Row.of((Object[])new Object[]{1, 3, 6, new BigDecimal("10.00"), (byte)2, (short)2, 10000000L, Float.valueOf(1.11f), 1.21, LocalDate.of(2022, 1, 2), LocalDateTime.of(2022, 1, 1, 2, 0, 0), "c", "ccc"})});
    }

    @Test
    public void testStreamingRead() {
        Assertions.assertThatThrownBy(() -> this.sEnv.from("T2").execute().print(), (String)"Pre-aggregate continuous reading is not supported", (Object[])new Object[0]);
    }
}

