/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.aggregation;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class MergeMapAggregationITCase
extends CatalogITCaseBase {
    @Override
    protected List<String> ddl() {
        return Collections.singletonList("CREATE TABLE test_merge_map(  id INT PRIMARY KEY NOT ENFORCED,  f0 MAP<INT, STRING>) WITH (  'merge-engine' = 'aggregation',  'fields.f0.aggregate-function' = 'merge_map')");
    }

    @Test
    public void testMergeMap() {
        this.sql("INSERT INTO test_merge_map VALUES (1, CAST (NULL AS MAP<INT, STRING>)), (2, MAP[1, 'A']), (3, MAP[1, 'A', 2, 'B'])", new Object[0]);
        List<Row> result = this.queryAndSort("SELECT * FROM test_merge_map");
        this.checkOneRecord(result.get(0), 1, null);
        this.checkOneRecord(result.get(1), 2, this.toMap(1, "A"));
        this.checkOneRecord(result.get(2), 3, this.toMap(1, "A", 2, "B"));
        this.sql("INSERT INTO test_merge_map VALUES (1, MAP[1, 'A']), (2, MAP[1, 'B']), (3, MAP[1, 'a', 2, 'b', 3, 'c'])", new Object[0]);
        result = this.queryAndSort("SELECT * FROM test_merge_map");
        this.checkOneRecord(result.get(0), 1, this.toMap(1, "A"));
        this.checkOneRecord(result.get(1), 2, this.toMap(1, "B"));
        this.checkOneRecord(result.get(2), 3, this.toMap(1, "a", 2, "b", 3, "c"));
    }

    @Test
    public void testRetractInputNull() throws Exception {
        this.sql("CREATE TABLE test_merge_map1 (  id INT PRIMARY KEY NOT ENFORCED,  f0 MAP<INT, STRING>,  f1 INT) WITH (  'changelog-producer' = 'lookup',  'merge-engine' = 'partial-update',  'fields.f0.aggregate-function' = 'merge_map',  'fields.f1.sequence-group' = 'f0')", new Object[0]);
        List<Row> input = Arrays.asList(Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1, null, 1}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1, Collections.singletonMap(1, "A"), 2}), Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{1, null, 1}), Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{1, Collections.singletonMap(2, "B"), 3}));
        this.sEnv.executeSql(String.format("CREATE TEMPORARY TABLE input (  id INT PRIMARY KEY NOT ENFORCED,  f0 MAP<INT, STRING>,  f1 INT) WITH (  'connector' = 'values',  'data-id' = '%s',  'bounded' = 'true',  'changelog-mode' = 'UB,UA')", TestValuesTableFactory.registerData(input))).await();
        this.sEnv.executeSql("INSERT INTO test_merge_map1 SELECT * FROM input").await();
        Assertions.assertThat(this.sql("SELECT * FROM test_merge_map1", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, this.toMap(1, "A", 2, "B"), 3})});
    }

    private Map<Object, Object> toMap(Object ... kvs) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (int i = 0; i < kvs.length; i += 2) {
            result.put(kvs[i], kvs[i + 1]);
        }
        return result;
    }

    private void checkOneRecord(Row row, int id, Map<Object, Object> map) {
        Assertions.assertThat((Object)row.getField(0)).isEqualTo((Object)id);
        if (map == null || map.isEmpty()) {
            Assertions.assertThat((Object)row.getField(1)).isNull();
        } else {
            Assertions.assertThat((Map)((Map)row.getField(1))).containsExactlyInAnyOrderEntriesOf(map);
        }
    }
}

